
#include "DisConnectBalloon.h"
#include <wx/msgdlg.h>
#include "ENMApp.h"
#include "CustomStaticText.h"
#include "ScanNetworkDlg.h"
#include "DataCenter.h"
#include "PolicyManager.h"

#if defined(__WXMSW__)
#include <windows.h>
#endif

#if defined(__WXMSW__)
static wxString bgImage(_T("pic\\balloon_LAN.png"));
static wxString warningImage(_T("pic\\warning.png"));
static wxString closeImage(_T("pic\\close.png"));
#else
static wxString bgImage(_T("pic/balloon_LAN.png"));
static wxString warningImage(_T("pic/warning.png"));
static wxString closeImage(_T("pic/close.png"));
#endif

const long DisConnectBalloon::ID_STATICTEXT_DISCONNECTTIP = wxNewId();
const long DisConnectBalloon::ID_STATICTEXT_SCANNETWORKTIP = wxNewId();
const long DisConnectBalloon::ID_STATICTEXT_DISCONNECTTITLE = wxNewId();
//const long DisConnectBalloon::ID_BTN_CLOSE = wxNewId();
const long DisConnectBalloon::ID_BTN_WARNING = wxNewId();
const long DisConnectBalloon::ID_BTN_LINK = wxNewId();
const int WIDTH = 270;
const int HEIGHT = 140;

BEGIN_EVENT_TABLE(DisConnectBalloon, wxBitmapDialog)
    EVT_INIT_DIALOG(DisConnectBalloon::OnInit)
//    EVT_BUTTON(ID_BTN_CLOSE, DisConnectBalloon::OnButtonClick)
    EVT_HYPERLINK(ID_BTN_LINK, DisConnectBalloon::OnHyperlinkClicked)
END_EVENT_TABLE()

DisConnectBalloon::DisConnectBalloon(wxWindow *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(wxImage(::wxGetApp().strAppPath + bgImage)), dlg, wxEmptyString)
{
#if defined(__WXMSW__)
    m_DisconnectTitle = new CustomStaticText(this, ID_STATICTEXT_DISCONNECTTITLE, _("Connection Failed!"), wxPoint(30,18), wxSize(224,16), 0, _T("ID_STATICTEXT_DISCONNECTTITLE"));
    m_DisconnectTip = new CustomStaticText(this, ID_STATICTEXT_DISCONNECTTIP, _("Failed to connect to"), wxPoint(70,54), wxSize(200,14), 0, _T("ID_STATICTEXT_SUCCTIP"));
	m_ScanNetworkTip = new CustomStaticText(this, ID_STATICTEXT_SCANNETWORKTIP, _("pre-defined network!"), wxPoint(70,72), wxSize(200,14), 0, _T("ID_STATICTEXT_TYPETIP"));
#endif
#if defined(__UNIX__)
    m_DisconnectTitle = new wxStaticText(this, ID_STATICTEXT_DISCONNECTTITLE, _("Connection Failed!"), wxPoint(30,18), wxSize(224,16), 0, _T("ID_STATICTEXT_DISCONNECTTITLE"));
    m_DisconnectTip = new wxStaticText(this, ID_STATICTEXT_DISCONNECTTIP, _("Failed to connect to"), wxPoint(70,54), wxSize(200,14), 0, _T("ID_STATICTEXT_SUCCTIP"));
	m_ScanNetworkTip = new wxStaticText(this, ID_STATICTEXT_SCANNETWORKTIP, _("pre-defined network!"), wxPoint(70,72), wxSize(200,14), 0, _T("ID_STATICTEXT_TYPETIP"));
#endif
    m_DisconnectTitle->SetForegroundColour(wxColor(255, 0, 0));
    wxFont font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_DisconnectTitle->SetFont(font);
	m_btnWarning = new wxBitmapButton(this, ID_BTN_WARNING, wxBitmap(wxImage(::wxGetApp().strAppPath + warningImage)), wxPoint(20,54), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BTN_WARNING"));
//	m_btnClose = new wxBitmapButton(this, ID_BTN_CLOSE, wxBitmap(wxImage(::wxGetApp().strAppPath + closeImage)), wxPoint(230,14), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BTN_CANCEL"));

#if defined(__WXMSW__)
    SetWindowLong((HWND)this->m_hWnd, GWL_EXSTYLE, WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME);
#endif
}

DisConnectBalloon::~DisConnectBalloon()
{
}

void DisConnectBalloon::OnInit(wxInitDialogEvent& event)
{
    const int miniLap = 15;
	wxPoint pos = ::wxGetMousePosition();
    wxRect clientRect = ::wxGetClientDisplayRect();
#if defined(__WXMSW__)
    wxPoint finalPos(clientRect.width - WIDTH - miniLap + clientRect.x, clientRect.height - HEIGHT - miniLap + clientRect.y);
#endif
#if defined(__UNIX__)
    wxPoint finalPos(clientRect.width - WIDTH - miniLap + clientRect.x, clientRect.y + miniLap);
#endif
    this->Move(finalPos);
}

void DisConnectBalloon::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);

    int iWidth = 0, iHeight = 0;
    this->GetClientSize( &iWidth, &iHeight );

    wxPen pen(this->GetForegroundColour());
    dc.SetPen(pen);

    wxBrush brush(this->GetBackgroundColour());
    dc.SetBrush(brush);

    dc.Clear();
    dc.DrawRectangle(0,0,iWidth,iHeight);
}

//void DisConnectBalloon::OnButtonClick(wxCommandEvent& event)
//{
//    this->Show(false);
//}

void DisConnectBalloon::OnHyperlinkClicked(wxHyperlinkEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(NULL, _("The current policy forbids scanning for wireless networks."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }

    if ( DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->IsApplyingProfile() )
    {
        return;
    }

    ScanNetworkDlg* scanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( NULL == scanNetworkDlg )
    {
        return;
    }
    scanNetworkDlg->SetDialogMode(true);
    scanNetworkDlg->Iconize(false);
    scanNetworkDlg->Show();
    scanNetworkDlg->Raise();
    Close();
}

void DisConnectBalloon::SetScanHyperLink()
{
    m_HyperLinkCtrl = new wxHyperlinkCtrl(this, ID_BTN_LINK, _("Click here to scan for networks"), _T(""), wxPoint(60, 95), wxDefaultSize);
    m_HyperLinkCtrl->SetBackgroundColour(wxColour(226, 226, 223));
    m_HyperLinkCtrl->SetNormalColour(wxColour(19, 80, 192));
    m_HyperLinkCtrl->SetHoverColour(wxColour(0, 0, 255));
}




