#ifndef _DATA_CENTER_H
#define _DATA_CENTER_H

#include <wx/event.h>
#include "WlanScanner.h"

#include "net.h"

class ScanNetworkDlg;
class ShareMyInternetDlg;
class UseOtherInternetDlg;
class NetworkManagerDlg;
class ProfileManagerDlg;
class ProfileManagementControl;
class PolicyManager;
class MeshUseOthersInternetDlg;

class DataCenter : public wxEvtHandler
{
public:
    virtual ~DataCenter();
    static DataCenter* GetInstance();
    virtual void InitData();
    virtual void ReloadSchoolPolicy();
    virtual ScanNetworkDlg* GetScanNetworkDlgHandle() { return m_pScanNetworkDlg; }
    virtual NetworkManagerDlg* GetNetworkManagerDlgHandle(){ return m_pNetworkManagerDlg; }
    virtual ProfileManagerDlg* GetProfileManagerDlgHandle(){ return m_pProfileManagerDlg; }
    virtual ProfileManagementControl* GetProfileController() { return m_pProfileController; }
    virtual PolicyManager* GetPolicyManager() { return m_pPolicyManager; }
    virtual MeshUseOthersInternetDlg* GetMeshUseOthersInternetDlgHandle(){return m_pMeshUseOthersInternetDlg;}
    virtual void SessionLock();
    virtual void SessionUnlock(bool disconnect);

    virtual bool EnableNetworkAdapter(ADAPTER_TYPE adapterType, bool bEnable) = 0;
    virtual NETWORK_MODE GetCurrentNetworkMode() = 0;
    virtual const AccessPointList& GetAPList() = 0;
    virtual const APStatus* GetAPStatusFromList(size_t iIndex) = 0;
    virtual WlanResult BeginSearchAP() = 0 ;
    virtual void UpdateCurrentAP(const WlanSsid* pSsid, bool connected) = 0;
    virtual WlanResult ConnectWlanNetwork(const APStatus& apStatus, wxString key, int keyIdx = 0, bool applyProfile = false) = 0;
    virtual bool IsWirelessConnected() = 0;
    virtual APStatus* GetCurrentAPStatus() = 0 ;
    virtual void StartGlobalTimer() = 0;
    virtual void StopGlobalTimer() = 0;
    virtual bool CloseWlanConnection(bool ifScanDlg = false) = 0;
    virtual wxArrayString GetNetworkAdapterName(ADAPTER_TYPE adapterType) = 0;
    virtual wxString GetUsingAdapterName(ADAPTER_TYPE adapterType) = 0;
    virtual bool IsWiredInterfaceConnected() = 0;

    virtual WlanScanner* GetScanner() = 0;
    virtual wxString GetConnectTypeHLAN() = 0;
    virtual bool IsInterfaceEnabled(ADAPTER_TYPE adapterType) = 0;
    virtual void SwitchAdapterParameter(ADAPTER_TYPE adapterTypeDown, ADAPTER_TYPE adapterTypeUp, wxEvtHandler* handler = NULL) = 0;
    virtual void SetShowBalloonFlag(bool isShown) = 0;
    virtual void SetAutoWirelessFlag(bool isAutoWireless) = 0;
    virtual void SetNetworkMode(NETWORK_MODE networkmode) = 0;

protected:
    DataCenter();
    virtual void DestroyData();
    virtual void CreateWnd();

protected:
    static DataCenter* m_pDataCenter;
    NetworkManagerDlg* m_pNetworkManagerDlg;
    ProfileManagerDlg* m_pProfileManagerDlg;
    ScanNetworkDlg* m_pScanNetworkDlg;
    ProfileManagementControl* m_pProfileController;
    PolicyManager* m_pPolicyManager;
    MeshUseOthersInternetDlg* m_pMeshUseOthersInternetDlg;
    bool m_isSessionLocked;

    DECLARE_EVENT_TABLE()
};

#endif // _DATA_CENTER_H
