#include <wx/file.h>
#include "AvahiMulticast.h"
#include<netinet/in.h>
#include<net/if.h>
#include<sys/ioctl.h>
#include <ace/INET_Addr.h>
#include"ENMApp.h"
#include "ProfileVersion.h"
#include "MeshInfoManager.h"

AvahiSimplePoll *AvahiMulticast::m_simple_poll=NULL;

wxString AvahiMulticast::GetProfileVersion()
{
    ProfileVersion profileversion;
    wxArrayString CurrentVersion;

    profileversion.GetProfileVersion(CurrentVersion);
    if(CurrentVersion.Count()>0)
        return CurrentVersion.Item(0);
    else
        return wxT("");
}

int AvahiMulticast::Browse()
{
    static bool browseDelay = true;
    if (browseDelay)
    {
        usleep(30000000);
        browseDelay = false;
    }
    printf("start  avahimulitcast browse \n");

    //m_thread=thread;
    AvahiClient *client = NULL;
    //AvahiServiceTypeBrowser *stb = NULL;
    AvahiServiceBrowser *sb = NULL;
    int error;
    int ret = 1;

    /* Allocate main loop object */
    if (!(m_simple_poll = avahi_simple_poll_new())) {
        fprintf(stderr, "Failed to create simple poll object.\n");
        goto fail;
    }

    /* Allocate a new client */
    client = avahi_client_new(avahi_simple_poll_get(m_simple_poll), (AvahiClientFlags)0, client_callback, NULL, &error);

    /* Check wether creating the client object succeeded */
    if (!client) {
        fprintf(stderr, "Failed to create client: %s\n", avahi_strerror(error));
        goto fail;
    }

    // Create the type service browser
    /*if (!(stb = avahi_service_type_browser_new(client, AVAHI_IF_UNSPEC, AVAHI_PROTO_UNSPEC, NULL, (AvahiLookupFlags)0, type_browser_callback, client))) {
        //fprintf(stderr, "Failed to create service type browser: %s\n", avahi_strerror(avahi_client_errno(client)));
        goto fail;
    }*/

    /* Create the service browser */
    if ( MeshInfoManager::GetInstance()->GetMeshMode() )
    {
        if (!(sb = avahi_service_browser_new(client, AVAHI_IF_UNSPEC, AVAHI_PROTO_UNSPEC, "_nnStudentServer._tcp", NULL, (AvahiLookupFlags)0, browseStudentServer_callback, client)))
        {
            fprintf(stderr, "Failed to create service browser: %s\n", avahi_strerror(avahi_client_errno(client)));
            goto fail;
        }
    }
    else
    {
        if (!(sb = avahi_service_browser_new(client, AVAHI_IF_UNSPEC, AVAHI_PROTO_UNSPEC, "_nnTeacher._tcp", NULL, (AvahiLookupFlags)0, browseTeacher_callback, client)))
        {
            fprintf(stderr, "Failed to create service browser: %s\n", avahi_strerror(avahi_client_errno(client)));
            goto fail;
        }
    }

    /* Run the main loop */
    avahi_simple_poll_loop(m_simple_poll);

    ret = 0;

fail:

    /* Cleanup things */
    /*if (stb)
        avahi_service_type_browser_free(stb);*/
    if (sb)
        avahi_service_browser_free(sb);

    if (client)
        avahi_client_free(client);

    if (m_simple_poll)
        avahi_simple_poll_free(m_simple_poll);

    client = NULL;
    m_simple_poll = NULL;

    printf("free  avahimulitcast\n");

    return ret;
}

void AvahiMulticast::Free()
{
    if (m_simple_poll)
       avahi_simple_poll_quit  ( m_simple_poll )  ;
}

void AvahiMulticast::resolveTeacher_callback(
    AvahiServiceResolver *r,
    AVAHI_GCC_UNUSED AvahiIfIndex interface,
    AVAHI_GCC_UNUSED AvahiProtocol protocol,
    AvahiResolverEvent event,
    const char *name,
    const char *type,
    const char *domain,
    const char *host_name,
    const AvahiAddress *address,
    uint16_t port,
    AvahiStringList *txt,
    AvahiLookupResultFlags flags,
    AVAHI_GCC_UNUSED void* userdata) {

    assert(r);

    /* Called whenever a service has been resolved successfully or timed out */

    switch (event) {
        case AVAHI_RESOLVER_FAILURE:
            fprintf(stderr, "(Resolver) Failed to resolve service '%s' of type '%s' in domain '%s': %s\n", name, type, domain, avahi_strerror(avahi_client_errno(avahi_service_resolver_get_client(r))));
            break;

        case AVAHI_RESOLVER_FOUND:
        {
            char a[AVAHI_ADDRESS_STR_MAX];
            unsigned char *deployAddress;

            avahi_address_snprint(a, sizeof(a), address);
            bool ipv4 = true;

            for(int i=0; i<6; i++)
            {
                if(a[i]==':')
                {
                    ipv4 = false;
                    printf("IPv6 address %s.\n", a);
                    break;
                }
            }

            bool bVersionEqual = false;

            //check whether has the certificate
            wxString wxfilepath;
            wxfilepath = ::wxGetApp().strAppPath + wxT("cacert.pem");
            bool CAfile = wxFile::Exists(wxfilepath);

            if (!CAfile)
            {
                printf("Don't have CA\n");
                wxGetApp().StartDeploy(a);
            }

            else if((txt!=NULL)&&ipv4)
            {
//                deployAddress = avahi_string_list_to_string(txt);avahi_string_list_get_text(
                deployAddress = avahi_string_list_get_text(txt);
                if (2<=avahi_string_list_length(txt))
				{
					AvahiStringList *stringlist = avahi_string_list_get_next(txt);
					unsigned char *remoteVersion = avahi_string_list_get_text(stringlist);
					wxString wxRemoteVersion((const char *)remoteVersion, wxConvUTF8);

					//get profile version and compare it with student's profile version
                    wxString wxLocalVersion = GetProfileVersion();
                    if ((wxLocalVersion.Cmp(wxRemoteVersion)==0))
					{
                        bVersionEqual = true;
					}
				}
//                memcpy(deployAddress,(sizeof(deployAddress)-2),deployAddress+1);
//                int length = 0 ;
                bool bIPExist = false;
//                char localIP[64];
//                Get_ip(length, localIP);
                char seps[]   = "@";

                //get local IP address
                ACE_INET_Addr   *the_addr_array;
                size_t   count   =   0;
                ACE::get_ip_interfaces(count,the_addr_array);
                char sz[MAXHOSTNAMELEN];
                the_addr_array->addr_to_string(sz,MAXHOSTNAMELEN);
                char   address[30];

                printf("deployAddress %s\n", deployAddress);

                while   (count--)
                {
                    the_addr_array->addr_to_string(address,   sizeof(address));

                    //strcat(address, ":0|");
                    if(strcmp(address,"127.0.0.1:0")==0)
                    {
                        ++the_addr_array;
                        continue;
                    }

                    bIPExist = FindIP((const char *)deployAddress,address,seps);
                    if (bIPExist&&!bVersionEqual)
                    {
                        wxGetApp().StartDeploy(a);
                        printf("[Client]IP Exist\n");
                        break;
                    }
                    else
                    {
                        printf("[Client]IP isn't Exist\n");

                    }
                    ++the_addr_array;
                }

            }
        }
    }
    avahi_service_resolver_free(r);
}

void AvahiMulticast::resolveStudentServer_callback(
    AvahiServiceResolver *r,
    AVAHI_GCC_UNUSED AvahiIfIndex interface,
    AVAHI_GCC_UNUSED AvahiProtocol protocol,
    AvahiResolverEvent event,
    const char *name,
    const char *type,
    const char *domain,
    const char *host_name,
    const AvahiAddress *address,
    uint16_t port,
    AvahiStringList *txt,
    AvahiLookupResultFlags flags,
    AVAHI_GCC_UNUSED void* userdata)
    {

    assert(r);

    /* Called whenever a service has been resolved successfully or timed out */

    switch (event)
    {
        case AVAHI_RESOLVER_FAILURE:
            fprintf(stderr, "(Resolver) Failed to resolve service '%s' of type '%s' in domain '%s': %s\n", name, type, domain, avahi_strerror(avahi_client_errno(avahi_service_resolver_get_client(r))));
            break;

        case AVAHI_RESOLVER_FOUND:
        {
            char a[AVAHI_ADDRESS_STR_MAX];
            //cjeck whether the address is IPv4
            avahi_address_snprint(a, sizeof(a), address);
            bool ipv4 = true;

            for(int i=0; i<6; i++)
            {
                if(a[i]==':')
                {
                    ipv4 = false;
                    printf("IPv6 address %s.\n", a);
                    break;
                }
            }

            //check whether it has found itself
            bool bIPExist = false;
            char discoverAddress[20];
            memset(discoverAddress,0,sizeof(discoverAddress));
            strcat(discoverAddress, a);
            strcat(discoverAddress, ":0");
            printf("discoverAddress %s\n", discoverAddress);

            ACE_INET_Addr   *the_addr_array;
            size_t   count   =   0;
            ACE::get_ip_interfaces(count,the_addr_array);
            char sz[MAXHOSTNAMELEN];
            the_addr_array->addr_to_string(sz,MAXHOSTNAMELEN);
            char   address[30];

            while   (count--)
            {
                the_addr_array->addr_to_string(address,   sizeof(address));

                if(strcmp(address,"127.0.0.1:0")==0)
                {
                    ++the_addr_array;
                    continue;
                }

                if (strcmp(address, discoverAddress)==0)
                {
                    printf("[Client]Local Server\n");
                    return;
                }
                else
                {
                    printf("[Client]Not Local Server\n");

                }
                ++the_addr_array;
            }

            //Get StringList
            printf("length of AvahiStringList: %d\n", avahi_string_list_length(txt));
            if ( 5<=avahi_string_list_length(txt) )
            {
                MeshServerEntity meshEntity;
                //get ServiceName
                wxString wxServiceName(name, wxConvUTF8);
                meshEntity.SetServiceName(wxServiceName);

                //get MeshIP
                unsigned char *sMeshIP = avahi_string_list_get_text(txt);
                wxString wxMeshIP((const char *)sMeshIP, wxConvUTF8);
                meshEntity.SetIPAddress(wxMeshIP);
                printf("sMeshIP: %s\n", sMeshIP);
                //get MeshHostName
                AvahiStringList *stringlist = avahi_string_list_get_next(txt);
                unsigned char *sMeshHostName = avahi_string_list_get_text(stringlist);
                wxString wxMeshHostName((const char *)sMeshHostName, wxConvUTF8);
                meshEntity.SetHostName(wxMeshHostName);
                printf("sMeshHostName: %s\n", sMeshHostName);
                //get MeshMainDNS
                stringlist = avahi_string_list_get_next(stringlist);
                unsigned char *sMeshMainDNS = avahi_string_list_get_text(stringlist);
                wxString wxMeshMainDNS((const char *)sMeshMainDNS, wxConvUTF8);
                meshEntity.SetDNS(wxMeshMainDNS);
                printf("sMeshMainDNS: %s\n", sMeshMainDNS);
                //get MeshSecondaryDNS
                stringlist = avahi_string_list_get_next(stringlist);
                unsigned char *sMeshSecondaryDNS = avahi_string_list_get_text(stringlist);
                wxString wxMeshSecondaryDNS((const char *)sMeshSecondaryDNS, wxConvUTF8);
                meshEntity.SetDNS_back(wxMeshSecondaryDNS);
                printf("sMeshSecondaryDNS: %s\n", sMeshSecondaryDNS);
                //get Channal
                stringlist = avahi_string_list_get_next(stringlist);
                unsigned char *sChannal = avahi_string_list_get_text(stringlist);
                meshEntity.SetChannel( atoi((const char *)sChannal) );

                //return struct
                MeshInfoManager::GetInstance()->ModifyMeshServer(meshEntity);
                printf("After ModifyMeshServer\n");

            }


        }
    }
    avahi_service_resolver_free(r);
}

void AvahiMulticast::browseTeacher_callback(
    AvahiServiceBrowser *b,
    AvahiIfIndex interface,
    AvahiProtocol protocol,
    AvahiBrowserEvent event,
    const char *name,
    const char *type,
    const char *domain,
    AVAHI_GCC_UNUSED AvahiLookupResultFlags flags,
    void* userdata) {

    AvahiClient *c = (AvahiClient *)userdata;
    assert(b);

    /* Called whenever a new services becomes available on the LAN or is removed from the LAN */

    switch (event) {
        case AVAHI_BROWSER_FAILURE:

            //fprintf(stderr, "(Browser) %s\n", avahi_strerror(avahi_client_errno(avahi_service_browser_get_client(b))));
            avahi_simple_poll_quit(m_simple_poll);
            return;

        case AVAHI_BROWSER_NEW:
            //fprintf(stderr, "(Browser) NEW: service '%s' of type '%s' in domain '%s'\n", name, type, domain);

//            if (!(avahi_service_resolver_new(c, interface, protocol, name, type, domain, AVAHI_PROTO_UNSPEC, (AvahiLookupFlags)0, resolveTeacher_callback, c)))
//                fprintf(stderr, "Failed to resolve service '%s': %s\n", name, avahi_strerror(avahi_client_errno(c)));

            break;

        case AVAHI_BROWSER_REMOVE:
            //fprintf(stderr, "(Browser) REMOVE: service '%s' of type '%s' in domain '%s'\n", name, type, domain);
            break;

        case AVAHI_BROWSER_ALL_FOR_NOW:
           //if ( m_thread->TestDestroy() )
             //   avahi_m_simple_poll_quit(m_simple_poll);
            break;
        case AVAHI_BROWSER_CACHE_EXHAUSTED:
            //fprintf(stderr, "(Browser) %s\n", event == AVAHI_BROWSER_CACHE_EXHAUSTED ? "CACHE_EXHAUSTED" : "ALL_FOR_NOW");
            break;
    }
}

void AvahiMulticast::browseStudentServer_callback(
    AvahiServiceBrowser *b,
    AvahiIfIndex interface,
    AvahiProtocol protocol,
    AvahiBrowserEvent event,
    const char *name,
    const char *type,
    const char *domain,
    AVAHI_GCC_UNUSED AvahiLookupResultFlags flags,
    void* userdata) {

    AvahiClient *c = (AvahiClient *)userdata;
    assert(b);

    /* Called whenever a new services becomes available on the LAN or is removed from the LAN */

    switch (event) {
        case AVAHI_BROWSER_FAILURE:

            //fprintf(stderr, "(Browser) %s\n", avahi_strerror(avahi_client_errno(avahi_service_browser_get_client(b))));
            avahi_simple_poll_quit(m_simple_poll);
            return;

        case AVAHI_BROWSER_NEW:
            //fprintf(stderr, "(Browser) NEW: service '%s' of type '%s' in domain '%s'\n", name, type, domain);

            if (!(avahi_service_resolver_new(c, interface, protocol, name, type, domain, AVAHI_PROTO_UNSPEC, (AvahiLookupFlags)0, resolveStudentServer_callback, c)))
                fprintf(stderr, "Failed to resolve service '%s': %s\n", name, avahi_strerror(avahi_client_errno(c)));

            break;

        case AVAHI_BROWSER_REMOVE:
            {
            printf("Remove client-------------- \n");
            //fprintf(stderr, "(Browser) REMOVE: service '%s' of type '%s' in domain '%s'\n", name, type, domain);
            wxString wxServiceName(name, wxConvUTF8);
            MeshInfoManager::GetInstance()->RemoveMeshServer(wxServiceName);
            printf("Service Name: %s\n", name);

            break;
            }


        case AVAHI_BROWSER_ALL_FOR_NOW:
           //if ( m_thread->TestDestroy() )
             //   avahi_m_simple_poll_quit(m_simple_poll);
            break;
        case AVAHI_BROWSER_CACHE_EXHAUSTED:
            //fprintf(stderr, "(Browser) %s\n", event == AVAHI_BROWSER_CACHE_EXHAUSTED ? "CACHE_EXHAUSTED" : "ALL_FOR_NOW");
            break;
    }
}

void AvahiMulticast::client_callback(AvahiClient *c, AvahiClientState state, AVAHI_GCC_UNUSED void * userdata)
{
    assert(c);

    if (state == AVAHI_CLIENT_FAILURE)
    {
        avahi_simple_poll_quit(m_simple_poll);
    }
}

bool AvahiMulticast::FindIP(const char*szList, char* szIP,char* szSeps)
{
    char *token;

    //printf( "%s\n\nTokens:\n", szList );
    char  list[100];
    strcpy(list, szList);
   /* Establish string and get the first token: */
   token = strtok( list, szSeps );
   while( token != NULL )
   {
      /* While there are tokens in "string" */
      printf( " token %s ip %s\n", token,szIP );

      if(strcmp(token,szIP)==0)
          return true;

      /* Get next token: */
      token = strtok( NULL, szSeps );
   }

   return false;

}
