/* $Id$ */

/***
  This file is part of avahi.

  avahi is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  avahi is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General
  Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with avahi; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA.
***/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <avahi-client/client.h>
#include <avahi-client/publish.h>

#include <avahi-common/alternative.h>
#include <avahi-common/simple-watch.h>
#include <avahi-common/malloc.h>
#include <avahi-common/error.h>
#include <avahi-common/timeval.h>
#include <wx/thread.h>
#include <wx/utils.h>
#include <wx/file.h>
#include "LGetMAC.h"
#include "ProfileVersion.h"
#include "MeshServerEntity.h"
#include "MeshInfoManager.h"
#include "ENMUtil.h"



static AvahiEntryGroup *group = NULL;
static AvahiSimplePoll *simple_poll = NULL;
static char *name = NULL;
//static wxCriticalSection m_Avahicritsect;

static void create_services(AvahiClient *c);

static void entry_group_callback(AvahiEntryGroup *g, AvahiEntryGroupState state, AVAHI_GCC_UNUSED void *userdata) {
    assert(g == group || group == NULL);
    group = g;

    /* Called whenever the entry group state changes */

    switch (state) {
        case AVAHI_ENTRY_GROUP_ESTABLISHED :
            /* The entry group has been established successfully */
            fprintf(stderr, "Service '%s' successfully established.\n", name);
            break;

        case AVAHI_ENTRY_GROUP_COLLISION : {
            char *n;

            /* A service name collision with a remote service
             * happened. Let's pick a new name */
            n = avahi_alternative_service_name(name);
            avahi_free(name);
            name = n;

            fprintf(stderr, "Service name collision, renaming service to '%s'\n", name);

            /* And recreate the services */
            create_services(avahi_entry_group_get_client(g));
            break;
        }

        case AVAHI_ENTRY_GROUP_FAILURE :

            fprintf(stderr, "Entry group failure: %s\n", avahi_strerror(avahi_client_errno(avahi_entry_group_get_client(g))));

            /* Some kind of failure happened while we were registering our services */
            avahi_simple_poll_quit(simple_poll);
            break;

        case AVAHI_ENTRY_GROUP_UNCOMMITED:
        case AVAHI_ENTRY_GROUP_REGISTERING:
            ;
    }
}

static void create_services(AvahiClient *c) {
    char *n, r[128];
    int ret;
    assert(c);

    /* If this is the first time we're called, let's create a new
     * entry group if necessary */

//group = NULL;
    if (!group)
        if (!(group = avahi_entry_group_new(c, entry_group_callback, NULL))) {
            fprintf(stderr, "avahi_entry_group_new() failed: %s\n", avahi_strerror(avahi_client_errno(c)));
            goto fail;
        }

    /* If the group is empty (either because it was just created, or
     * because it was reset previously, add our entries.  */

    if (avahi_entry_group_is_empty(group)) {
        fprintf(stderr, "Adding service '%s'\n", name);

        /* Create some random TXT data */
        snprintf(r, sizeof(r), "random=%i", rand());

        /* We will now add two services and one subtype to the entry
         * group. The two services have the same name, but differ in
         * the service type (IPP vs. BSD LPR). Only services with the
         * same name should be put in the same entry group. */

        /* Add the service for IPP */
        /*if ((ret = avahi_entry_group_add_service(group, AVAHI_IF_UNSPEC, AVAHI_PROTO_UNSPEC, (AvahiPublishFlags)0, name, "_nn._tcp", NULL, NULL, 651, "test=blah", r, NULL)) < 0) {

            if (ret == AVAHI_ERR_COLLISION)
                goto collision;

            fprintf(stderr, "Failed to add _ipp._tcp service: %s\n", avahi_strerror(ret));
            goto fail;
        }*/

        wxString wxServiceName = ::wxGetHostName();
        char serviceName[100] = "S";
        strcpy(serviceName, wxServiceName.mb_str(wxConvUTF8));

        //add mash parameters
        //initial mesh struct
        MeshServerEntity meshEntity;
        if( MeshInfoManager::GetInstance()->GetMeshServerInfo(meshEntity) )
        {
            printf("mesh is turning on \n");
            AvahiStringList *stringlist=avahi_string_list_new(NULL);
            stringlist=avahi_string_list_add( stringlist, meshEntity.GetMeshIPAddress().mb_str(wxConvUTF8) );
            stringlist=avahi_string_list_add( stringlist, meshEntity.GetHostName().mb_str(wxConvUTF8) );
            stringlist=avahi_string_list_add( stringlist, meshEntity.GetDNS().mb_str(wxConvUTF8) );
            stringlist=avahi_string_list_add( stringlist, meshEntity.GetDNS_back().mb_str(wxConvUTF8) );
            int dChannel = meshEntity.GetChannel();
            char sChannel[10];
            sprintf(sChannel,"%d",dChannel);
            stringlist=avahi_string_list_add( stringlist, sChannel );
            printf("Get mesh server info\n");

//            AvahiStringList *stringlist=avahi_string_list_new(meshEntity.GetMeshIPAddress().mb_str(wxConvUTF8),
//                                                            meshEntity.GetHostName().mb_str(wxConvUTF8),
//                                                            meshEntity.GetDNS().mb_str(wxConvUTF8),
//                                                            meshEntity.GetDNS_back().mb_str(wxConvUTF8),
//                                                            sChannel,
//                                                            NULL);
//            AvahiStringList *stringlist=avahi_string_list_new("1","2","3","4","5",NULL);
            printf("avahi_string_list_new\n");
            if ((ret = avahi_entry_group_add_service_strlst(group, AVAHI_IF_UNSPEC, AVAHI_PROTO_UNSPEC, (AvahiPublishFlags)0, serviceName, "_nnStudentServer._tcp", NULL, NULL, 651, stringlist)) < 0)
            {
                printf("ret < 0\n");
                if (ret == AVAHI_ERR_COLLISION)
                    goto collision;

                fprintf(stderr, "Failed to add _ipp._tcp service: %s\n", avahi_strerror(ret));
                goto fail;
            }
        }
        else
        {
            //get mac address
            GetMAC getmac;
            char* macaddress = getmac.GetLocalMACAddress();
            printf("after getmac: %s\n", macaddress);

            //Get Profile Version
            ProfileVersion profileversion;
            wxArrayString CurrentVersion;
            //char pversion[20];
            bool hasversion = profileversion.GetProfileVersion(CurrentVersion);
            fprintf(stderr, "profileversion.GetProfileVersion() \n");

            char profileVersion[20];
            if (hasversion)
            {
                strcpy(profileVersion, CurrentVersion.Item(0).mb_str(wxConvUTF8));
            }
            else
            {
                strcpy(profileVersion, " ");
            }


            //check whether have CA
            wxString wxfilepath;
            wxfilepath = ENMUtil::m_appPath + wxT("cacert.pem");
            char CAfile[10];
            if (wxFile::Exists(wxfilepath))
            {
        //        strcpy(profileVersion, "1");
                strcat(macaddress, "@1");
            }
            else
            {
        //        strcpy(profileVersion, "0");
                strcat(macaddress, "@0");
            }


            AvahiStringList *stringlist=avahi_string_list_new(macaddress, profileVersion, NULL);

            if ((ret = avahi_entry_group_add_service_strlst(group, AVAHI_IF_UNSPEC, AVAHI_PROTO_UNSPEC, (AvahiPublishFlags)0, serviceName, "_nnStudent._tcp", NULL, NULL, 651, stringlist)) < 0)
            {
                printf("ret < 0\n");
                if (ret == AVAHI_ERR_COLLISION)
                    goto collision;

                fprintf(stderr, "Failed to add _ipp._tcp service: %s\n", avahi_strerror(ret));
                goto fail;
            }
        }

        fprintf(stderr, "Service '%s' successfully established.\n", serviceName);

        /* Add the same service for BSD LPR */
        /*if ((ret = avahi_entry_group_add_service(group, AVAHI_IF_UNSPEC, AVAHI_PROTO_UNSPEC, (AvahiPublishFlags)0, name, "_printer._tcp", NULL, NULL, 515, NULL)) < 0) {

            if (ret == AVAHI_ERR_COLLISION)
                goto collision;

            fprintf(stderr, "Failed to add _printer._tcp service: %s\n", avahi_strerror(ret));
            goto fail;
        }*/

        /* Add an additional (hypothetic) subtype */
        /*if ((ret = avahi_entry_group_add_service_subtype(group, AVAHI_IF_UNSPEC, AVAHI_PROTO_UNSPEC, (AvahiPublishFlags)0, name, "_nn._tcp", NULL, "_magic._sub._printer._tcp") < 0)) {
            fprintf(stderr, "Failed to add subtype _magic._sub._printer._tcp: %s\n", avahi_strerror(ret));
            goto fail;
        }*/

        /* Tell the server to register the service */
        if ((ret = avahi_entry_group_commit(group)) < 0) {
            fprintf(stderr, "Failed to commit entry group: %s\n", avahi_strerror(ret));
            goto fail;
        }
        printf("Service successfully established.\n");
    }

    return;

collision:

    /* A service name collision with a local service happened. Let's
     * pick a new name */
    n = avahi_alternative_service_name(name);
    avahi_free(name);
    name = n;

    fprintf(stderr, "Service name collision, renaming service to '%s'\n", name);

    avahi_entry_group_reset(group);

    create_services(c);
    return;

fail:
    avahi_simple_poll_quit(simple_poll);
}





static void client_callback(AvahiClient *c, AvahiClientState state, AVAHI_GCC_UNUSED void * userdata) {
    assert(c);

    /* Called whenever the client or server state changes */

    switch (state) {
        case AVAHI_CLIENT_S_RUNNING:

            /* The server has startup successfully and registered its host
             * name on the network, so it's time to create our services */
            create_services(c);
            break;

        case AVAHI_CLIENT_FAILURE:

            fprintf(stderr, "Client failure: %s\n", avahi_strerror(avahi_client_errno(c)));
            avahi_simple_poll_quit(simple_poll);

            break;

        case AVAHI_CLIENT_S_COLLISION:

            /* Let's drop our registered services. When the server is back
             * in AVAHI_SERVER_RUNNING state we will register them
             * again with the new host name. */
            break;

        case AVAHI_CLIENT_S_REGISTERING:

            /* The server records are now being established. This
             * might be caused by a host name change. We need to wait
             * for our own records to register until the host name is
             * properly esatblished. */

            if (group)
                avahi_entry_group_reset(group);

            break;

        case AVAHI_CLIENT_CONNECTING:
            ;
    }
}

static void freeAvahi()
{
    if (simple_poll)
       avahi_simple_poll_quit  ( simple_poll )  ;
}

static int publishAvahi()
{
//    printf("m_Avahicritsect.Enter\n");
//
//    m_Avahicritsect.Enter();

    AvahiClient *client = NULL;
    int error;
    int ret = 1;
//    struct timeval tv;

    /* Allocate main loop object */
    if (!(simple_poll = avahi_simple_poll_new())) {
        fprintf(stderr, "Failed to create simple poll object.\n");
        goto fail;
    }

    name = avahi_strdup("ServiceName");

    /* Allocate a new client */
    client = avahi_client_new(avahi_simple_poll_get(simple_poll), (AvahiClientFlags)0, client_callback, NULL, &error);

    /* Check wether creating the client object succeeded */
    if (!client) {
        fprintf(stderr, "Failed to create client: %s\n", avahi_strerror(error));
        goto fail;
    }

    /* Run the main loop */
    avahi_simple_poll_loop(simple_poll);

    ret = 0;

//    m_Avahicritsect.Leave();
    printf("avahipublish end\n");


fail:

    /* Cleanup things */

    if (client)
        avahi_client_free(client);

    if (simple_poll)
        avahi_simple_poll_free(simple_poll);

    avahi_free(name);

    group = NULL;
    client = NULL;
    name = NULL;
    simple_poll = NULL;

//    m_Avahicritsect.Leave();
//
//    printf("m_Avahicritsect.Leave \n");

    return ret;
}



