/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#ifndef NMN_APPLET_H
#define NMN_APPLET_H

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define NMN_TYPE_APPLET            (nmn_applet_get_type ())
#define NMN_APPLET(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NMN_TYPE_APPLET, NmnApplet))
#define NMN_APPLET_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NMN_TYPE_APPLET, NmnAppletClass))
#define NMN_IS_APPLET(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NMN_TYPE_APPLET))
#define NMN_IS_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NMN_TYPE_APPLET))
#define NMN_APPLET_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NMN_TYPE_APPLET, NmnAppletClass))

typedef struct {
    GObject parent;
} NmnApplet;

typedef struct {
    GObjectClass parent;
} NmnAppletClass;

GType nmn_applet_get_type (void);

NmnApplet *nmn_applet_new             (void);
GtkStatusIcon *nmn_applet_get_status_icon (NmnApplet *applet);
GtkWidget     *nmn_applet_get_plug        (NmnApplet *applet);
void           nmn_applet_set_visible     (NmnApplet *applet,
                                           gboolean visible);

G_END_DECLS

#endif /* NMN_APPLET_H */
