/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <gtk/gtk.h>
#include "nmn-applet.h"
#include "nmn-icon-cache.h"
#include "utils.h"

#include "moblin-netbook-system-tray.h"

static void
embedded_callback (GObject *plug,
                   GParamSpec *pspec,
                   gpointer user_data)
{
    NmnApplet *applet = NMN_APPLET (user_data);
    GtkWidget *w = GTK_WIDGET (plug);
    gboolean embedded;

    g_object_get (plug, "embedded", &embedded, NULL);
    gtk_widget_modify_bg (w, GTK_STATE_NORMAL, &gtk_widget_get_style (w)->white);
    nmn_applet_set_visible (applet, embedded);
}

int
main (int argc, char *argv[])
{
    NmnApplet *applet;
    GtkStatusIcon *status_icon;
    GtkWidget *plug;

    gtk_init (&argc, &argv);

    /* Force to the moblin theme */
    gtk_settings_set_string_property (gtk_settings_get_default (),
                                      "gtk-theme-name",
                                      "Moblin-Netbook",
                                      NULL);

    applet = nmn_applet_new ();
    plug = nmn_applet_get_plug (applet);
    utils_set_main_widget (plug);
    status_icon = nmn_applet_get_status_icon (applet);
    g_signal_connect (plug,
                      "notify::embedded",
                      (GCallback) embedded_callback,
                      applet);

    mnbk_system_tray_init (status_icon, GTK_PLUG (plug), "wifi");
    gtk_main ();

    g_object_unref (applet);
    nmn_icon_cache_invalidate ();

    return 0;
}
