/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "nl-favorites-loader.h"

G_DEFINE_TYPE (NlFavoritesLoader, nl_favorites_loader,
               G_TYPE_OBJECT);

/* GObject stuff */
static void
nl_favorites_loader_class_init (NlFavoritesLoaderClass *klass)
{
}

static void
nl_favorites_loader_init (NlFavoritesLoader *self)
{
}

/*
 * Public Class
 */
gboolean
nl_favorites_loader_handles_type (NlFavoritesLoader *self,
                                  const gchar             *type)
{
  NlFavoritesLoaderClass *klass;

  g_return_val_if_fail (NL_IS_FAVORITES_LOADER (self), FALSE);
  klass = NL_FAVORITES_LOADER_GET_CLASS (self);

  if (klass->handles_type)
    return klass->handles_type (self, type);

  return FALSE;
}

NlFavorite *
nl_favorites_loader_load (NlFavoritesLoader *self,
                          const gchar             *uid)
{
  NlFavoritesLoaderClass *klass;

  g_return_val_if_fail (NL_IS_FAVORITES_LOADER (self), NULL);
  g_return_val_if_fail (uid, NULL);
  klass = NL_FAVORITES_LOADER_GET_CLASS (self);

  if (klass->load)
    return klass->load (self, uid);

  return NULL;
}

gchar *
nl_favorites_loader_uid_for_path (NlFavoritesLoader *self,
                                  const gchar       *path)
{
  NlFavoritesLoaderClass *klass;

  g_return_val_if_fail (NL_IS_FAVORITES_LOADER (self), NULL);
  g_return_val_if_fail (path, NULL);
  klass = NL_FAVORITES_LOADER_GET_CLASS (self);

  if (klass->uid_for_path)
    return klass->uid_for_path (self, path);

  return NULL;
}
