/*
 * nl-texture-frame.h: Expandible texture actor
 *
 * Copyright 2007, 2008 OpenedHand Ltd
 * Copyright 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NL_TEXTURE_FRAME_H__
#define __NL_TEXTURE_FRAME_H__

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define NL_TYPE_TEXTURE_FRAME                 (nl_texture_frame_get_type ())
#define NL_TEXTURE_FRAME(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), NL_TYPE_TEXTURE_FRAME, NlTextureFrame))
#define NL_TEXTURE_FRAME_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), NL_TYPE_TEXTURE_FRAME, NlTextureFrameClass))
#define NL_IS_TEXTURE_FRAME(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NL_TYPE_TEXTURE_FRAME))
#define NL_IS_TEXTURE_FRAME_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), NL_TYPE_TEXTURE_FRAME))
#define NL_TEXTURE_FRAME_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), NL_TYPE_TEXTURE_FRAME, NlTextureFrameClass))

typedef struct _NlTextureFrame                NlTextureFrame;
typedef struct _NlTextureFramePrivate         NlTextureFramePrivate;
typedef struct _NlTextureFrameClass           NlTextureFrameClass;

/**
 * NlTextureFrame:
 *
 * The contents of this structure are private and should only be accessed
 * through the public API.
 */
struct _NlTextureFrame
{
  /*< private >*/
  ClutterActor parent_instance;
  
  NlTextureFramePrivate    *priv;
};

struct _NlTextureFrameClass 
{
  ClutterActorClass parent_class;

  /* padding for future expansion */
  void (*_clutter_box_1) (void);
  void (*_clutter_box_2) (void);
  void (*_clutter_box_3) (void);
  void (*_clutter_box_4) (void);
}; 

GType           nl_texture_frame_get_type           (void) G_GNUC_CONST;
ClutterActor *  nl_texture_frame_new                (ClutterTexture   *texture,
                                                       gfloat            top,
                                                       gfloat            right,
                                                       gfloat            bottom,
                                                       gfloat            left);
void            nl_texture_frame_set_parent_texture (NlTextureFrame *frame,
                                                       ClutterTexture   *texture);
ClutterTexture *nl_texture_frame_get_parent_texture (NlTextureFrame *frame);
void            nl_texture_frame_set_frame          (NlTextureFrame *frame,
                                                       gfloat            top,
                                                       gfloat            right,
                                                       gfloat            bottom,
                                                       gfloat            left);
void            nl_texture_frame_get_frame          (NlTextureFrame *frame,
                                                       gfloat           *top,
                                                       gfloat           *right,
                                                       gfloat           *bottom,
                                                       gfloat           *left);

G_END_DECLS

#endif /* __NL_TEXTURE_FRAME_H__ */
