/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include "clutter-drag-dest.h"

#include "clutter-drag-server.h"


G_DEFINE_TYPE (ClutterDragDest, clutter_drag_dest, CLUTTER_TYPE_GROUP);

#define CLUTTER_DRAG_DEST_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  CLUTTER_TYPE_DRAG_DEST, \
  ClutterDragDestPrivate))

struct _ClutterDragDestPrivate
{
  gboolean success;
};

enum
{
  DROP,

  LAST_SIGNAL
};
static guint _dest_signals[LAST_SIGNAL] = {0};

void   
clutter_drag_dest_finish (ClutterDragDest *dest,
                          gboolean         success)
{
  g_return_if_fail (CLUTTER_IS_DRAG_DEST (dest));
  dest->priv->success = success;
}

void      
clutter_drag_dest_enable (ClutterDragDest *dest)
{
  clutter_drag_server_add_drag_dest (clutter_drag_server_get_default (),dest);
}

gboolean
clutter_drag_dest_drop (ClutterDragDest *dest, gpointer data)
{
  g_signal_emit (dest, _dest_signals[DROP], 0, data);

  return dest->priv->success;
}


/* GObject stuff */
static void
clutter_drag_dest_finalize (GObject *object)
{
  ClutterDragDestPrivate *priv;

  priv = CLUTTER_DRAG_DEST_GET_PRIVATE (object);

  G_OBJECT_CLASS (clutter_drag_dest_parent_class)->finalize (object);
}

static void
clutter_drag_dest_class_init (ClutterDragDestClass *klass)
{
  GObjectClass        *obj_class = G_OBJECT_CLASS (klass);

  obj_class->finalize = clutter_drag_dest_finalize;

  _dest_signals[DROP] = 
    g_signal_new ("drop",
                  G_OBJECT_CLASS_TYPE (obj_class),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (ClutterDragDestClass, 
                                   drop),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__POINTER,
                  G_TYPE_NONE, 1, G_TYPE_POINTER);


  g_type_class_add_private (obj_class, sizeof (ClutterDragDestPrivate));
}

static void
clutter_drag_dest_init (ClutterDragDest *drag_dest)
{
  ClutterDragDestPrivate *priv;

  priv = drag_dest->priv = CLUTTER_DRAG_DEST_GET_PRIVATE (drag_dest);
}
