/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_NOTIFY_H_
#define _LAUNCHER_NOTIFY_H_

#include <glib.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>

#define LAUNCHER_TYPE_NOTIFY (launcher_notify_get_type ())

#define LAUNCHER_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_NOTIFY, LauncherNotify))

#define LAUNCHER_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_NOTIFY, LauncherNotifyClass))

#define LAUNCHER_IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_NOTIFY))

#define LAUNCHER_IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_NOTIFY))

#define LAUNCHER_NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_NOTIFY, LauncherNotifyClass))

typedef struct _LauncherNotify        LauncherNotify;
typedef struct _LauncherNotifyClass   LauncherNotifyClass;
typedef struct _LauncherNotifyPrivate LauncherNotifyPrivate;
 
struct _LauncherNotify
{
  ClutterGroup        parent;	

  LauncherNotifyPrivate *priv;
};

struct _LauncherNotifyClass
{
  ClutterGroupClass   parent_class;

};

GType launcher_notify_get_type (void) G_GNUC_CONST;

LauncherNotify * launcher_notify_get_default (void);

void            launcher_notify_popup (LauncherNotify *notify,
                                       const gchar    *label,
                                       ClutterTexture *texture,
                                       gint            pid);

#endif /* _LAUNCHER_NOTIFY_H_ */

