/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.db.util;

import java.awt.CardLayout;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;

/**
 *
 * @author  rob
 */
public class ErrorInfoPanel extends javax.swing.JPanel {
    
    private static final String EMPTYCARD = "emptyCard";  //NOI18N
    private static final String CONTENTCARD = "contentCard";  //NOI18N
    private static final String ERRORICON = "org/netbeans/modules/db/resources/errorIcon.png"; //NOI18N
    private static final String INFOICON = "org/netbeans/modules/db/resources/infoIcon.png"; //NOI18N
    
    private ImageIcon errorIcon;
    private ImageIcon infoIcon;
    
    private Color errorColor;
    private Color infoColor;
    
    /** Creates new form ErrorInfoPanel */
    public ErrorInfoPanel() {
        initComponents();
        add(emptyPanel, EMPTYCARD);
    }

    /**
     * This method must be called by users of ErrorInfoPanel after the
     * panel has been constructed.  This is done so that ErrorInfoPanel
     * can be used in the form designer.
     */
    public void setup() {
        errorColor = UIManager.getColor("nb.errorForeground"); //NOI18N
        if (errorColor == null) 
        {
            errorColor = new Color(255, 0, 0);
        }
        
        infoColor = UIManager.getColor("nb.warningForeground"); //NOI18N
        if (infoColor == null) 
        {
            infoColor = UIManager.getColor("Label.foreground"); //NOI18N;
        }
        
        errorIcon = new ImageIcon(ImageUtilities.loadImage(ERRORICON));
        infoIcon = new ImageIcon(ImageUtilities.loadImage(INFOICON));

    }
    
    public void clear()
    {
        ((CardLayout)getLayout()).show(this, EMPTYCARD);
    }
    
    public void setError(String msg)
    {
        ((CardLayout)getLayout()).show(this, CONTENTCARD);
        msgLabel.setText(msg);
        msgLabel.setForeground(errorColor);
        iconLabel.setIcon(errorIcon);        
    }
    
    public void setInfo(String msg)
    {
        ((CardLayout)getLayout()).show(this, CONTENTCARD);
        msgLabel.setText(msg);
        msgLabel.setForeground(infoColor);
        iconLabel.setIcon(infoIcon);        
    }
    
    public void set(String msg, boolean isError)
    {
        if (isError)
        {
            setError(msg);
        }
        else
        {
            setInfo(msg);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        emptyPanel = new javax.swing.JPanel();
        contentPanel = new javax.swing.JPanel();
        iconLabel = new javax.swing.JLabel();
        msgLabel = new javax.swing.JLabel();

        org.jdesktop.layout.GroupLayout emptyPanelLayout = new org.jdesktop.layout.GroupLayout(emptyPanel);
        emptyPanel.setLayout(emptyPanelLayout);
        emptyPanelLayout.setHorizontalGroup(
            emptyPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 278, Short.MAX_VALUE)
        );
        emptyPanelLayout.setVerticalGroup(
            emptyPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 18, Short.MAX_VALUE)
        );

        setLayout(new java.awt.CardLayout());

        iconLabel.setText(org.openide.util.NbBundle.getMessage(ErrorInfoPanel.class, "ErrorInfoPanel.iconLabel.text")); // NOI18N

        msgLabel.setText(org.openide.util.NbBundle.getMessage(ErrorInfoPanel.class, "ErrorInfoPanel.msgLabel.text")); // NOI18N

        org.jdesktop.layout.GroupLayout contentPanelLayout = new org.jdesktop.layout.GroupLayout(contentPanel);
        contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(
            contentPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(contentPanelLayout.createSequentialGroup()
                .add(iconLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(msgLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 372, Short.MAX_VALUE))
        );
        contentPanelLayout.setVerticalGroup(
            contentPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(contentPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(iconLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(msgLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        add(contentPanel, "contentCard");
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel contentPanel;
    private javax.swing.JPanel emptyPanel;
    private javax.swing.JLabel iconLabel;
    private javax.swing.JLabel msgLabel;
    // End of variables declaration//GEN-END:variables
    
}
