/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ulog2netflow.c,v 1.10 2009-08-01 09:23:55 anton Exp $ */

#ifdef LINUX

#include "config.h"
extern "C" {
	#include "lib.h"
	#include "libipulog/libipulog.h"
}

#define NETFLOW_CLASS
#include "netflow.h"


#undef CHECK_POLL
#define CHECK_POLL(status) {                                                            \
        if ((status = poll(&pfd, 1, POLL_TIMEOUT)) < 0 && errno != EINTR) {     \
                printf("poll: %s\n", strerror(errno));      \
                continue;                                                       \
        }                                                                       \
}

extern u_char debug, quiet;
extern void Debug(const char *msg,...);

char *destination=NULL;
const char *dst_host=NULL;
unsigned short dst_port=20001;
u_char hupset=0;

class NetFlow *Flow;

unsigned char   *packet;

//#define MY_MALLOC(x) new(x)
#define MY_MALLOC(x) malloc(x)
//#define MY_FREE(x) delete(x)
#define MY_FREE(x) free(x)

void termination(){
	if (debug && !quiet) {
		Flow->Status();
	}
	delete Flow;
        MY_FREE(packet);
	
	signal(SIGINT, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
	signal(SIGTERM, SIG_DFL);
	signal(SIGALRM, SIG_DFL);
	signal(SIGHUP, SIG_DFL);

	exit(0);
}


void PrintUsage(FILE *f){
    fprintf(f, "Usage: ipfw2netflow {options}\nwhere {options} are:\n\
            -h\t print help screen and exit\n\
            -q\t quiet output\n\
            -d\t debug output (no daemon mode)\n\
            -e export_to\t IP address:port to export flows to\n\
            -x expire check timeout (sec)\n\
            -a active_timeout\t active flow timeout (sec.)\n\
            -i inactive_timeout\t inactive flow timeout (sec.)\n\
	    -n nlgroup, \n\
            \tThis specifies the netlink group (1-32) to which the packet is sent.  Default value is 1.\n\
	    \tshould be in sync with --ulog-nlgroup in iptables. \n");
}

void do_hup()
{
    Debug("SIGHUP\n");
    hupset = 1;
    signal(SIGHUP, (sig_t)do_hup);
}
//---------------------------------------------------------------------------------

int main(int argc, char **argv) {
#ifdef IPTBL_NONE
	printf("IPTBL_NONE enabled\n");
	return 0;
#else
	
	struct ipulog_handle *ulog_h; /* our libipulog handle */
	ulog_packet_msg_t *m;
	
	int status;
	int op;
	u_char nlgroup=1;
	unsigned active=0,inactive=0;
	unsigned expired =0;	

	while((op=getopt(argc, argv, "hqde:p:a:i:x:b:n:")) != EOF){
		switch(op){
			case 'h':
				PrintUsage(stdout);
				exit(-1);
				break;
			case 'd':
				debug=1;
				break;
			case 'q':
				quiet=1;
				break;
			case 'e':
				destination=(char *)calloc(strlen(optarg)+1, 1);
				strcpy(destination, optarg);
				break;
			case 'a':
				active=strtol(optarg, NULL, 10);
				break;
			case 'i':
				inactive=strtol(optarg, NULL, 10);
				break;
			case 'x':
				expired=strtol(optarg, NULL, 10);
				break;
			case 'n':
				nlgroup=strtol(optarg, NULL, 10);
				break;
			default:
				PrintUsage(stdout);
				break;
		}
	}
	
	if (debug && !quiet) {
		printf("This is part of NeTAMS project, http://www.netams.com \n");
	}

	if(nlgroup<1 || nlgroup>32) {
                printf( "nlgroup has to be between 1 and 32, set it via -n flag \n");
                return 0;
        }


	if (!destination)
		dst_host="127.0.0.1";
	else {
		char *c;
		c=strchr(destination, ':');
		if (c) {
			dst_port=strtol(c+1, NULL, 10);
			c[0]='\0'; dst_host=destination;
		} else
			dst_host=destination;
	}
    
	if (!active) active=10*60; // 1 min
	if (!inactive) inactive=1*60; // 10 min
	
	Flow=new NetFlow(dst_host,dst_port);   
	Flow->SetTimeouts(active,inactive,expired);	

	if (!debug) {
		daemon(0, 1);
		chdir("/var/tmp");
		umask(077);
		fclose(stdin);
		fclose(stdout);
		fclose(stderr);
	}

	packet=(unsigned char*)MY_MALLOC(MAX_PKT_SIZE);  
	
	/* create ipulog handle */
	ulog_h = ipulog_create_handle(getpid(), ipulog_group2gmask(nlgroup));
	if (!ulog_h) {
		printf("linux ulog handle failed: %s!\n", ipulog_strerror(ipulog_errno));
                return errno;
	}
        SET_POLL(ulog_h->fd);

	signal(SIGINT, (sig_t)termination);
	signal(SIGQUIT, (sig_t)termination);
	signal(SIGTERM, (sig_t)termination);
	signal(SIGHUP, (sig_t) do_hup);

	while(1) {
		CHECK_POLL(status);
                if(status==0) {
                        Flow->Expiresearch();
                        continue;
                }

                status=ipulog_read(ulog_h, packet, MAX_PKT_SIZE, 1000);
                if(status <0) {
                        printf("ulog: %s\n", ipulog_strerror(ipulog_errno));
                        continue;
                }

                while((m=ipulog_get_packet(ulog_h, packet, status))) {
                        Flow->Expiresearch();
                        Flow->Processpacket((struct ip*)m->payload);
                }
        }

	return 0;
#endif //IPTBL_NONE
}

#else

#include <stdio.h>

int main() {
        printf("This is part of NeTAMS project, http://www.netams.com \n");
	printf("This software could be started under Linux operating system only\n");
}

#endif // LINUX
