/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: netflow.h,v 1.31 2009-12-13 15:53:41 anton Exp $ */

#ifndef	__NETFLOW_H
#define	__NETFLOW_H

#define FLOW_VERSION_5	5
#define V5_MAXFLOWS	30
#define  MAX_PKT_SIZE	0xffff

typedef struct Flow5StatHdr {
	/* 24 byte header */
	u_int16_t version;       /* 5 */
	u_int16_t count;         /* The number of records in the PDU */
	u_int32_t sysUpTime;     /* Current time in millisecs since router booted */
	u_int32_t unix_secs;     /* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;    /* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence; /* Seq counter of total flows seen */
	u_int8_t  engine_type;   /* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t  engine_id;     /* Slot number of the flow switching engine */
	u_int16_t reserved;
} Flow5StatHdr;

typedef struct IPFlow5Stat {
	/* 48 byte payload */
	in_addr   srcaddr;    /* Source IP Address */
	in_addr   dstaddr;    /* Destination IP Address */
	in_addr   nexthop;    /* Next hop router's IP Address */
	u_int16_t input;      /* Input interface index */
	u_int16_t output;     /* Output interface index */
	u_int32_t dPkts;      /* Packets sent in Duration */
	u_int32_t dOctets;    /* Octets sent in Duration. */
	u_int32_t First;      /* SysUptime at start of flow */
	u_int32_t Last;       /* and of last packet of flow */
	u_int16_t srcport;    /* TCP/UDP source port number or equivalent */
	u_int16_t dstport;    /* TCP/UDP destination port number or equiv */
	u_int8_t  pad;
	u_int8_t  tcp_flags;  /* Cumulative OR of tcp flags */
	u_int8_t  prot;       /* IP protocol, e.g., 6=TCP, 17=UDP, ... */
	u_int8_t  tos;        /* IP Type-of-Service */
	u_int16_t src_as;     /* originating AS of source address */
	u_int16_t dst_as;     /* originating AS of destination address */
	u_int8_t  src_mask;   /* source address prefix mask bits */
	u_int8_t  dst_mask;   /* destination address prefix mask bits */
	u_int16_t drops;
} IPFlow5Stat;

typedef struct IPStat5Msg {
	Flow5StatHdr header;
	IPFlow5Stat records[V5_MAXFLOWS];
} IPStat5Msg;


#define FLOW_VERSION_9			9
#define	FLOW_VERSION_9_TMPL_ID		0
#define	FLOW_VERSION_9_TMPL_OPT_ID	1


#define NFV9_IN_BYTES			1
#define NFV9_IN_PKTS			2
#define NFV9_FLOWS			3
#define NFV9_PROTOCOL			4
#define NFV9_SRC_TOS			5
#define NFV9_TCP_FLAGS			6
#define NFV9_L4_SRC_PORT		7
#define NFV9_IPV4_SRC_ADDR		8
#define NFV9_SRC_MASK			9
#define NFV9_INPUT_SNMP			10
#define NFV9_L4_DST_PORT		11
#define NFV9_IPV4_DST_ADDR		12
#define NFV9_DST_MASK			13
#define NFV9_OUTPUT_SNMP		14
#define NFV9_IPV4_NEXT_HOP		15
#define NFV9_SRC_AS			16
#define NFV9_DST_AS			17
#define NFV9_BGP_IPV4_NEXT_HOP		18
#define NFV9_MUL_DST_PKTS		19
#define NFV9_MUL_DST_BYTES		20
#define NFV9_LAST_SWITCHED		21
#define NFV9_FIRST_SWITCHED		22
#define NFV9_OUT_BYTES			23
#define NFV9_OUT_PKTS			24
#define NFV9_MIN_PKT_LENGTH		25
#define NFV9_MAX_PKT_LENGTH		26
#define NFV9_IPV6_SRC_ADDR		27
#define NFV9_IPV6_DST_ADDR		28
#define NFV9_IPV6_SRC_MASK		29
#define NFV9_IPV6_DST_MASK		30
#define NFV9_IPV6_FLOW_LABEL		31
#define NFV9_ICMP_TYPE			32
#define NFV9_MUL_IGMP_TYPE		33
#define NFV9_SAMPLING_INTERVAL		34
#define NFV9_SAMPLING_ALG		35
#define NFV9_FLOW_ACTIVE_TIME		36
#define NFV9_FLOW_INACT_TIME		37
#define NFV9_ENGINE_TYPE		38
#define NFV9_ENGINE_ID			39
#define NFV9_TOTAL_BYTES_EXP		40
#define NFV9_TOTAL_PKTS_EXP		41
#define NFV9_TOTAL_FLOW_EXP		42
#define NFV9_VENDOR_1			43
#define NFV9_IPV4_SRC_PREFIX		44
#define NFV9_IPV4_DST_PREFIX		45
#define NFV9_MPLS_TOP_LBL_TYPE		46
#define NFV9_MPLS_TOP_LBL_IP_ADDR	47
#define NFV9_FLOW_SAMPLER_ID		48
#define NFV9_FLOW_SAMPLER_MODE		49
#define NFV9_FLOW_SAMPLER_RND_INTERVAL	50
#define NFV9_VENDOR_2			51
#define NFV9_MIN_TTL			52
#define NFV9_MAX_TTL			53
#define NFV9_IPV4_IDENT			54
#define NFV9_DST_TOS			55
#define NFV9_IN_SRC_MAC			56
#define NFV9_OUT_DST_MAC		57
#define NFV9_SRC_VLAN			58
#define NFV9_DST_VLAN			59
#define NFV9_IP_PROTOCOL_VERSION	60
#define NFV9_DIRECTION			61
#define NFV9_IPV6_NEXT_HOP		62
#define NFV9_BGP_IPV6_NEXT_HOP		63
#define NFV9_IPV6_OPTION_HEADERS	64
#define NFV9_VENDOR_3			65
#define NFV9_VENDOR_4			66
#define NFV9_VENDOR_5			67
#define NFV9_VENDOR_6			68
#define NFV9_VENDOR_7			69
#define NFV9_MPLS_LABEL_1		70
#define NFV9_MPLS_LABEL_2		71
#define NFV9_MPLS_LABEL_3		72
#define NFV9_MPLS_LABEL_4		73
#define NFV9_MPLS_LABEL_5		74
#define NFV9_MPLS_LABEL_6		75
#define NFV9_MPLS_LABEL_7		76
#define NFV9_MPLS_LABEL_8		77
#define NFV9_MPLS_LABEL_9		78
#define NFV9_MPLS_LABEL_10		79
#define NFV9_IN_DST_MAC			80
#define NFV9_OUT_SRC_MAC		81
#define NFV9_IF_NAME			82
#define NFV9_IF_DESC			83
#define NFV9_SAMPLER_NAME		84
#define NFV9_IN_PERMANENT_BYTES		85
#define NFV9_IN_PERMANENT_PKTS		86
#define NFV9_VENDOR_8			87
#define NFV9_FRAGMENT_OFFSET		88
#define NFV9_FORWARDING_STATUS		89

struct NetFlowV9Header {
    u_int16_t	version;		/* Version of records, 0x0009 */
    u_int16_t	count;			/* Number of FlowSet records (both template and data) */
    u_int32_t	sysUpTime;		/* Time in milliseconds since this device was first booted */
    u_int32_t	unixSeconds;		/* Seconds since 0000 UTC 1970 */
    u_int32_t	packageSequence;	/* Incremental sequence counter of all export packets */
    u_int32_t	sourceId;		/* Used to guarantee uniqueness for all flows exported */
};

struct NetFlowV9FlowSetHeader {
    u_int16_t	flowSetId;
    u_int16_t	length;
};

struct NetFlowV9TemplateHeader {
    u_int16_t	templateId;
    u_int16_t	fieldCount;
};

struct NetFlowV9FieldInfo {
    u_int16_t	type;
    u_int16_t	length;
};

struct NetFlowV9Template {
    struct NetFlowV9TemplateHeader	header;
    struct NetFlowV9FieldInfo		*fields;
};

//////////////////////////////////////////////////////////////////////////
#ifdef NETFLOW_CLASS

typedef struct entry {
	u_int16_t hash;

	//flow data
	time_t start, last;
        u_int32_t ip_len, count;
        u_int8_t ip_proto, ip_tos;
        in_addr_t ip_src, ip_dst;
        u_int16_t src_port, dst_port;
        
	//flags
	u_int8_t expired;

        entry *next;
} __attribute__((packed)) entry;

typedef struct entry_hash {
	entry *root;
	entry_hash *next_active;
} __attribute__((packed)) entry_hash;

//////////////////////////////////////////////////////////////////////////
class NetFlow {
        public:

#define MAX_CHUNK               2048 //protection against DoS - max chunks per hash node

#define IPV4_HASH_SIZE	0x10000
#define IPV4_HASH_MASK	(IPV4_HASH_SIZE-1)

//old - symmetric
#define IPV4_HASH(addr1, addr2, port1, port2, proto) ((((addr1) + (addr2)) + (port1) + (port2)+ (proto))&IPV4_HASH_MASK)
//new - assymentric
#define IPV4_ADDR_HASH(addr1,addr2)	(((addr1 >> 16) ^ (addr2 & 0x00FF) ) & IPV4_HASH_MASK)
#define IPV4_FULL_HASH(addr1, addr2, port1, port2)	(((addr1 >> 16) ^ (addr2 & 0x00FF) ^ ((port1 ^ port2) << 8) )& IPV4_HASH_MASK)

                entry_hash *table;
                entry_hash *active;
         	entry *ready;
       
		time_t t_now;
                time_t t;
		time_t t_msg;

                unsigned t_active;
                unsigned t_inactive;
		unsigned t_expired;
		unsigned t_msg_expired;
	
                unsigned e_used;
                unsigned e_total;
                
		unsigned last_id, expired_id;
                u_int32_t long sent_flows;
                u_int32_t long sent_packets;

                IPStat5Msg *message;
	
		int udp_socket_fd;
		struct sockaddr_in udp_dest;
		
                NetFlow(const char *dst_host, u_int16_t dst_port);
                ~NetFlow();
		void SetTimeouts(unsigned active=0,unsigned inactive=0,unsigned expired=0,unsigned msg_expired=0);
                void CheckExpire(entry *e);
                void Expiresearch();
                void Processpacket(struct ip *ip);
                void FlushAll();
                void ToSend(entry *e);
                void DoSend();
		void Status();
};
#endif
//////////////////////////////////////////////////////////////////////////

#endif
