/*
 * Decompiled with CFR 0.152.
 */
package org.petzall.daapapplet.tracklist;

import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.cdavies.itunes.Track;

public class TrackList
extends AbstractTableModel {
    public final String[] _columnNames = new String[]{"Title", "Length", "Artist", "Album"};
    public ArrayList _data = new ArrayList();
    public ArrayList _albums = new ArrayList();
    public ArrayList _artists = new ArrayList();

    public ListModel getAlbumList() {
        return new SubList("albums", this._albums);
    }

    public ListModel getArtistList() {
        return new SubList("artists", this._artists);
    }

    public String getColumnName(int n) {
        return this._columnNames[n];
    }

    public void clear() {
        this._data = new ArrayList();
    }

    public void addRow(Track track) {
        Object[] objectArray = new Object[]{track.getTrackName(), TrackList.formatTime(track.getLength()), track.getArtistName(), track.getAlbumName(), track};
        if (objectArray[2] != null && !this._artists.contains(objectArray[2]) && ((String)objectArray[2]).length() > 0) {
            this._artists.add(objectArray[2]);
        }
        if (objectArray[3] != null && !this._albums.contains(objectArray[3]) && ((String)objectArray[3]).length() > 0) {
            this._albums.add(objectArray[3]);
        }
        this._data.add(objectArray);
    }

    public static String formatTime(int n) {
        String string = "";
        if ((n /= 1000) > 3600) {
            string = string + n / 3600 + ":";
        }
        String string2 = "" + n / 60 % 60;
        string = string + (string2.length() < 2 && n > 3600 ? "0" : "") + string2 + ":";
        string2 = "" + n % 60;
        string = string + (string2.length() < 2 ? "0" : "") + string2;
        return string;
    }

    public int getRowCount() {
        return this._data.size();
    }

    public int getColumnCount() {
        return this._columnNames.length;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public Object getValueAt(int n, int n2) {
        return ((Object[])this._data.get(n))[n2];
    }

    public Track getTrack(int n) {
        return (Track)this.getValueAt(n, 4);
    }

    class SubList
    implements ListModel {
        private ArrayList _data;
        private String _plTitle;

        SubList(String string, ArrayList arrayList) {
            this._data = arrayList;
            this._plTitle = string;
        }

        public Object getElementAt(int n) {
            if (n == 0) {
                return "All (" + this._data.size() + " " + this._plTitle + ")";
            }
            return this._data.get(n - 1);
        }

        public int getSize() {
            return this._data.size() + 1;
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

