/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes;

import org.cdavies.itunes.Database;
import org.cdavies.itunes.ItunesConnection;
import org.cdavies.itunes.Track;
import org.cdavies.itunes.hash.Itunes45Hash;
import org.cdavies.itunes.hash.ItunesHash;
import org.cdavies.itunes.request.GenericRequest;
import org.cdavies.itunes.request.Itunes45TracklistRequest;
import org.cdavies.itunes.request.Itunes45UpdateRequest;
import org.cdavies.itunes.request.LegacyDatabaseRequest;
import org.cdavies.itunes.request.LegacyLoginRequest;
import org.cdavies.itunes.request.LegacyLogoutRequest;
import org.cdavies.itunes.request.NoServerPermissionException;

public class Itunes45Connection
implements ItunesConnection {
    private String _serverName;
    private int _port;
    private String _serverTitle;
    private boolean _connected;
    private Database[] _dbs;
    private Track[][] _tls;
    private int _sessionId;
    private ItunesHash _hash;
    private int _requestId;

    public Itunes45Connection(String string, int n, String string2) {
        this._serverName = string;
        this._port = n;
        this._connected = false;
        this._requestId = 0;
        this._serverTitle = string2;
    }

    public boolean isConnected() {
        return this._connected;
    }

    public void disconnect() {
        if (!this._connected) {
            return;
        }
        this._connected = false;
        try {
            LegacyLogoutRequest legacyLogoutRequest = new LegacyLogoutRequest(this._serverName, this._port, this._sessionId);
            this.executeRequest(legacyLogoutRequest);
        }
        catch (NoServerPermissionException noServerPermissionException) {
            System.err.println("Non-Fatal Error: Failed to logout of server " + this._serverName);
        }
    }

    private void executeRequest(GenericRequest genericRequest) throws NoServerPermissionException {
        genericRequest.setHash(this._hash);
        genericRequest.constructQuery();
        genericRequest.runQuery();
        genericRequest.process();
    }

    public void refreshConnection() throws NoServerPermissionException {
        if (this._connected) {
            this.disconnect();
        }
        LegacyLoginRequest legacyLoginRequest = new LegacyLoginRequest(this._serverName, this._port);
        this.executeRequest(legacyLoginRequest);
        this._sessionId = legacyLoginRequest.getSessionId();
        this._requestId = 0;
    }

    public void connect() throws NoServerPermissionException {
        if (this._connected) {
            return;
        }
        this._hash = new Itunes45Hash();
        LegacyLoginRequest legacyLoginRequest = new LegacyLoginRequest(this._serverName, this._port);
        this.executeRequest(legacyLoginRequest);
        this._sessionId = legacyLoginRequest.getSessionId();
        Itunes45UpdateRequest itunes45UpdateRequest = new Itunes45UpdateRequest(this._serverName, this._port, this._sessionId, 1);
        this.executeRequest(itunes45UpdateRequest);
        int n = itunes45UpdateRequest.getRevisionNumber();
        LegacyDatabaseRequest legacyDatabaseRequest = new LegacyDatabaseRequest(this._serverName, this._port, this._sessionId);
        this.executeRequest(legacyDatabaseRequest);
        this._dbs = legacyDatabaseRequest.getDatabases();
        this._tls = new Track[this._dbs.length][];
        for (int i = 0; i < this._dbs.length; ++i) {
            Itunes45TracklistRequest itunes45TracklistRequest = new Itunes45TracklistRequest(this._serverName, this._port, this._sessionId, this._dbs[i].getId());
            this.executeRequest(itunes45TracklistRequest);
            this._tls[i] = itunes45TracklistRequest.getTracklist();
            for (int j = 0; j < this._tls[i].length; ++j) {
                this._tls[i][j].setItunesConnection(this);
                this._tls[i][j].setItunesHash(this._hash);
            }
            this._requestId = 0;
        }
        this._connected = true;
    }

    public int getRequestNumber() {
        return ++this._requestId;
    }

    public Database[] getDatabases() {
        return this._dbs;
    }

    public Track[] getTracklist(int n) {
        for (int i = 0; i < this._dbs.length; ++i) {
            if (n != this._dbs[i].getId()) continue;
            return this._tls[i];
        }
        return null;
    }

    public String toString() {
        return this._serverTitle;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getPort() {
        return this._port;
    }

    public int getSessionId() {
        return this._sessionId;
    }
}

