var detail; 

function init()
{
	// fill in an id if they already have one
	detail = window.arguments[0];
	
	var id = "";
	var id_list;
	var splitids;
	var i;
	
	var forgot_button = document.getElementById("stumble_signin_dialog").getButton("extra1");
	
	forgot_button.label = "Forgot Password";
	forgot_button.setAttribute("oncommand", "forgotPassword();");

	if (opener.stumbleid == 0) 
	{
		// We're not logged in.  See whether we have a previous id.

		id_list = opener.su_ds.getValue("@id_list");
		splitids = id_list.split(":");

		for (i = 0; i < splitids.length; i++)
		{
			if (splitids[i] == "")
				continue;

			id = splitids[i];
			break;
		}
	}
	else 
	{
		// We're logged in, so we assume that the user wants to
		// switch accounts.  See whether we have a previous id.
		
		id_list = opener.su_ds.getValue("@id_list", "");
		splitids = id_list.split(":");
		var id_count = 0;
		
		for (i = 0; i < splitids.length; i++)
		{
			if (splitids[i] == "")
				continue;
		
			id_count++;
			id = splitids[i];
			if (id_count == 2)
				break;
		}
	}
	
	
	if (id)
	{
		// they already have an account

		// see if we can get nickname
		var nick = opener.su_ds.getValue("stumble." + id + ".nick", "");

		if (nick != "")
			document.getElementById("username").value = nick;
		else
			document.getElementById("username").value = id;
		document.getElementById("password").focus();
	}
	var autologout = opener.su_get_autologout_for_user(document.getElementById("username").value);
	document.getElementById("autologout").checked = autologout;
}

function forgotPassword()
{
	var doc = opener.getBrowser().contentDocument;
	close();
	doc.location = opener.su_base_url + "recover_password.php";
}

function doOK()
{
	var username = document.getElementById("username").value;
	
	if (username == null)
		return true;

	username = opener.su_trim(username).toLowerCase();
	
	if (username == "")
	{
		alert('Username cannot be blank');
		return false;
	}
	
	var password = document.getElementById("password").value;
	if (password == null)
		return true;

	if (password == "")
	{
		alert('Password cannot be blank');
		return false;
	}

	var res;
	
	if (opener.su_enable_hashed_password)
	{
		res = opener.su_post_url_server(
					"userexists.php",
					"version=" + opener.su_verstring + 
						"&username=" + escape(username) + 
						"&password=" + opener.su_get_encoded_password(password, username.toLowerCase()));
	}
	else
	{
		res = opener.su_post_url_server(
					"userexists.php",
					"version=" + opener.su_verstring + "&username=" + escape(username) + "&password=" + escape(password));
	}
	
	if (res.status == 1)
	{
		alert("Cannot access stumbleupon.com at this time.\nPlease check your network connection and try again.");
		return false;
	}

	if (res.status != 200)
	{
		alert("The stumbleupon.com server is currently down.\nPlease try again, and if this occurs frequently,\ngo to http://www.stumbleupon.com/feedback.php to report the problem\nError : " + res.error + "\nStatus : " + res.status);
		return false;
	}

	var s = "";
	if (typeof(res.response) != "undefined")
		s = res.response;

	if (opener.su_log_communication)
		opener.su_log("response userexists.php", s);
	
	var commands = s.split("\n");
	// Iterate through commands
	
	var success = false;
	var i;
	for (i = 0; i < commands.length; i++)
	{
		if (commands[i] == "")
			continue;

		// Parse command structure
		var parts = commands[i].split(" ");
		switch(parts[0])
		{
			case "ERROR":
				var msg;
				if (parts[1] == "DATABASE_FAILURE")
				{
					alert("The www.stumbleupon.com server is currently down.\nPlease try again, and if you are still having difficulties,\ngo to http://www.stumbleupon.com/feedback.php to report the problem\nError : " + ss[1]);
					return false;
				}
				else if (parts[1] == "NO_SUCH_USERNAME")
				{
					msg = "An account was not found for '" + username + "'.\n";
		
					// we need to clear out that username from the list of usernames
					var id_list = opener.su_ds.getValue("@id_list");
					var splitids = id_list.split(":");
					var foundit = 0;
					var newarray = new Array();
					var line;
					for (i = 0; i < splitids.length; i++)
					{
						if (splitids[i] == "")
							continue;
				
						line = splitids[i];
						if (line == username)
							foundit = 1;
						else
							newarray.push(line);
					}
					if (foundit)
					{
						// add this id to the end
						id_list = '';
						for (i = 0; i < newarray.length; i++)
						{
							if (newarray[i] == "")
								continue;
				
							line = newarray[i];
							id_list += line + ":";	
						}
						opener.su_ds.setValue("@id_list", id_list);
						opener.su_ds.flushPrefs();
					}			
				}
				else if (parts[1] == "INCORRECT_PASSWORD")
				{
					msg = "That password for '" + username + "' is incorrect.\n";
				}
				
				if (confirm(msg + "Would you like to recover your username/password?"))
					forgotPassword();
				
				return false;
				break;
			case "USER":
				success = true;
				detail.userid = parts[1];
				detail.nickname = username;
				break;
			case "NICK":
				detail.nickname = parts[1];
				break;
			case "ENABLEU":
				detail.enableu = parseInt(parts[1]);
				break;
			case "ENABLEG":
				detail.enableg = parseInt(parts[1]);
				break;
			case "DISABLEU":
				detail.disableu = parseInt(parts[1]);
				break;
			case "DISABLEG":
				detail.disableg = parseInt(parts[1]);
				break;
		}
	}
	
	if (success)
	{
		detail.password = password;
		detail.autologout = document.getElementById("autologout").checked;
		opener.setTimeout(function (parent, detail) { parent.su_handle_signin_dialog_accept(detail); }, 0, opener, detail);
	}
	
	// Other responses fail silently?
	return true;
}

function doCancel()
{
	return true;
}

function handle_username_command(element)
{
	var autologout = opener.su_get_autologout_for_user(element.value);
	
	document.getElementById("autologout").checked = autologout;
}

