/* mhs-cookies.h */

#ifndef _MHS_COOKIES_H
#define _MHS_COOKIES_H

#include <glib-object.h>

G_BEGIN_DECLS

#define MHS_TYPE_COOKIES mhs_cookies_get_type()

#define MHS_COOKIES(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MHS_TYPE_COOKIES, MhsCookies))

#define MHS_COOKIES_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MHS_TYPE_COOKIES, MhsCookiesClass))

#define MHS_IS_COOKIES(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MHS_TYPE_COOKIES))

#define MHS_IS_COOKIES_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MHS_TYPE_COOKIES))

#define MHS_COOKIES_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MHS_TYPE_COOKIES, MhsCookiesClass))

typedef struct _MhsCookies MhsCookies;
typedef struct _MhsCookiesClass MhsCookiesClass;
typedef struct _MhsCookiesPrivate MhsCookiesPrivate;

struct _MhsCookies
{
  GObject parent;

  MhsCookiesPrivate *priv;
};

struct _MhsCookiesClass
{
  GObjectClass parent_class;

  /* signals */
  void (*cookie_changed)  (MhsCookies  *self,
                           const gchar *detail,
                           const gchar *cookie);
  void (*cookie_rejected) (MhsCookies  *self,
                           const gchar *uri);
};

GType mhs_cookies_get_type (void);

MhsCookies *mhs_cookies_new (void);

G_END_DECLS

#endif /* _MHS_COOKIES_H */
