/* mhs: A GObject wrapper for the Mozilla Mhs API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MHS_HISTORY_H__
#define __MHS_HISTORY_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define MHS_TYPE_HISTORY                                             \
  (mhs_history_get_type())
#define MHS_HISTORY(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                   \
                               MHS_TYPE_HISTORY,                     \
                               MhsHistory))
#define MHS_HISTORY_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                    \
                            MHS_TYPE_HISTORY,                        \
                            MhsHistoryClass))
#define MHS_IS_HISTORY(obj)                                          \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                   \
                               MHS_TYPE_HISTORY))
#define MHS_IS_HISTORY_CLASS(klass)                                  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                    \
                            MHS_TYPE_HISTORY))
#define MHS_HISTORY_GET_CLASS(obj)                                   \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                    \
                              MHS_TYPE_HISTORY,                      \
                              MhsHistoryClass))

typedef struct _MhsHistory         MhsHistory;
typedef struct _MhsHistoryClass    MhsHistoryClass;
typedef struct _MhsHistoryPrivate  MhsHistoryPrivate;

struct _MhsHistoryClass
{
  GObjectClass parent_class;

  void (* ac_result_received) (MhsHistory *history,
                               guint32 search_id,
                               const gchar *value,
                               const gchar *comment);
  void (* link_visited)       (MhsHistory *history,
                               const gchar *uri,
                               gint visit_time);
  void (* favorites_received) (MhsHistory *history,
                               gchar **urls,
                               gchar **titles);
  void (* pinned_page) (MhsHistory *history,
                        const gchar *title,
                        const gchar *uri,
                        gint visit_time);
  void (* unpinned_page) (MhsHistory *history,
                          const gchar *uri);
};

struct _MhsHistory
{
  GObject parent;

  MhsHistoryPrivate *priv;
};

typedef void (* MhsHistoryFaviconCallback) (MhsHistory *history,
                                               const gchar *mime_type,
                                               const guint8 *data,
                                               guint data_len,
                                               const GError *error,
                                               gpointer user_data);

typedef void (* MhsHistoryIsPagePinnedCallback) (MhsHistory *history,
                                                 gboolean is_page_pinned,
                                                 const GError *error,
                                                 gpointer user_data);

GType mhs_history_get_type (void) G_GNUC_CONST;

MhsHistory *mhs_history_new (void);

gboolean mhs_history_add_uri (MhsHistory *self,
                                 const gchar *uri,
                                 gboolean redirect,
                                 gboolean top_level,
                                 const gchar *referrer,
                                 GError **error);

gboolean mhs_history_is_visited (MhsHistory *self,
                                    const gchar *uri,
                                    gboolean *is_visited,
                                    GError **error);

gboolean mhs_history_set_page_title (MhsHistory *self,
                                        const gchar *uri,
                                        const gchar *title,
                                        GError **error);

gboolean mhs_history_start_ac_search (MhsHistory *self,
                                         const gchar *search_str,
                                         guint32 *search_id,
                                         GError **error);

gboolean mhs_history_stop_ac_search (MhsHistory *self,
                                        guint32 search_id,
                                        GError **error);

gboolean mhs_history_set_favicon_url (MhsHistory *self,
                                         const gchar *page_uri,
                                         const gchar *favicon_uri,
                                         GError **error);

gboolean mhs_history_set_default_favicon_url (MhsHistory *self,
                                                 const gchar *page_uri,
                                                 GError **error);

guint mhs_history_get_favicon (MhsHistory *self,
                                  const gchar *page_uri,
                                  gboolean download,
                                  MhsHistoryFaviconCallback callback,
                                  gpointer user_data,
                                  GDestroyNotify user_data_notify);

void mhs_history_get_favorites (MhsHistory *self);

gboolean mhs_history_clear_history (MhsHistory *self,
                                    GError **error);

guint mhs_history_get_is_page_pinned (MhsHistory *self,
                                      const gchar *page_uri,
                                      MhsHistoryIsPagePinnedCallback callback,
                                      gpointer user_data,
                                      GDestroyNotify user_data_notify);

void mhs_history_get_pinned_pages (MhsHistory *self);

void mhs_history_pin_page (MhsHistory *self,
                           const gchar *uri,
                           const gchar *title);

void mhs_history_unpin_page (MhsHistory *self,
                             const gchar *uri);

void mhs_history_unpin_all_pages (MhsHistory *self);

void mhs_history_cancel (MhsHistory *self,
                            guint id);

G_END_DECLS

#endif /* __MHS_HISTORY_H__ */
