/* mhs: A GObject wrapper for the Mozilla Mhs API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MHS_ERROR_H__
#define __MHS_ERROR_H__

#include <glib.h>

G_BEGIN_DECLS

#define MHS_ERROR (mhs_error_quark ())

#define MHS_ERROR_QUARK_STRING "mhs-error-quark"

typedef enum
{
  /* D-BUS glib appears to have an bug which means that these all need
     to be a single word :-/ */
  MHS_ERROR_XUL,
  MHS_ERROR_PROXY,
  MHS_ERROR_NOTAVAILABLE
} MhsError;

GQuark mhs_error_quark (void);

guint mhs_error_to_nsresult (GError *error);

G_END_DECLS

#endif /* __MHS_ERROR_H__ */
