/* mozhelper: A GObject wrapper for the Mozilla Mozhelper API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MOZHELPER_HISTORY_H__
#define __MOZHELPER_HISTORY_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define MOZHELPER_TYPE_HISTORY                                             \
  (mozhelper_history_get_type())
#define MOZHELPER_HISTORY(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                   \
                               MOZHELPER_TYPE_HISTORY,                     \
                               MozhelperHistory))
#define MOZHELPER_HISTORY_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                    \
                            MOZHELPER_TYPE_HISTORY,                        \
                            MozhelperHistoryClass))
#define MOZHELPER_IS_HISTORY(obj)                                          \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                   \
                               MOZHELPER_TYPE_HISTORY))
#define MOZHELPER_IS_HISTORY_CLASS(klass)                                  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                    \
                            MOZHELPER_TYPE_HISTORY))
#define MOZHELPER_HISTORY_GET_CLASS(obj)                                   \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                    \
                              MOZHELPER_TYPE_HISTORY,                      \
                              MozhelperHistoryClass))

typedef struct _MozhelperHistory         MozhelperHistory;
typedef struct _MozhelperHistoryClass    MozhelperHistoryClass;
typedef struct _MozhelperHistoryPrivate  MozhelperHistoryPrivate;

struct _MozhelperHistoryClass
{
  GObjectClass parent_class;

  void (* ac_result_received) (MozhelperHistory *history,
                               guint32 search_id,
                               const gchar *value,
                               const gchar *comment);
  void (* link_visited)       (MozhelperHistory *history,
                               const gchar *uri,
                               gint visit_time);
  void (* favorites_received) (MozhelperHistory *history,
                               gchar **urls,
                               gchar **titles);
  void (* pinned_page) (MozhelperHistory *history,
                        const gchar *title,
                        const gchar *uri,
                        gint visit_time);
  void (* unpinned_page) (MozhelperHistory *history,
                          const gchar *uri);
};

struct _MozhelperHistory
{
  GObject parent;

  MozhelperHistoryPrivate *priv;
};

GType mozhelper_history_get_type (void) G_GNUC_CONST;

MozhelperHistory *mozhelper_history_new (void);

G_END_DECLS

#endif /* __MOZHELPER_HISTORY_H__ */
