/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Chase Tingley <tingley@sundell.net>
 *  David Perry <d.perry@utoronto.ca>
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

function mgE(id) {
  return document.getElementById(id);
}

function mgPreInit() {
  var toggles = document.getElementsByAttribute("toggle", "*");

  for (var x = 0; x < toggles.length; x++)
    toggles[x].addEventListener("CheckboxStateChange",
      function () {mgE(this.getAttribute("toggle")).disabled = (this.hasAttribute("toggleReverse")) ? !this.checked : this.checked}, true);
}

function mgInitPrefPanel() {
  for (var i = 0; i < eltIDs.length; i++) {
    var elt = mgE(eltIDs[i]);

    try {
      var def = mgDefaultSettings.defaultPrefs.prefs[elt.id];

      switch(typeof def[0]) {
        case "number":
          if ("selectedIndex" in elt) 
            elt.selectedIndex = mgPrefs.prefs.getIntPref(elt.id);

          elt.value = mgPrefs.prefs.getIntPref(elt.id);
          elt.mgPrefType = "Int";

          elt.setAttribute("wraparound", true);
          elt.setAttribute("min", def[1]);
          elt.setAttribute("max", def[2]);

          if (def[2] > 999)
            elt.setAttribute("increment", 100);

          break;
        case "boolean":
          elt.checked = mgPrefs.prefs.getBoolPref(elt.id);
          elt.mgPrefType = "Bool";
          break;
        case "string":
          elt.color = mgPrefs.prefs.getCharPref(elt.id);
          elt.mgPrefType = "Char";
          break;
        default:
          break;
      }
    }
    catch(e) {}
  }

  var ai = mgCommon.appInfo;
  mgE("modifier.metaRow").hidden = (ai.platform == "Macintosh") ? false : true;
  mgE("pluginRow").hidden = (mgCommon.mouseService && mgCommon.mouseService.supports("plugins")) ? false : true;
  mgE("version").setAttribute("value", ai.mozgestVersion);
  mgE("middlemouse.contentLoadURL").checked = mgPrefs.root.getBoolPref("middlemouse.contentLoadURL");

  onMouseButtonChange();
  toggleStrokes();
  toggleRockers();
  toggleWheelRockers()
  toggleTrailSettingsBox();
  toggleStatusSettingsBox();
  setWindowTypes();

  var componentOnly = document.getElementsByAttribute("mgComponentOnly", "*")

  for (var x = 0; x < componentOnly.length; x++)
    componentOnly[x].hidden = !mgCommon.mouseService;

  try {
    mgE("mgTabBox").selectedIndex = mgPrefs.prefs.getIntPref("misc.selectedTab");
  }
  catch (e) {}
}

function savePrefs() {
  for (var i = 0; i < eltIDs.length; i++) {
    var elt = mgE(eltIDs[i]);

    switch(elt.mgPrefType) {
      case "Int":
        mgPrefs.prefs.setIntPref(elt.id, elt.value);
        break;
      case "Bool":
        mgPrefs.prefs.setBoolPref(elt.id, elt.checked);
        break;
      case "Char":
        mgPrefs.prefs.setCharPref(elt.id, elt.color);
        break;
      default:
        break;
    }
  }
  mgPrefs.root.setBoolPref("middlemouse.contentLoadURL", mgE("middlemouse.contentLoadURL").checked);
}

function toggleLmbOnlyOptions() {
  var button = mgE('mousebutton').selectedIndex;

  if (mgE('lefthanded').checked)
    button = Math.abs(button - 2);

  toggleElements((button != 0)
      || mgE("modifier.ctrl").checked
      || mgE("modifier.alt").checked
      || mgE("modifier.shift").checked,
      new Array("lmbGestureLimit"));
}

function onMouseButtonChange() {
  var button = mgE('mousebutton').selectedIndex;

  if (mgE('lefthanded').checked)
    button = Math.abs(button - 2);

  mgE('buttonOptionsDeck').selectedIndex = button;
  toggleLmbOnlyOptions();
}

function toggleStrokes() {
  toggleElements(!mgE("enableStrokes").checked,
                 new Array("grid", "diagonalTolerance", "delay"));
}

function toggleRockers() {
  toggleElements(!mgE("enableRockers").checked,
                 new Array("staticRockers", "staticRockersDelay"));

  toggleElements((!mgE("staticRockers").checked || !mgE("enableRockers").checked),
                 new Array("staticRockersDelay"));
}

function toggleWheelRockers() {
  toggleElements(!mgE("enableWheelRockers").checked,
                 new Array("staticWheelRockers"));

  toggleElements((!mgE("staticWheelRockers").checked || !mgE("enableWheelRockers").checked),
                 new Array("staticWheelRockersDelay"));
}

function toggleTrailSettingsBox() {
  toggleElements(!mgE("trails.enabled").checked,
                 new Array("trails.width", "trails.color", "trails.interval"));
}

function toggleStatusSettingsBox() {
  toggleElements(!mgE("status.isEnabled").checked,
                 new Array("status.timeout", "status.align"));
}

function toggleElements(d, idArray) {
  for (var i = 0; i < idArray.length; i++)
    mgE(idArray[i]).disabled = d;
}

function setWindowTypes() {
  var wTypes = mgE("windowTypesBox").childNodes;

  for (var y = 0; y < wTypes.length; y++)
    wTypes[y].hidden = (wTypes[y].firstChild.id.substring(7) in _mgMS.supportedWindows) ? false : true;

  mgE('unknownSettings').disabled = !mgE("window.unknownWindow").checked;
  mgE('siteSettings').disabled = !mgE("window.browser").checked;
}

function resetToDefault(label) {
  if (!mgCommon.prompt.confirm(window, label, mgCommon.getString('resetWarning')))
    return;

  for (each in mgDefaultSettings.defaultPrefs.prefs) {
    if (each.indexOf("misc.") == 0)
      continue;

    var pref = mgDefaultSettings.defaultPrefs.prefs[each][0];

    switch(typeof pref) {
      case "number":
        mgPrefs.prefs.setIntPref(each, pref);
        break;
      case "boolean":
        mgPrefs.prefs.setBoolPref(each, pref);
        break;
      case "string":
        mgPrefs.prefs.setCharPref(each, pref);
        break;
      default:
        break;
    }
  }
  mgInitPrefPanel();
  mgE("mgTabBox").selectedIndex = 0;
}

function mgExitPrefPanel() {
  mgPrefs.prefs.setIntPref("misc.selectedTab", mgE("mgTabBox").selectedIndex);
}