/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Ben Williams <benw@webmedia.com.au>
 *  David Illsley <illsleydc@bigfoot.com>
 *  Jens Bannmann <jens.b@web.de>
 *  Jeremy Wrinkle (Exotrip)        FIXME email
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Scurrie                         FIXME whole name, email
 *  Steve Kangas <bookmarklets.com> FIXME email
 *  Squarefree.com                  FIXME who exactly: whole name, email
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgGestureExecute = {
  /* This function attempts to fire the gesture, initially with the unmodified
  gesture it has been passed. If that fails, it fires the case with an onLink
  where the ending of the gesture matches a specific pattern. */
  mgFireGesture : function(aGesture){
    if (!mgGestureExecute.mgFireGestureFromTable(aGesture)) {
      if (!mgGestureExecute.mgFireOnLinkGesture())
        mgGestureHelper.showStatus(null, mgCommon.getString("g.unknown") + " " + mgGestureState.localizedGesture);
    }

    globalSrcEvent = mgGestureState.srcEvent = false;
  },

  mgFireGestureFromTable : function(aGesture, map) {
    var gs = mgGestureState;
    var mapping = null;

    if (map)
      mapping = map;
    else
      mapping = mgGestureHelper.getMapping(aGesture)[0];

    if (!gs.collectionsChecked) {
      var CI = Components.interfaces;
      var linkTemp = new Array();
      globalOnLink = new Array();

      for (each in gs.linkCollection) {
        var node = gs.linkCollection[each];

        if (node.href && node.href.indexOf("mozgest://") != 0 && !(node.href in linkTemp)) {
          if (node.ownerDocument.nodePrincipal &&
              !mgGestureHelper.urlCheck(node.href, node.ownerDocument.nodePrincipal))
            continue;

          linkTemp[node.href] = node;
          globalOnLink.push(node);
        }
      }
      gs.linkCollection = linkTemp;
      globalOnLink = (globalOnLink.length) ? globalOnLink : false;

      var imageTemp = new Array();
      globalOnImage = false;

      for (each in gs.imageCollection) {
        var imgNode = gs.imageCollection[each];

        if (imgNode instanceof CI.nsIDOMHTMLImageElement) {
          if (!globalOnImage) {
            globalOnImage = imgNode;
            break;
          }
        }
        // urlCheck here
      }
      //gs.imageCollection = imageTemp;

      linkTemp = imageTemp = null;
      gs.collectionsChecked = true;
    }

    if (mapping) {
      if (mgPrefs.mousebutton == 0) {
        try {
          if (gs.inputField) {
            if (gs.selStart != gs.selEnd)
              gs.inputField.setSelectionRange(gs.selStart, mgGestureState.selEnd);
            else
              gs.inputField.setSelectionRange(gs.inputField.selectionStart, gs.inputField.selectionStart);
          }

          if (gs.previousSelection && gs.srcEvent) {
            mgBuiltInFunctions.mgGetSelection().removeAllRanges();
            mgBuiltInFunctions.mgGetSelection().addRange(gs.previousSelection);
            gs.previousSelection = null;
          }
        }
        catch (e) {}
      }

      gs.gestureDone = true;

      try {
        var mType = (mapping.type) ? parseInt(mapping.type) : 0;

        if (mType < 2) {
          var mgFunctionToFire = (mType == 0) ? new Function("mgBuiltInFunctions." + mapping.func + "()") :
                                                new Function(decodeURIComponent(mapping.customFunc));
          mgFunctionToFire();
        }
        else if (mType == 2) {
          setTimeout(mgGestureExecute.mgFireKeyEvent, 10, mapping.func.split("|"))
        }
        else if (mgCommon.bmService.enabled || mgCommon.bmService.plEnabled) {
          var bmS = mgCommon.bmService;
          bmS.bmInfo.getBMInfo(mapping.func);
          var mgLocation = (bmS.bmInfo.uri) ? bmS.bmInfo.uri.spec : false;
          var mgPostData = { };

          if (mgLocation) {
            var mgLoadIn = parseInt(mapping.type.substring(1,2));

            if (mgCommon.makeURI(mgLocation).scheme == "javascript")
              mgLoadIn = 0;
            else {
              var selString = mgBuiltInFunctions.mgGetSelection().toString().replace(/\s$/, "");

              var mgKeyW = bmS.bmInfo.key;

              if (mgKeyW) // if bookmark has a keyword, use browser-function to replace %s
                mgLocation = getShortcutOrURI(mgKeyW + " " + selString, mgPostData);

              else if (mgLocation.match(/%s/))
                mgLocation = mgLocation.replace(/%s/g, encodeURIComponent(selString));
            }

            if (mgLoadIn == 4 && mgCommon.appInfo.name != "Firefox")
              mgLoadIn = 0;

            switch (mgLoadIn) {
              case 4:
                var mgPanelTitle = bmS.bmInfo.title;
                openWebPanel(mgPanelTitle, mgLocation);

                if (mgPostData.value)
                  setTimeout(mgBuiltInFunctions.mgLoadSideBar, 100, mgLocation, mgPostData.value);
                break;

              case 3:
                gBrowser.selectedTab = gBrowser.addTab(mgLocation, null, null, mgPostData.value);
                break;

              case 2:
                gBrowser.addTab(mgLocation, null, null, mgPostData.value);
                break;

              case 1:
                mgBuiltInFunctions.mgNewBrowserWindow().loadURI(mgLocation, null, mgPostData.value);
                break;

              case 0:
                loadURI(mgLocation, null, mgPostData.value);
                break;
            }
          }
          else {
            mgGestureHelper.showStatus(null, mgCommon.getString("chooseBM"));
            return true;
          }
        }
      }
      catch(e) {
        var errorMessage = "";
        var source = null;
        if (typeof e == "object" && "message" in e) {
          errorMessage = e.message;
          if ("filename" in e)
            source = e.filename;
          else if ("fileName" in e)
            source = e.fileName;
        }
        else
          errorMessage = String(e);

        if (source == null || source.indexOf("chrome://mozgest/") == 0) {
          var msg = mgCommon.getString("errorInGestureFunction");
          msg = msg.replace(/%MESSAGE%/, errorMessage);
          gs.lastError = errorMessage;
          mgGestureHelper.showStatus(null, msg);
        }
        return true;
      }

      if (gs.history.length > 14)
        gs.history.pop();

      gs.history.unshift([mgGestureHelper.getMapping(aGesture)[1],
                         mgCommon.mappingLocalizer.localize(aGesture)]);

      if (_mgMS.history[mgWindowType].length > 14)
        _mgMS.history[mgWindowType].pop();

      _mgMS.history[mgWindowType].unshift([mgGestureHelper.getMapping(aGesture)[1],
                                           mgCommon.mappingLocalizer.localize(aGesture)]);

      mapping.count ? mapping.count++ : mapping.count = 1;
      return true;
    }
    else
      return false;
  },

  mgFireOnLinkGesture : function() {
    if (globalOnLink || globalOnImage) {
      var g = mgGestureState.gesture.join("");
      var twoStroke = g.substr(g.length-2,2);
      var threeStroke = g.substr(g.length-3,3);

      if (!mgGestureExecute.mgFireGestureFromTable("*" + twoStroke))
        return mgGestureExecute.mgFireGestureFromTable("*" + threeStroke);
      else
        return true;
    }
    return false;
  },

  mgCheckForRocker : function(e) {
    if (!mgPrefs.enableRockers && !mgPrefs.enableWheelRockers)
      return false;

    if (mgGestureState.rockerCode == "")
      mgGestureState.rockerCode = ":";

    var mgRockerButton = (mgPrefs.lefthanded) ? Math.abs(e.button - 2) : e.button;
    mgGestureState.rockerCode += "" + mgRockerButton;

    if (!mgPrefs.enableRockers || mgGestureState.rockerCode.length != 3)
      return false;

    return mgGestureExecute.mgFireRocker(mgGestureState.rockerCode, e);
  },

  mgFireRocker : function(code, e) {
    var mapping = mgGestureHelper.getMapping(code)[0];

    if (mapping) {
      gestureInProgress = false;
      var mS = mgCommon.mouseService;

      if (mS)
        mS.stopTrails();

      window.clearTimeout(mgGestureState.gestureTimeout);
      mgWindowTypes.stopAutoScroll();

      if (e && !mS) {
        e.preventDefault();
        e.stopPropagation();
      }

      mgGestureExecute.mgFireGestureFromTable(code, mapping);

      if (mS)
        mS.hasRocked(code);

      return true;
    }
    else
      return false;
  },

  mgReleaseRocker : function(e) {
    if (e) {
      var button = mgPrefs.lefthanded ? Math.abs(e.button - 2) : e.button;
      eval("mgGestureState.rockerCode = mgGestureState.rockerCode.replace(/" + button + "/g, '');");
    }
  },

  mgResetRocker : function(force) {
    if (mgGestureState.rockerCode.length > 1 && (!mgCommon.mouseService || force)) {
      mgGestureState.rockerCode = "";

      if (mgCommon.mouseService)
        mgObserver.mgClearInterval();
    }
  },

  mgFireKeyEvent : function(mData) {
    var ev = document.createEvent("KeyEvents");

    ev.initKeyEvent("keypress", true, true, null,
                    eval(mData[0]), eval(mData[1]), eval(mData[2]), eval(mData[3]),
                    parseInt(mData[4]), parseInt(mData[5]));

    document.documentElement.dispatchEvent(ev);
  }
}