//
// Popup.cs
//
// Contact:
//   Moonlight List (moonlight-list@lists.ximian.com)
//
// Copyright 2008 Novell, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using Mono;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Markup;

namespace System.Windows.Controls.Primitives {

	[MonoTODO("likely need an unmanaged peer for this?")]
	[ContentPropertyAttribute("Child", true)]
	public sealed class Popup : FrameworkElement
	{
		public static readonly DependencyProperty ChildProperty = null;
		public static readonly DependencyProperty HorizontalOffsetProperty = null;
		public static readonly DependencyProperty IsOpenProperty = null;
		public static readonly DependencyProperty VerticalOffsetProperty = null;

		public Popup ()
		{
		}

		public UIElement Child {
			get { return (UIElement)GetValue (ChildProperty); }
			set { SetValue (ChildProperty, value); }
		}

		public double HorizontalOffset {
			get { return (double)GetValue (HorizontalOffsetProperty); }
			set { SetValue (HorizontalOffsetProperty, value); }
		}

		public bool IsOpen {
			get { return (bool)GetValue (IsOpenProperty); }
			set { SetValue (IsOpenProperty, value); }
		}

		public double VerticalOffset {
			get { return (double)GetValue (VerticalOffsetProperty); }
			set { SetValue (VerticalOffsetProperty, value); }
		}

		public event EventHandler Closed;
		public event EventHandler Opened;
	}
}

