//
// System.Windows.Browser.HtmlPage class
//
// Contact:
//   Moonlight List (moonlight-list@lists.ximian.com)
//
// Copyright (C) 2007 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Security;

namespace System.Windows.Browser{

	public static class HtmlPage {
		private static BrowserInformation browser_info = new BrowserInformation ();

		public static BrowserInformation BrowserInformation {
		[SecuritySafeCritical ()]
			get {
				return browser_info;
			}
		}

		public static bool IsEnabled {		
		[SecuritySafeCritical ()]
			get { throw new System.NotImplementedException (); }
		}
		
		public static HtmlDocument Document {
		[SecuritySafeCritical ()]
			get {
				return new HtmlDocument (HtmlObject.GetPropertyInternal<IntPtr> (IntPtr.Zero, "document"));
			}
		}

		public static void UnregisterCreateableType (string scriptAlias)
		{
			throw new System.NotImplementedException ();
		}
		
		public static void RegisterScriptableObject (string scriptKey, object instance)
		{
			throw new System.NotImplementedException ();
		}
		
		public static void RegisterCreateableType (string scriptAlias, Type type)
		{
			throw new System.NotImplementedException ();
		}

		public static HtmlWindow Window {
			[SecuritySafeCritical]
			get {
				return new HtmlWindow (HtmlObject.GetPropertyInternal<IntPtr> (IntPtr.Zero, "window"));
			}
		}

		public static HtmlElement Plugin {
			[SecuritySafeCritical]
			get { throw new System.NotImplementedException (); }
		}
	}
}
