/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.HandleAttributeKeys;

public class BezierOutlineHandle
extends AbstractHandle {
    private boolean isHoverHandle = false;

    public BezierOutlineHandle(BezierFigure bezierFigure) {
        this(bezierFigure, false);
    }

    public BezierOutlineHandle(BezierFigure bezierFigure, boolean bl) {
        super(bezierFigure);
        this.isHoverHandle = bl;
    }

    @Override
    public BezierFigure getOwner() {
        return (BezierFigure)super.getOwner();
    }

    @Override
    protected Rectangle basicGetBounds() {
        return this.view.drawingToView(this.getOwner().getDrawingArea());
    }

    @Override
    public boolean contains(Point point) {
        return false;
    }

    @Override
    public void trackStart(Point point, int n) {
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Color color;
        Stroke stroke;
        Color color2;
        Stroke stroke2;
        BezierFigure bezierFigure = this.getOwner();
        Shape shape = bezierFigure.getBezierPath();
        if (bezierFigure.get(AttributeKeys.TRANSFORM) != null) {
            shape = bezierFigure.get(AttributeKeys.TRANSFORM).createTransformedShape(shape);
        }
        shape = this.view.getDrawingToViewTransform().createTransformedShape(shape);
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            if (this.isHoverHandle) {
                stroke2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_1_HOVER);
                color2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_1_HOVER);
                stroke = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_2_HOVER);
                color = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_2_HOVER);
            } else {
                stroke2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_1);
                color2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_1);
                stroke = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_2);
                color = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_2);
            }
        } else {
            stroke2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_1_DISABLED);
            color2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_1_DISABLED);
            stroke = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_2_DISABLED);
            color = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_2_DISABLED);
        }
        if (stroke2 != null && color2 != null) {
            graphics2D.setStroke(stroke2);
            graphics2D.setColor(color2);
            graphics2D.draw(shape);
        }
        if (stroke != null && color != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color);
            graphics2D.draw(shape);
        }
    }
}

