/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_PAGES_SERVICE_H
#define _MWB_PAGES_SERVICE_H

#include <nsCOMPtr.h>
#include <nsCOMArray.h>
#include <mhs/mhs.h>
#include <dbus/dbus-glib.h>
#include "MwbIPagesService.h"

// {cbc53095-a301-455e-820c-3348f13a6569}
#define MWB_PAGES_SERVICE_CID \
  { 0xcbc53095, 0xa301, 0x455e, \
      { 0x82, 0x0c, 0x33, 0x48, 0xf1, 0x3a, 0x65, 0x69 } }

class MwbPinnedPage : public MwbIPinnedPage
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MWBIPINNEDPAGE

  MwbPinnedPage (const gchar *title,
                 const gchar *uri,
                 PRInt32 visit_time);

private:
  nsCString title, uri, collation_key;
  PRInt32 visit_time;

  void SetTitle (const gchar *title_arg);

  friend class MwbPagesService;
};

class MwbPagesService : public MwbIPagesService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MWBIPAGESSERVICE

  MwbPagesService ();
  ~MwbPagesService ();

  static MwbPagesService *GetSingleton (void);

  void FavoritesReceivedCb (gchar **urls, gchar **titles);

  void LinkVisitedCb (const char *uri, gint visit_time);

  void PinnedPageCb (const gchar *title, const gchar *uri,
                     gint visit_time, gboolean more_pending);
  void UnpinnedPageCb (const gchar *uri);

private:
  static MwbPagesService *pages_service;

  MhsHistory *history;
  MhsCookies *cookies;
  MhsPrefs *prefs;
  MhsLoginManagerStorage *lms;
  MhsPermissionManager *pm;

  nsCOMArray<nsIWeakReference> favorites_observers;

  nsCOMArray<MwbIPinnedPage> pinned_pages_by_title;
  nsCOMArray<MwbIPinnedPage> pinned_pages_by_time;

  void InsertPinnedPageByVisitTime (MwbPinnedPage *pinned_page);

  static void StaticFavoritesReceivedCb (MhsHistory *history,
                                         gchar **urls,
                                         gchar **titles,
                                         MwbPagesService *self);
  static void StaticLinkVisitedCb (MhsHistory *history,
                                   const gchar *uri,
                                   gint visit_time,
                                   MwbPagesService *self);
  static void StaticPinnedPageCb (MhsHistory *history,
                                  const gchar *title,
                                  const gchar *uri,
                                  gint visit_time,
                                  gboolean more_pending,
                                  MwbPagesService *self);
  static void StaticUnpinnedPageCb (MhsHistory *history,
                                    const gchar *uri,
                                    MwbPagesService *self);
};

class MwbFavorite : public MwbIFavorite
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MWBIFAVORITE

  MwbFavorite (const gchar *url, const gchar *title);
  ~MwbFavorite ();

private:
  gchar *url, *title;
};

#endif /* _MWB_PAGES_SERVICE_H */
