/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

// Gettext helper function
function _(str)
{
  var pagesService = (Components.classes["@moblin.org/mwb-pages-service;1"]
                        .getService(Components.interfaces.MwbIPagesService));
  // Replace this function with a faster version that doesn't lookup
  // the service again
  _ = function(s) { return pagesService.gettext(s); }
  // Call it immediately
  return _(str);
}

function MwbGeolocationPrompt()
{
}

MwbGeolocationPrompt.prototype = {
  classDescription : "Geolocation Prompting Component",
  contractID : "@mozilla.org/geolocation/prompt;1",
  classID : Components.ID("{37f80a36-e6d8-4b76-9f01-8f0f4022302d}"),

  QueryInterface: XPCOMUtils.generateQI([Components.interfaces.
                                         nsIGeolocationPrompt]),

  prompt : function(request)
  {
    var pm = Components.classes["@mozilla.org/permissionmanager;1"].
    getService(Components.interfaces.nsIPermissionManager);

    var result = pm.testExactPermission(request.requestingURI, "geo");

    if (result == Components.interfaces.nsIPermissionManager.ALLOW_ACTION)
      request.allow();
    else if (result == Components.interfaces.nsIPermissionManager.DENY_ACTION)
      request.cancel();
    else
      {
        var nsIPromptService = Components.interfaces.nsIPromptService;
        var requestingWindow = request.requestingWindow.top;

        var promptService =
          Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
          .getService(nsIPromptService);

        /* Translators: The two underscores will get replaced with a
         * hostname so they should be in the translation too. Eg the
         * string might become 'www.google.com wants to know your
         * location.' */
        var question = _("__ wants to know your location.").
          replace("__", request.requestingURI.host);

        var checkState = { value: false };

        var choice = promptService.
          confirmEx(requestingWindow,
                    "", question,
                    nsIPromptService.BUTTON_POS_0 *
                    nsIPromptService.BUTTON_TITLE_IS_STRING +
                    nsIPromptService.BUTTON_POS_1 *
                    nsIPromptService.BUTTON_TITLE_IS_STRING +
                    nsIPromptService.BUTTON_POS_0_DEFAULT,
                    _("Share location"),
                    _("Don't share"),
                    null,
                    _("Remember for this site"),
                    checkState);

        if (choice == 0)
          {
            request.allow();
            if (checkState.value)
              pm.add(request.requestingURI, "geo",
                     Components.interfaces.nsIPermissionManager.ALLOW_ACTION);
          }
        else if (choice == 1)
          {
            request.cancel();
            if (checkState.value)
              pm.add(request.requestingURI, "geo",
                     Components.interfaces.nsIPermissionManager.DENY_ACTION);
          }
      }
  }
};

function NSGetModule(aCompMgr, aFileSpec)
{
  return XPCOMUtils.generateModule([MwbGeolocationPrompt]);
}
