/* mwb-action.h */

#ifndef _MWB_ACTION_H
#define _MWB_ACTION_H

#include <glib-object.h>

G_BEGIN_DECLS

#define MWB_TYPE_ACTION mwb_action_get_type()

#define MWB_ACTION(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_ACTION, MwbAction))

#define MWB_ACTION_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_ACTION, MwbActionClass))

#define MWB_IS_ACTION(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_ACTION))

#define MWB_IS_ACTION_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_ACTION))

#define MWB_ACTION_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_ACTION, MwbActionClass))

typedef struct _MwbAction MwbAction;
typedef struct _MwbActionClass MwbActionClass;
typedef struct _MwbActionPrivate MwbActionPrivate;

struct _MwbAction
{
  GInitiallyUnowned parent;

  MwbActionPrivate *priv;
};

struct _MwbActionClass
{
  GInitiallyUnownedClass parent_class;

  void (*activated) (MwbAction *action);
};

GType mwb_action_get_type (void);

MwbAction *mwb_action_new (void);

MwbAction *mwb_action_new_full (const gchar *name,
                                GCallback    activated_cb,
                                gpointer     user_data);

const gchar *mwb_action_get_name (MwbAction *action);
void mwb_action_set_name (MwbAction *action, const gchar *name);

gboolean mwb_action_get_active (MwbAction *action);
void mwb_action_set_active (MwbAction *action, gboolean active);

G_END_DECLS

#endif /* _MWB_ACTION_H */
