/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_CRASH_PAGE_H
#define _MWB_CRASH_PAGE_H

#include <glib-object.h>
#include <nbtk/nbtk.h>
#include "mwb-page.h"

G_BEGIN_DECLS

#define MWB_TYPE_CRASH_PAGE mwb_crash_page_get_type()

#define MWB_CRASH_PAGE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_CRASH_PAGE, MwbCrashPage))

#define MWB_CRASH_PAGE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_CRASH_PAGE, MwbCrashPageClass))

#define MWB_IS_CRASH_PAGE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_CRASH_PAGE))

#define MWB_IS_CRASH_PAGE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_CRASH_PAGE))

#define MWB_CRASH_PAGE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_CRASH_PAGE, MwbCrashPageClass))

typedef struct _MwbCrashPage MwbCrashPage;
typedef struct _MwbCrashPageClass MwbCrashPageClass;
typedef struct _MwbCrashPagePrivate MwbCrashPagePrivate;

struct _MwbCrashPage
{
  NbtkWidget parent;

  MwbCrashPagePrivate *priv;
};

struct _MwbCrashPageClass
{
  NbtkWidgetClass parent_class;

  /* signals */
  void (* new_tab) (MwbCrashPage *page);
  void (* reload)  (MwbCrashPage *page);
};

GType mwb_crash_page_get_type (void) G_GNUC_CONST;

NbtkWidget *mwb_crash_page_new (void);

void mwb_crash_page_set_page (MwbCrashPage *crash_page, MwbPage *page);

G_END_DECLS

#endif /* _MWB_CRASH_PAGE_H */
