/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_ASPECT_CLONE_H
#define _MWB_ASPECT_CLONE_H

#include <glib-object.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define MWB_TYPE_ASPECT_CLONE mwb_aspect_clone_get_type()

#define MWB_ASPECT_CLONE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_ASPECT_CLONE, MwbAspectClone))

#define MWB_ASPECT_CLONE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_ASPECT_CLONE, MwbAspectCloneClass))

#define MWB_IS_ASPECT_CLONE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_ASPECT_CLONE))

#define MWB_IS_ASPECT_CLONE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_ASPECT_CLONE))

#define MWB_ASPECT_CLONE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_ASPECT_CLONE, MwbAspectCloneClass))

typedef struct _MwbAspectClonePrivate MwbAspectClonePrivate;

typedef struct {
  ClutterClone parent;

  MwbAspectClonePrivate *priv;
} MwbAspectClone;

typedef struct {
  ClutterCloneClass parent_class;
} MwbAspectCloneClass;

GType mwb_aspect_clone_get_type (void);

ClutterActor* mwb_aspect_clone_new (ClutterActor *source);

G_END_DECLS

#endif /* _MWB_ASPECT_CLONE_H */

