#!/bin/bash
[ -f /usr/share/acpi-support/state-funcs ] || exit 0 

. /usr/share/acpi-support/power-funcs

# if this is the right behavior, then this should be moved out of acpi-support
# to hal (or whatever is replacing hal for such events)
getXconsole

python <<END
#Toggle the mic mute
import re, subprocess, sys

#TODO shall we add excepton checking or just die?
pactl_stat = subprocess.check_output(["/usr/bin/pactl" , "stat"])

#Find the card name
stat = re.search( r'Default Source: (.*)$', pactl_stat, re.M)
if stat == None:
    sys.exit(-1)
pactl_sources = subprocess.check_output(["/usr/bin/pactl", "list", "sources"])
#Find the mic status
mute = re.search( stat.group(1) + r'.*?Description:.*?Mute: (.*?)$', 

pactl_sources, re.M|re.S)
if mute == None:
    sys.exit(-1)
mute_toggle_translate = {'yes':'0', 'no':'1'}
#Toggle
toggle_result = subprocess.check_output(["/usr/bin/pactl", "set-source-mute", stat.group(1), mute_toggle_translate[ mute.group(1) ]])
END
