
/* File: eggzeitgeistdatasourceregistry.c
 *
 * Generated by eggdbus-binding-tool 0.6. Do not edit.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif
#include <string.h>
#include <eggdbus/eggdbus.h>
#include "eggzeitgeistbindingstypes.h"
#include "eggzeitgeistbindings.h"
#include "eggzeitgeistbindingsmarshal.h"
#include "eggzeitgeistdatasourceregistry.h"

/**
 * SECTION:eggzeitgeistdatasourceregistry
 * @title: EggZeitgeistDataSourceRegistry
 * @short_description: FIXME: not documented.
 *
 * An extension which allows you to registers data sources in a central repository. This allows for example to disable some data sources.
 */

#define _EGG_ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_PROXY         (_egg_zeitgeist_data_source_registry_proxy_get_type())
#define _EGG_ZEITGEIST_DATA_SOURCE_REGISTRY_PROXY(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), _EGG_ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_PROXY, _EggZeitgeistDataSourceRegistryProxy))
#define _EGG_ZEITGEIST_DATA_SOURCE_REGISTRY_PROXY_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), _EGG_ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_PROXY, _EggZeitgeistDataSourceRegistryProxy))
#define _EGG_ZEITGEIST_DATA_SOURCE_REGISTRY_PROXY_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), _EGG_ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_PROXY, _EggZeitgeistDataSourceRegistryProxy))
#define _EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY_PROXY(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), _EGG_ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_PROXY))
#define _EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY_PROXY_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), _EGG_ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_PROXY))

typedef struct _EggZeitgeistDataSourceRegistryProxy _EggZeitgeistDataSourceRegistryProxy;
typedef struct _EggZeitgeistDataSourceRegistryProxyClass _EggZeitgeistDataSourceRegistryProxyClass;

struct _EggZeitgeistDataSourceRegistryProxy
{
  EggDBusInterfaceProxy parent_instance;

  EggDBusObjectProxy *object_proxy;
};

struct _EggZeitgeistDataSourceRegistryProxyClass
{
  EggDBusInterfaceProxyClass parent_class;
};

GType _egg_zeitgeist_data_source_registry_proxy_get_type (void) G_GNUC_CONST;

static void
_proxy_interface_init (EggZeitgeistDataSourceRegistryIface *iface)
{
}

G_DEFINE_TYPE_WITH_CODE (_EggZeitgeistDataSourceRegistryProxy, _egg_zeitgeist_data_source_registry_proxy, EGG_DBUS_TYPE_INTERFACE_PROXY,
                         G_IMPLEMENT_INTERFACE (EGG_ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY, _proxy_interface_init));

static void
_egg_zeitgeist_data_source_registry_proxy_init (_EggZeitgeistDataSourceRegistryProxy *interface_proxy)
{
}

static void
_egg_zeitgeist_data_source_registry_proxy_object_proxy_finalized (gpointer data,
                                  GObject  *where_the_object_was)
{
  _EggZeitgeistDataSourceRegistryProxy *interface_proxy;

  interface_proxy = _EGG_ZEITGEIST_DATA_SOURCE_REGISTRY_PROXY (data);

  g_warning ("object_proxy for _EggZeitgeistDataSourceRegistryProxy finalized but interface proxy still alive; you are not supposed to be reffing instances derived from EggDBusInterfaceProxy");

  interface_proxy->object_proxy = NULL;
}

static void
_egg_zeitgeist_data_source_registry_proxy_finalize (GObject *object)
{
  _EggZeitgeistDataSourceRegistryProxy *interface_proxy;

  interface_proxy = _EGG_ZEITGEIST_DATA_SOURCE_REGISTRY_PROXY (object);

  if (interface_proxy->object_proxy != NULL)
    g_object_weak_unref (G_OBJECT (interface_proxy->object_proxy), _egg_zeitgeist_data_source_registry_proxy_object_proxy_finalized, interface_proxy);

  G_OBJECT_CLASS (_egg_zeitgeist_data_source_registry_proxy_parent_class)->finalize (object);
}

static EggDBusObjectProxy *
_egg_zeitgeist_data_source_registry_proxy_get_object_proxy (EggDBusInterfaceProxy *proxy)
{
  _EggZeitgeistDataSourceRegistryProxy *interface_proxy;

  interface_proxy = _EGG_ZEITGEIST_DATA_SOURCE_REGISTRY_PROXY (proxy);

  return interface_proxy->object_proxy;
}

static EggDBusInterfaceIface *
_egg_zeitgeist_data_source_registry_proxy_get_interface_iface (EggDBusInterfaceProxy *proxy)
{
  return (EggDBusInterfaceIface *) (EGG_ZEITGEIST_DATA_SOURCE_REGISTRY_GET_IFACE (proxy));
}

static void
_egg_zeitgeist_data_source_registry_proxy_class_init (_EggZeitgeistDataSourceRegistryProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);
  EggDBusInterfaceProxyClass *interface_proxy_class = EGG_DBUS_INTERFACE_PROXY_CLASS (klass);

  gobject_class->get_property = G_OBJECT_CLASS(g_type_class_peek_parent (klass))->get_property;
  gobject_class->set_property = G_OBJECT_CLASS(g_type_class_peek_parent (klass))->set_property;
  gobject_class->finalize = _egg_zeitgeist_data_source_registry_proxy_finalize;

  interface_proxy_class->get_object_proxy    = _egg_zeitgeist_data_source_registry_proxy_get_object_proxy;
  interface_proxy_class->get_interface_iface = _egg_zeitgeist_data_source_registry_proxy_get_interface_iface;

};

static EggDBusInterfaceProxy *
_egg_zeitgeist_data_source_registry_proxy_new (EggDBusObjectProxy *object_proxy)
{
  _EggZeitgeistDataSourceRegistryProxy *interface_proxy;

  interface_proxy = _EGG_ZEITGEIST_DATA_SOURCE_REGISTRY_PROXY (g_object_new (_EGG_ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_PROXY, NULL));

  interface_proxy->object_proxy = object_proxy;
  g_object_weak_ref (G_OBJECT (object_proxy), _egg_zeitgeist_data_source_registry_proxy_object_proxy_finalized, interface_proxy);

  return EGG_DBUS_INTERFACE_PROXY (interface_proxy);
};

enum
{
  DATA_SOURCE_REGISTERED_SIGNAL,
  DATA_SOURCE_DISCONNECTED_SIGNAL,
  DATA_SOURCE_ENABLED_SIGNAL,
  __LAST_SIGNAL
};

static guint signals[__LAST_SIGNAL] = {0};

static const EggDBusInterfaceArgInfo arg_info_method_in_register_data_source[] =
{
  {
    "unique_id",
    "s",
    NULL,
  },
  {
    "name",
    "s",
    NULL,
  },
  {
    "description",
    "s",
    NULL,
  },
  {
    "event_templates",
    "a(asaasay)",
    NULL,
  }
};

static const EggDBusInterfaceArgInfo arg_info_method_out_register_data_source[] =
{
  {
    "result",
    "b",
    NULL,
  }
};

static const EggDBusInterfaceArgInfo arg_info_method_in_set_data_source_enabled[] =
{
  {
    "unique_id",
    "s",
    NULL,
  },
  {
    "enabled",
    "b",
    NULL,
  }
};

static const EggDBusInterfaceArgInfo arg_info_method_out_get_data_sources[] =
{
  {
    "arg_0",
    "a(sssa(asaasay)bxb)",
    NULL,
  }
};

static const EggDBusInterfaceMethodInfo method_info[] =
{
  {
    "RegisterDataSource",
    "sssa(asaasay)",
    4,
    arg_info_method_in_register_data_source,
    "b",
    1,
    arg_info_method_out_register_data_source,
    NULL
  },
  {
    "SetDataSourceEnabled",
    "sb",
    2,
    arg_info_method_in_set_data_source_enabled,
    "",
    0,
    NULL,
    NULL
  },
  {
    "GetDataSources",
    "",
    0,
    NULL,
    "a(sssa(asaasay)bxb)",
    1,
    arg_info_method_out_get_data_sources,
    NULL
  }
};

static const EggDBusInterfaceArgInfo arg_info_signal_data_source_registered[] =
{
  {
    "arg_0",
    "(sssa(asaasay)bxb)",
    NULL,
  }
};

static const EggDBusInterfaceArgInfo arg_info_signal_data_source_disconnected[] =
{
  {
    "arg_0",
    "(sssa(asaasay)bxb)",
    NULL,
  }
};

static const EggDBusInterfaceArgInfo arg_info_signal_data_source_enabled[] =
{
  {
    "unique_id",
    "s",
    NULL,
  },
  {
    "enabled",
    "b",
    NULL,
  }
};

static const EggDBusInterfaceSignalInfo signal_info[] =
{
  {
    "DataSourceRegistered",
    "data-source-registered",
    "(sssa(asaasay)bxb)",
    1,
    arg_info_signal_data_source_registered,
    NULL
  },
  {
    "DataSourceDisconnected",
    "data-source-disconnected",
    "(sssa(asaasay)bxb)",
    1,
    arg_info_signal_data_source_disconnected,
    NULL
  },
  {
    "DataSourceEnabled",
    "data-source-enabled",
    "sb",
    2,
    arg_info_signal_data_source_enabled,
    NULL
  }
};

static const EggDBusInterfaceInfo interface_info =
{
  "org.gnome.zeitgeist.DataSourceRegistry",
  3,
  method_info,
  3,
  signal_info,
  0,
  NULL,
  NULL,
};

static const EggDBusInterfaceInfo *
get_interface_info (void)
{
  return &interface_info;
}

static void handle_message     (EggDBusInterface        *interface,
                                EggDBusMessage          *message);

static void
base_init (gpointer g_iface)
{
  static gboolean is_initialized = FALSE;

  if (!is_initialized)
    {
      EggDBusInterfaceIface *gdbus_iface_vtable = (EggDBusInterfaceIface *) g_iface;

      egg_zeitgeist_bindings_get_error_domain_types ();

      gdbus_iface_vtable->get_interface_info  = get_interface_info;
      gdbus_iface_vtable->handle_message      = handle_message;
      gdbus_iface_vtable->get_interface_proxy = _egg_zeitgeist_data_source_registry_proxy_new;


      /**
       * EggZeitgeistDataSourceRegistry::data-source-registered:
       * @instance: A #EggZeitgeistDataSourceRegistry.
       * @arg_0: FIXME: not documented.
       *
       * FIXME: not documented.
       */
      signals[DATA_SOURCE_REGISTERED_SIGNAL] = 
          g_signal_new ("data-source-registered",
                        G_TYPE_FROM_INTERFACE (g_iface),
                        G_SIGNAL_RUN_LAST,
                        0,                      /* class offset     */
                        NULL,                   /* accumulator      */
                        NULL,                   /* accumulator data */
                        _egg_zeitgeist_cclosure_marshal_VOID__OBJECT,
                        G_TYPE_NONE,
                        1,
                        EGG_ZEITGEIST_TYPE_DATA_SOURCE);

      /**
       * EggZeitgeistDataSourceRegistry::data-source-disconnected:
       * @instance: A #EggZeitgeistDataSourceRegistry.
       * @arg_0: FIXME: not documented.
       *
       * FIXME: not documented.
       */
      signals[DATA_SOURCE_DISCONNECTED_SIGNAL] = 
          g_signal_new ("data-source-disconnected",
                        G_TYPE_FROM_INTERFACE (g_iface),
                        G_SIGNAL_RUN_LAST,
                        0,                      /* class offset     */
                        NULL,                   /* accumulator      */
                        NULL,                   /* accumulator data */
                        _egg_zeitgeist_cclosure_marshal_VOID__OBJECT,
                        G_TYPE_NONE,
                        1,
                        EGG_ZEITGEIST_TYPE_DATA_SOURCE);

      /**
       * EggZeitgeistDataSourceRegistry::data-source-enabled:
       * @instance: A #EggZeitgeistDataSourceRegistry.
       * @unique_id: FIXME: not documented.
       * @enabled: FIXME: not documented.
       *
       * FIXME: not documented.
       */
      signals[DATA_SOURCE_ENABLED_SIGNAL] = 
          g_signal_new ("data-source-enabled",
                        G_TYPE_FROM_INTERFACE (g_iface),
                        G_SIGNAL_RUN_LAST,
                        0,                      /* class offset     */
                        NULL,                   /* accumulator      */
                        NULL,                   /* accumulator data */
                        _egg_zeitgeist_cclosure_marshal_VOID__STRING_BOOLEAN,
                        G_TYPE_NONE,
                        2,
                        G_TYPE_STRING,
                        G_TYPE_BOOLEAN);


      is_initialized = TRUE;
    }
}

GType
egg_zeitgeist_data_source_registry_get_type (void)
{
  static GType iface_type = 0;

  if (iface_type == 0)
    {
      static const GTypeInfo info =
      {
        sizeof (EggZeitgeistDataSourceRegistryIface),
        base_init,              /* base_init      */
        NULL,                   /* base_finalize  */
        NULL,                   /* class_init     */
        NULL,                   /* class_finalize */
        NULL,                   /* class_data     */
        0,                      /* instance_size  */
        0,                      /* n_preallocs    */
        NULL,                   /* instance_init  */
        NULL                    /* value_table    */
      };

      iface_type = g_type_register_static (G_TYPE_INTERFACE, "EggZeitgeistDataSourceRegistry", &info, 0);

      g_type_interface_add_prerequisite (iface_type, G_TYPE_OBJECT);
    }

  return iface_type;
}

static void
generic_async_callback (GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data)
{
  GSimpleAsyncResult *simple = G_SIMPLE_ASYNC_RESULT (user_data);
  EggDBusMessage *reply;
  GError *error;

  error = NULL;
  reply = egg_dbus_connection_send_message_with_reply_finish (EGG_DBUS_CONNECTION (source_object),
                                                              res,
                                                              &error);
  if (reply == NULL)
    {
      g_simple_async_result_set_from_error (simple, error);
      g_error_free (error);
    }
  else
    {
      g_simple_async_result_set_op_res_gpointer (simple, reply, (GDestroyNotify) g_object_unref);
    }

  g_simple_async_result_complete (simple);
  g_object_unref (simple);
}

/**
 * egg_zeitgeist_data_source_registry_register_data_source:
 * @instance: A #EggZeitgeistDataSourceRegistry.
 * @call_flags: Flags from #EggDBusCallFlags detailing how the method should be invoked.
 * @unique_id: FIXME: not documented.
 * @name: FIXME: not documented.
 * @description: FIXME: not documented.
 * @event_templates: FIXME: not documented.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback to invoke when the reply is ready.
 * @user_data: User data to pass to @callback.
 *
 * FIXME: not documented.
 *
 * This function asynchronously invokes the <link linkend="eggdbus-method-org.gnome.zeitgeist.DataSourceRegistry.RegisterDataSource">RegisterDataSource<!-- -->()</link> method
 * on the <link linkend="eggdbus-interface-org.gnome.zeitgeist.DataSourceRegistry">org.gnome.zeitgeist.DataSourceRegistry</link> interface
 * on the object represented by @instance.
 * When the reply is ready, @callback will be called (on the main thread).
 * You can then call egg_zeitgeist_data_source_registry_register_data_source_finish() to get the result.
 * See egg_zeitgeist_data_source_registry_register_data_source_sync() for the synchronous version of this function.
 *
 * Returns: A pending call id (never zero) that can be used with egg_dbus_connection_pending_call_cancel() or egg_dbus_connection_pending_call_block().
 */
guint
egg_zeitgeist_data_source_registry_register_data_source (
    EggZeitgeistDataSourceRegistry *instance,
    EggDBusCallFlags call_flags,
    const gchar *_unique_id,
    const gchar *_name,
    const gchar *_description,
    EggDBusArraySeq *_event_templates,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  EggDBusObjectProxy *object_proxy;
  EggDBusMessage *message;
  GSimpleAsyncResult *simple;
  GError *error;
  guint pending_call_id;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance) && EGG_DBUS_IS_INTERFACE_PROXY (instance), 0);

  simple = g_simple_async_result_new (G_OBJECT (instance),
                                      callback,
                                      user_data,
                                      egg_zeitgeist_data_source_registry_register_data_source);

  object_proxy = egg_dbus_interface_proxy_get_object_proxy (EGG_DBUS_INTERFACE_PROXY (instance));

  message = egg_dbus_connection_new_message_for_method_call (egg_dbus_object_proxy_get_connection (object_proxy),
                                                             NULL,
                                                             egg_dbus_object_proxy_get_name (object_proxy),
                                                             egg_dbus_object_proxy_get_object_path (object_proxy),
                                                             "org.gnome.zeitgeist.DataSourceRegistry",
                                                             "RegisterDataSource");

  error = NULL;

  if (!egg_dbus_message_append_string (message, _unique_id, &error))
    goto out;
  if (!egg_dbus_message_append_string (message, _name, &error))
    goto out;
  if (!egg_dbus_message_append_string (message, _description, &error))
    goto out;
  if (!egg_dbus_message_append_seq (message, _event_templates, "(asaasay)", &error))
    goto out;

  pending_call_id = egg_dbus_connection_send_message_with_reply (egg_dbus_object_proxy_get_connection (object_proxy), call_flags, message, egg_zeitgeist_bindings_get_error_domain_types (), cancellable, generic_async_callback, simple);

  g_object_unref (message);
  return pending_call_id;
out:
  g_simple_async_result_set_from_error (simple, error);
  g_simple_async_result_complete (simple);
  g_object_unref (simple);
  g_error_free (error);
  g_object_unref (message);
  return 0;
}

/**
 * egg_zeitgeist_data_source_registry_register_data_source_finish:
 * @instance: A #EggZeitgeistDataSourceRegistry.
 * @out_result: FIXME: not documented.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to egg_zeitgeist_data_source_registry_register_data_source().
 * @error: Return location for error.
 *
 * Finishes an asynchronous method invocation started with egg_zeitgeist_data_source_registry_register_data_source().
 *
 * Returns: %TRUE if the method call succeeded, %FALSE if @error is set.
 */
gboolean
egg_zeitgeist_data_source_registry_register_data_source_finish (
    EggZeitgeistDataSourceRegistry *instance,
    gboolean *_out_result,
    GAsyncResult *res,
    GError **error)
{
  GSimpleAsyncResult *simple = G_SIMPLE_ASYNC_RESULT (res);
  EggDBusMessage *reply;
  gboolean ret;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance) && EGG_DBUS_IS_INTERFACE_PROXY (instance), FALSE);

  g_warn_if_fail (g_simple_async_result_get_source_tag (simple) == egg_zeitgeist_data_source_registry_register_data_source);

  ret = FALSE;
  reply = NULL;

  if (g_simple_async_result_propagate_error (simple, error))
    goto out;

  reply = EGG_DBUS_MESSAGE (g_object_ref (g_simple_async_result_get_op_res_gpointer (simple)));

  if (reply == NULL)
    {
      g_simple_async_result_propagate_error (simple, error);
      goto out;
    }

  if (!egg_dbus_message_extract_boolean (reply, _out_result, error))
    goto out;

  ret = TRUE;

out:
  if (reply != NULL)
    g_object_unref (reply);
  return ret;
}

/**
 * egg_zeitgeist_data_source_registry_register_data_source_sync:
 * @instance: A #EggZeitgeistDataSourceRegistry.
 * @call_flags: Flags from #EggDBusCallFlags detailing how the method should be invoked.
 * @unique_id: FIXME: not documented.
 * @name: FIXME: not documented.
 * @description: FIXME: not documented.
 * @event_templates: FIXME: not documented.
 * @out_result: FIXME: not documented.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error.
 *
 * FIXME: not documented.
 *
 * This function synchronously invokes the <link linkend="eggdbus-method-org.gnome.zeitgeist.DataSourceRegistry.RegisterDataSource">RegisterDataSource<!-- -->()</link> method on the <link linkend="eggdbus-interface-org.gnome.zeitgeist.DataSourceRegistry">org.gnome.zeitgeist.DataSourceRegistry</link> interface on the object represented by @instance.
 * See egg_zeitgeist_data_source_registry_register_data_source() for the asynchronous version of this function.
 *
 * Returns: %TRUE if the method call succeeded, %FALSE if @error is set.
 */
gboolean
egg_zeitgeist_data_source_registry_register_data_source_sync (
    EggZeitgeistDataSourceRegistry *instance,
    EggDBusCallFlags call_flags,
    const gchar *_unique_id,
    const gchar *_name,
    const gchar *_description,
    EggDBusArraySeq *_event_templates,
    gboolean *_out_result,
    GCancellable *cancellable,
    GError **error)
{
  EggDBusObjectProxy *object_proxy;
  EggDBusMessage *message;
  EggDBusMessage *reply;
  gboolean ret;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance) && EGG_DBUS_IS_INTERFACE_PROXY (instance), FALSE);

  ret = FALSE;  reply = NULL;
  object_proxy = egg_dbus_interface_proxy_get_object_proxy (EGG_DBUS_INTERFACE_PROXY (instance));

  message = egg_dbus_connection_new_message_for_method_call (egg_dbus_object_proxy_get_connection (object_proxy),
                                                             NULL,
                                                             egg_dbus_object_proxy_get_name (object_proxy),
                                                             egg_dbus_object_proxy_get_object_path (object_proxy),
                                                             "org.gnome.zeitgeist.DataSourceRegistry",
                                                             "RegisterDataSource");

  if (!egg_dbus_message_append_string (message, _unique_id, error))
    goto out;
  if (!egg_dbus_message_append_string (message, _name, error))
    goto out;
  if (!egg_dbus_message_append_string (message, _description, error))
    goto out;
  if (!egg_dbus_message_append_seq (message, _event_templates, "(asaasay)", error))
    goto out;

  reply = egg_dbus_connection_send_message_with_reply_sync (egg_dbus_object_proxy_get_connection (object_proxy), call_flags, message, egg_zeitgeist_bindings_get_error_domain_types (), cancellable, error);
  if (reply == NULL)
    goto out;

  if (!egg_dbus_message_extract_boolean (reply, _out_result, error))
    goto out;

  ret = TRUE;

out:
  if (message != NULL)
    g_object_unref (message);
  if (reply != NULL)
    g_object_unref (reply);
  return ret;
}

/**
 * egg_zeitgeist_data_source_registry_set_data_source_enabled:
 * @instance: A #EggZeitgeistDataSourceRegistry.
 * @call_flags: Flags from #EggDBusCallFlags detailing how the method should be invoked.
 * @unique_id: FIXME: not documented.
 * @enabled: FIXME: not documented.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback to invoke when the reply is ready.
 * @user_data: User data to pass to @callback.
 *
 * FIXME: not documented.
 *
 * This function asynchronously invokes the <link linkend="eggdbus-method-org.gnome.zeitgeist.DataSourceRegistry.SetDataSourceEnabled">SetDataSourceEnabled<!-- -->()</link> method
 * on the <link linkend="eggdbus-interface-org.gnome.zeitgeist.DataSourceRegistry">org.gnome.zeitgeist.DataSourceRegistry</link> interface
 * on the object represented by @instance.
 * When the reply is ready, @callback will be called (on the main thread).
 * You can then call egg_zeitgeist_data_source_registry_set_data_source_enabled_finish() to get the result.
 * See egg_zeitgeist_data_source_registry_set_data_source_enabled_sync() for the synchronous version of this function.
 *
 * Returns: A pending call id (never zero) that can be used with egg_dbus_connection_pending_call_cancel() or egg_dbus_connection_pending_call_block().
 */
guint
egg_zeitgeist_data_source_registry_set_data_source_enabled (
    EggZeitgeistDataSourceRegistry *instance,
    EggDBusCallFlags call_flags,
    const gchar *_unique_id,
    gboolean _enabled,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  EggDBusObjectProxy *object_proxy;
  EggDBusMessage *message;
  GSimpleAsyncResult *simple;
  GError *error;
  guint pending_call_id;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance) && EGG_DBUS_IS_INTERFACE_PROXY (instance), 0);

  simple = g_simple_async_result_new (G_OBJECT (instance),
                                      callback,
                                      user_data,
                                      egg_zeitgeist_data_source_registry_set_data_source_enabled);

  object_proxy = egg_dbus_interface_proxy_get_object_proxy (EGG_DBUS_INTERFACE_PROXY (instance));

  message = egg_dbus_connection_new_message_for_method_call (egg_dbus_object_proxy_get_connection (object_proxy),
                                                             NULL,
                                                             egg_dbus_object_proxy_get_name (object_proxy),
                                                             egg_dbus_object_proxy_get_object_path (object_proxy),
                                                             "org.gnome.zeitgeist.DataSourceRegistry",
                                                             "SetDataSourceEnabled");

  error = NULL;

  if (!egg_dbus_message_append_string (message, _unique_id, &error))
    goto out;
  if (!egg_dbus_message_append_boolean (message, _enabled, &error))
    goto out;

  pending_call_id = egg_dbus_connection_send_message_with_reply (egg_dbus_object_proxy_get_connection (object_proxy), call_flags, message, egg_zeitgeist_bindings_get_error_domain_types (), cancellable, generic_async_callback, simple);

  g_object_unref (message);
  return pending_call_id;
out:
  g_simple_async_result_set_from_error (simple, error);
  g_simple_async_result_complete (simple);
  g_object_unref (simple);
  g_error_free (error);
  g_object_unref (message);
  return 0;
}

/**
 * egg_zeitgeist_data_source_registry_set_data_source_enabled_finish:
 * @instance: A #EggZeitgeistDataSourceRegistry.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to egg_zeitgeist_data_source_registry_set_data_source_enabled().
 * @error: Return location for error.
 *
 * Finishes an asynchronous method invocation started with egg_zeitgeist_data_source_registry_set_data_source_enabled().
 *
 * Returns: %TRUE if the method call succeeded, %FALSE if @error is set.
 */
gboolean
egg_zeitgeist_data_source_registry_set_data_source_enabled_finish (
    EggZeitgeistDataSourceRegistry *instance,
    GAsyncResult *res,
    GError **error)
{
  GSimpleAsyncResult *simple = G_SIMPLE_ASYNC_RESULT (res);
  EggDBusMessage *reply;
  gboolean ret;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance) && EGG_DBUS_IS_INTERFACE_PROXY (instance), FALSE);

  g_warn_if_fail (g_simple_async_result_get_source_tag (simple) == egg_zeitgeist_data_source_registry_set_data_source_enabled);

  ret = FALSE;
  reply = NULL;

  if (g_simple_async_result_propagate_error (simple, error))
    goto out;

  reply = EGG_DBUS_MESSAGE (g_object_ref (g_simple_async_result_get_op_res_gpointer (simple)));

  if (reply == NULL)
    {
      g_simple_async_result_propagate_error (simple, error);
      goto out;
    }


  ret = TRUE;

out:
  if (reply != NULL)
    g_object_unref (reply);
  return ret;
}

/**
 * egg_zeitgeist_data_source_registry_set_data_source_enabled_sync:
 * @instance: A #EggZeitgeistDataSourceRegistry.
 * @call_flags: Flags from #EggDBusCallFlags detailing how the method should be invoked.
 * @unique_id: FIXME: not documented.
 * @enabled: FIXME: not documented.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error.
 *
 * FIXME: not documented.
 *
 * This function synchronously invokes the <link linkend="eggdbus-method-org.gnome.zeitgeist.DataSourceRegistry.SetDataSourceEnabled">SetDataSourceEnabled<!-- -->()</link> method on the <link linkend="eggdbus-interface-org.gnome.zeitgeist.DataSourceRegistry">org.gnome.zeitgeist.DataSourceRegistry</link> interface on the object represented by @instance.
 * See egg_zeitgeist_data_source_registry_set_data_source_enabled() for the asynchronous version of this function.
 *
 * Returns: %TRUE if the method call succeeded, %FALSE if @error is set.
 */
gboolean
egg_zeitgeist_data_source_registry_set_data_source_enabled_sync (
    EggZeitgeistDataSourceRegistry *instance,
    EggDBusCallFlags call_flags,
    const gchar *_unique_id,
    gboolean _enabled,
    GCancellable *cancellable,
    GError **error)
{
  EggDBusObjectProxy *object_proxy;
  EggDBusMessage *message;
  EggDBusMessage *reply;
  gboolean ret;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance) && EGG_DBUS_IS_INTERFACE_PROXY (instance), FALSE);

  ret = FALSE;  reply = NULL;
  object_proxy = egg_dbus_interface_proxy_get_object_proxy (EGG_DBUS_INTERFACE_PROXY (instance));

  message = egg_dbus_connection_new_message_for_method_call (egg_dbus_object_proxy_get_connection (object_proxy),
                                                             NULL,
                                                             egg_dbus_object_proxy_get_name (object_proxy),
                                                             egg_dbus_object_proxy_get_object_path (object_proxy),
                                                             "org.gnome.zeitgeist.DataSourceRegistry",
                                                             "SetDataSourceEnabled");

  if (!egg_dbus_message_append_string (message, _unique_id, error))
    goto out;
  if (!egg_dbus_message_append_boolean (message, _enabled, error))
    goto out;

  reply = egg_dbus_connection_send_message_with_reply_sync (egg_dbus_object_proxy_get_connection (object_proxy), call_flags, message, egg_zeitgeist_bindings_get_error_domain_types (), cancellable, error);
  if (reply == NULL)
    goto out;


  ret = TRUE;

out:
  if (message != NULL)
    g_object_unref (message);
  if (reply != NULL)
    g_object_unref (reply);
  return ret;
}

/**
 * egg_zeitgeist_data_source_registry_get_data_sources:
 * @instance: A #EggZeitgeistDataSourceRegistry.
 * @call_flags: Flags from #EggDBusCallFlags detailing how the method should be invoked.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback to invoke when the reply is ready.
 * @user_data: User data to pass to @callback.
 *
 * FIXME: not documented.
 *
 * This function asynchronously invokes the <link linkend="eggdbus-method-org.gnome.zeitgeist.DataSourceRegistry.GetDataSources">GetDataSources<!-- -->()</link> method
 * on the <link linkend="eggdbus-interface-org.gnome.zeitgeist.DataSourceRegistry">org.gnome.zeitgeist.DataSourceRegistry</link> interface
 * on the object represented by @instance.
 * When the reply is ready, @callback will be called (on the main thread).
 * You can then call egg_zeitgeist_data_source_registry_get_data_sources_finish() to get the result.
 * See egg_zeitgeist_data_source_registry_get_data_sources_sync() for the synchronous version of this function.
 *
 * Returns: A pending call id (never zero) that can be used with egg_dbus_connection_pending_call_cancel() or egg_dbus_connection_pending_call_block().
 */
guint
egg_zeitgeist_data_source_registry_get_data_sources (
    EggZeitgeistDataSourceRegistry *instance,
    EggDBusCallFlags call_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  EggDBusObjectProxy *object_proxy;
  EggDBusMessage *message;
  GSimpleAsyncResult *simple;
  GError *error;
  guint pending_call_id;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance) && EGG_DBUS_IS_INTERFACE_PROXY (instance), 0);

  simple = g_simple_async_result_new (G_OBJECT (instance),
                                      callback,
                                      user_data,
                                      egg_zeitgeist_data_source_registry_get_data_sources);

  object_proxy = egg_dbus_interface_proxy_get_object_proxy (EGG_DBUS_INTERFACE_PROXY (instance));

  message = egg_dbus_connection_new_message_for_method_call (egg_dbus_object_proxy_get_connection (object_proxy),
                                                             NULL,
                                                             egg_dbus_object_proxy_get_name (object_proxy),
                                                             egg_dbus_object_proxy_get_object_path (object_proxy),
                                                             "org.gnome.zeitgeist.DataSourceRegistry",
                                                             "GetDataSources");

  error = NULL;


  pending_call_id = egg_dbus_connection_send_message_with_reply (egg_dbus_object_proxy_get_connection (object_proxy), call_flags, message, egg_zeitgeist_bindings_get_error_domain_types (), cancellable, generic_async_callback, simple);

  g_object_unref (message);
  return pending_call_id;
}

/**
 * egg_zeitgeist_data_source_registry_get_data_sources_finish:
 * @instance: A #EggZeitgeistDataSourceRegistry.
 * @out_arg_0: FIXME: not documented. Free with g_object_unref().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to egg_zeitgeist_data_source_registry_get_data_sources().
 * @error: Return location for error.
 *
 * Finishes an asynchronous method invocation started with egg_zeitgeist_data_source_registry_get_data_sources().
 *
 * Returns: %TRUE if the method call succeeded, %FALSE if @error is set.
 */
gboolean
egg_zeitgeist_data_source_registry_get_data_sources_finish (
    EggZeitgeistDataSourceRegistry *instance,
    EggDBusArraySeq **_out_arg_0,
    GAsyncResult *res,
    GError **error)
{
  GSimpleAsyncResult *simple = G_SIMPLE_ASYNC_RESULT (res);
  EggDBusMessage *reply;
  gboolean ret;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance) && EGG_DBUS_IS_INTERFACE_PROXY (instance), FALSE);

  g_warn_if_fail (g_simple_async_result_get_source_tag (simple) == egg_zeitgeist_data_source_registry_get_data_sources);

  ret = FALSE;
  reply = NULL;

  if (g_simple_async_result_propagate_error (simple, error))
    goto out;

  reply = EGG_DBUS_MESSAGE (g_object_ref (g_simple_async_result_get_op_res_gpointer (simple)));

  if (reply == NULL)
    {
      g_simple_async_result_propagate_error (simple, error);
      goto out;
    }

  if (!egg_dbus_message_extract_seq (reply, _out_arg_0, error))
    goto out;

  ret = TRUE;

out:
  if (reply != NULL)
    g_object_unref (reply);
  return ret;
}

/**
 * egg_zeitgeist_data_source_registry_get_data_sources_sync:
 * @instance: A #EggZeitgeistDataSourceRegistry.
 * @call_flags: Flags from #EggDBusCallFlags detailing how the method should be invoked.
 * @out_arg_0: FIXME: not documented. Free with g_object_unref().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error.
 *
 * FIXME: not documented.
 *
 * This function synchronously invokes the <link linkend="eggdbus-method-org.gnome.zeitgeist.DataSourceRegistry.GetDataSources">GetDataSources<!-- -->()</link> method on the <link linkend="eggdbus-interface-org.gnome.zeitgeist.DataSourceRegistry">org.gnome.zeitgeist.DataSourceRegistry</link> interface on the object represented by @instance.
 * See egg_zeitgeist_data_source_registry_get_data_sources() for the asynchronous version of this function.
 *
 * Returns: %TRUE if the method call succeeded, %FALSE if @error is set.
 */
gboolean
egg_zeitgeist_data_source_registry_get_data_sources_sync (
    EggZeitgeistDataSourceRegistry *instance,
    EggDBusCallFlags call_flags,
    EggDBusArraySeq **_out_arg_0,
    GCancellable *cancellable,
    GError **error)
{
  EggDBusObjectProxy *object_proxy;
  EggDBusMessage *message;
  EggDBusMessage *reply;
  gboolean ret;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance) && EGG_DBUS_IS_INTERFACE_PROXY (instance), FALSE);

  ret = FALSE;  reply = NULL;
  object_proxy = egg_dbus_interface_proxy_get_object_proxy (EGG_DBUS_INTERFACE_PROXY (instance));

  message = egg_dbus_connection_new_message_for_method_call (egg_dbus_object_proxy_get_connection (object_proxy),
                                                             NULL,
                                                             egg_dbus_object_proxy_get_name (object_proxy),
                                                             egg_dbus_object_proxy_get_object_path (object_proxy),
                                                             "org.gnome.zeitgeist.DataSourceRegistry",
                                                             "GetDataSources");


  reply = egg_dbus_connection_send_message_with_reply_sync (egg_dbus_object_proxy_get_connection (object_proxy), call_flags, message, egg_zeitgeist_bindings_get_error_domain_types (), cancellable, error);
  if (reply == NULL)
    goto out;

  if (!egg_dbus_message_extract_seq (reply, _out_arg_0, error))
    goto out;

  ret = TRUE;

out:
  if (message != NULL)
    g_object_unref (message);
  if (reply != NULL)
    g_object_unref (reply);
  return ret;
}

static void
handle_signal (EggDBusInterface *interface,
               EggDBusMessage   *message)
{
  guint n;
  guint num_args;
  guint signal_id;
  const gchar *expected_signature;
  const gchar *signature;
  const gchar *signal_name;
  GValue *instance_and_params;

  signature = egg_dbus_message_get_signature (message);
  signal_name = egg_dbus_message_get_signal_name (message);

  if (strcmp (signal_name, "DataSourceRegistered") == 0)
    {
      expected_signature = "(sssa(asaasay)bxb)";
      if (strcmp (signature, expected_signature) != 0)
        goto wrong_signature;
      signal_id = signals[DATA_SOURCE_REGISTERED_SIGNAL];
      num_args = 1;
      instance_and_params = g_new0 (GValue, num_args + 1);
      instance_and_params[1].g_type = EGG_ZEITGEIST_TYPE_DATA_SOURCE;
    }
  else if (strcmp (signal_name, "DataSourceDisconnected") == 0)
    {
      expected_signature = "(sssa(asaasay)bxb)";
      if (strcmp (signature, expected_signature) != 0)
        goto wrong_signature;
      signal_id = signals[DATA_SOURCE_DISCONNECTED_SIGNAL];
      num_args = 1;
      instance_and_params = g_new0 (GValue, num_args + 1);
      instance_and_params[1].g_type = EGG_ZEITGEIST_TYPE_DATA_SOURCE;
    }
  else if (strcmp (signal_name, "DataSourceEnabled") == 0)
    {
      expected_signature = "sb";
      if (strcmp (signature, expected_signature) != 0)
        goto wrong_signature;
      signal_id = signals[DATA_SOURCE_ENABLED_SIGNAL];
      num_args = 2;
      instance_and_params = g_new0 (GValue, num_args + 1);
      instance_and_params[1].g_type = G_TYPE_STRING;
      instance_and_params[2].g_type = G_TYPE_BOOLEAN;
    }
  else
    {
      g_warning ("%s: Ignoring unknown signal '%s' on interface '%s' with signature '%s'", G_STRFUNC, signal_name, interface_info.name, signature);
     goto out;
    }

  g_value_init (&(instance_and_params[0]), EGG_DBUS_TYPE_INTERFACE_PROXY);
  g_value_set_object (&(instance_and_params[0]), EGG_DBUS_INTERFACE_PROXY (interface));

  for (n = 0; n < num_args; n++)
    {
      GType saved_type = instance_and_params[n + 1].g_type;
      instance_and_params[n + 1].g_type = 0;
      g_assert (egg_dbus_message_extract_gvalue (message,
                                                 &(instance_and_params[n + 1]),
                                                 NULL));
      instance_and_params[n + 1].g_type = saved_type;
    }

  g_signal_emitv (instance_and_params,
                  signal_id,
                  0,
                  NULL);

  for (n = 0; n < num_args + 1; n++)
    g_value_unset (&(instance_and_params[n]));
  g_free (instance_and_params);

out:
    return;

wrong_signature:
  g_warning ("%s: Ignoring signal '%s' on interface '%s' with malformed signature '%s', expected signature '%s'", G_STRFUNC, signal_name, interface_info.name, signature, expected_signature);
}

static void
handle_method_call (EggDBusInterface  *interface,
                    EggDBusMessage    *message)
{
  GError *error;
  const gchar *signature;
  const gchar *method_name;
  const gchar *expected_signature;
  EggZeitgeistDataSourceRegistryIface *iface;
  EggDBusMethodInvocation *method_invocation;

  error = NULL;

  signature = egg_dbus_message_get_signature (message);
  method_name = egg_dbus_message_get_method_name (message);
  iface = EGG_ZEITGEIST_DATA_SOURCE_REGISTRY_GET_IFACE (interface);

  if (strcmp (method_name, "RegisterDataSource") == 0)
    {
      gchar *_unique_id;
      gchar *_name;
      gchar *_description;
      EggDBusArraySeq *_event_templates;

      expected_signature = "sssa(asaasay)";
      if (strcmp (signature, expected_signature) != 0)
        goto wrong_signature;

      if (iface->handle_register_data_source == NULL)
        goto not_implemented;

      if (!egg_dbus_message_extract_string (message, &_unique_id, &error))
        goto extraction_error;
      if (!egg_dbus_message_extract_string (message, &_name, &error))
        goto extraction_error;
      if (!egg_dbus_message_extract_string (message, &_description, &error))
        goto extraction_error;
      if (!egg_dbus_message_extract_seq (message, &_event_templates, &error))
        goto extraction_error;

      method_invocation = egg_dbus_method_invocation_new (message,
                                                          egg_zeitgeist_data_source_registry_handle_register_data_source_finish);

      egg_dbus_method_invocation_add_destroy_notify (method_invocation,
                                                   _unique_id,
                                                   (GDestroyNotify) g_free);
      egg_dbus_method_invocation_add_destroy_notify (method_invocation,
                                                   _name,
                                                   (GDestroyNotify) g_free);
      egg_dbus_method_invocation_add_destroy_notify (method_invocation,
                                                   _description,
                                                   (GDestroyNotify) g_free);
      egg_dbus_method_invocation_add_destroy_notify (method_invocation,
                                                   _event_templates,
                                                   (GDestroyNotify) g_object_unref);

      iface->handle_register_data_source (EGG_ZEITGEIST_DATA_SOURCE_REGISTRY (interface), _unique_id, _name, _description, _event_templates, method_invocation);

    }
  else if (strcmp (method_name, "SetDataSourceEnabled") == 0)
    {
      gchar *_unique_id;
      gboolean _enabled;

      expected_signature = "sb";
      if (strcmp (signature, expected_signature) != 0)
        goto wrong_signature;

      if (iface->handle_set_data_source_enabled == NULL)
        goto not_implemented;

      if (!egg_dbus_message_extract_string (message, &_unique_id, &error))
        goto extraction_error;
      if (!egg_dbus_message_extract_boolean (message, &_enabled, &error))
        goto extraction_error;

      method_invocation = egg_dbus_method_invocation_new (message,
                                                          egg_zeitgeist_data_source_registry_handle_set_data_source_enabled_finish);

      egg_dbus_method_invocation_add_destroy_notify (method_invocation,
                                                   _unique_id,
                                                   (GDestroyNotify) g_free);

      iface->handle_set_data_source_enabled (EGG_ZEITGEIST_DATA_SOURCE_REGISTRY (interface), _unique_id, _enabled, method_invocation);

    }
  else if (strcmp (method_name, "GetDataSources") == 0)
    {
      expected_signature = "";
      if (strcmp (signature, expected_signature) != 0)
        goto wrong_signature;

      if (iface->handle_get_data_sources == NULL)
        goto not_implemented;

      method_invocation = egg_dbus_method_invocation_new (message,
                                                          egg_zeitgeist_data_source_registry_handle_get_data_sources_finish);

      iface->handle_get_data_sources (EGG_ZEITGEIST_DATA_SOURCE_REGISTRY (interface), method_invocation);

    }
  else
    {
      g_warning ("%s: Ignoring unknown method call '%s' on interface '%s' with signature '%s'", G_STRFUNC, method_name, interface_info.name, signature);
    }

  return;

not_implemented:
  g_warning ("%s: Method call '%s' on interface '%s' with signature '%s' is not implemented on GObject class %s", G_STRFUNC, method_name, interface_info.name, signature, g_type_name (G_TYPE_FROM_INSTANCE (interface)));
  return;

wrong_signature:
  g_warning ("%s: Ignoring method call '%s' on interface '%s' with malformed signature '%s', expected signature '%s'", G_STRFUNC, method_name, interface_info.name, signature, expected_signature);
  return;

extraction_error:
  g_warning ("%s: Error extracting arguments for method call '%s' on interface '%s' with signature '%s': %s", G_STRFUNC, method_name, interface_info.name, signature, error->message);
  g_error_free (error);
}

/**
 * egg_zeitgeist_data_source_registry_handle_register_data_source_finish:
 * @result: FIXME: not documented.
 * @method_invocation: A #EggDBusMethodInvocation.
 *
 * Function to be called by implementers of the
 * <link linkend="eggdbus-interface-org.gnome.zeitgeist.DataSourceRegistry">org.gnome.zeitgeist.DataSourceRegistry</link>
 * D-Bus interface to finish handling the
 * <link linkend="eggdbus-method-org.gnome.zeitgeist.DataSourceRegistry.RegisterDataSource">RegisterDataSource<!-- -->()</link> method.
 *
 */
void
egg_zeitgeist_data_source_registry_handle_register_data_source_finish (
    EggDBusMethodInvocation *method_invocation,
    gboolean _out_result)
{
  GError *error;
  EggDBusMessage *reply;

  error = NULL;

  g_warn_if_fail (egg_dbus_method_invocation_get_source_tag (method_invocation) ==
                  egg_zeitgeist_data_source_registry_handle_register_data_source_finish);

  reply = egg_dbus_method_invocation_create_reply_message (method_invocation);

  if (!egg_dbus_message_append_boolean (reply, _out_result, &error))
    goto malformed;

  egg_dbus_connection_send_message (egg_dbus_message_get_connection (reply), reply);

  g_object_unref (reply);
  g_object_unref (method_invocation);

  return;

malformed:
  g_warning ("%s: Malformed data passed: %s", G_STRFUNC, error->message);
  g_error_free (error);
}

/**
 * egg_zeitgeist_data_source_registry_handle_set_data_source_enabled_finish:
 * @method_invocation: A #EggDBusMethodInvocation.
 *
 * Function to be called by implementers of the
 * <link linkend="eggdbus-interface-org.gnome.zeitgeist.DataSourceRegistry">org.gnome.zeitgeist.DataSourceRegistry</link>
 * D-Bus interface to finish handling the
 * <link linkend="eggdbus-method-org.gnome.zeitgeist.DataSourceRegistry.SetDataSourceEnabled">SetDataSourceEnabled<!-- -->()</link> method.
 *
 */
void
egg_zeitgeist_data_source_registry_handle_set_data_source_enabled_finish (
    EggDBusMethodInvocation *method_invocation)
{
  GError *error;
  EggDBusMessage *reply;

  error = NULL;

  g_warn_if_fail (egg_dbus_method_invocation_get_source_tag (method_invocation) ==
                  egg_zeitgeist_data_source_registry_handle_set_data_source_enabled_finish);

  reply = egg_dbus_method_invocation_create_reply_message (method_invocation);


  egg_dbus_connection_send_message (egg_dbus_message_get_connection (reply), reply);

  g_object_unref (reply);
  g_object_unref (method_invocation);

  return;
}

/**
 * egg_zeitgeist_data_source_registry_handle_get_data_sources_finish:
 * @arg_0: FIXME: not documented.
 * @method_invocation: A #EggDBusMethodInvocation.
 *
 * Function to be called by implementers of the
 * <link linkend="eggdbus-interface-org.gnome.zeitgeist.DataSourceRegistry">org.gnome.zeitgeist.DataSourceRegistry</link>
 * D-Bus interface to finish handling the
 * <link linkend="eggdbus-method-org.gnome.zeitgeist.DataSourceRegistry.GetDataSources">GetDataSources<!-- -->()</link> method.
 *
 */
void
egg_zeitgeist_data_source_registry_handle_get_data_sources_finish (
    EggDBusMethodInvocation *method_invocation,
    EggDBusArraySeq *_out_arg_0)
{
  GError *error;
  EggDBusMessage *reply;

  error = NULL;

  g_warn_if_fail (egg_dbus_method_invocation_get_source_tag (method_invocation) ==
                  egg_zeitgeist_data_source_registry_handle_get_data_sources_finish);

  reply = egg_dbus_method_invocation_create_reply_message (method_invocation);

  if (!egg_dbus_message_append_seq (reply, _out_arg_0, "(sssa(asaasay)bxb)", &error))
    goto malformed;

  egg_dbus_connection_send_message (egg_dbus_message_get_connection (reply), reply);

  g_object_unref (reply);
  g_object_unref (method_invocation);

  return;

malformed:
  g_warning ("%s: Malformed data passed: %s", G_STRFUNC, error->message);
  g_error_free (error);
}

static void
handle_message (EggDBusInterface *interface,
                EggDBusMessage   *message)
{

  switch (egg_dbus_message_get_message_type (message))
    {
    case EGG_DBUS_MESSAGE_TYPE_SIGNAL:
      handle_signal (interface, message);
      break;

    case EGG_DBUS_MESSAGE_TYPE_METHOD_CALL:
      handle_method_call (interface, message);
      break;

    default:
      g_assert_not_reached ();
      break;
    }
}

/**
 * egg_zeitgeist_data_source_registry_emit_signal_data_source_registered:
 * @instance: A #GObject derived type implementing the #EggZeitgeistDataSourceRegistry interface.
 * @destination: The destination of the signal or %NULL to emit signals to all listeners.
 * @arg_0: FIXME: not documented.
 *
 * Type safe wrapper for emitting the #EggZeitgeistDataSourceRegistry::data-source-registered signal.
 *
 **/
void
egg_zeitgeist_data_source_registry_emit_signal_data_source_registered (
    EggZeitgeistDataSourceRegistry *instance,
    const gchar *destination,
    EggZeitgeistDataSource *arg_0)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance));

  g_signal_emit_by_name (instance,
                         "data-source-registered",
                         arg_0);
}

/**
 * egg_zeitgeist_data_source_registry_emit_signal_data_source_disconnected:
 * @instance: A #GObject derived type implementing the #EggZeitgeistDataSourceRegistry interface.
 * @destination: The destination of the signal or %NULL to emit signals to all listeners.
 * @arg_0: FIXME: not documented.
 *
 * Type safe wrapper for emitting the #EggZeitgeistDataSourceRegistry::data-source-disconnected signal.
 *
 **/
void
egg_zeitgeist_data_source_registry_emit_signal_data_source_disconnected (
    EggZeitgeistDataSourceRegistry *instance,
    const gchar *destination,
    EggZeitgeistDataSource *arg_0)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance));

  g_signal_emit_by_name (instance,
                         "data-source-disconnected",
                         arg_0);
}

/**
 * egg_zeitgeist_data_source_registry_emit_signal_data_source_enabled:
 * @instance: A #GObject derived type implementing the #EggZeitgeistDataSourceRegistry interface.
 * @destination: The destination of the signal or %NULL to emit signals to all listeners.
 * @unique_id: FIXME: not documented.
 * @enabled: FIXME: not documented.
 *
 * Type safe wrapper for emitting the #EggZeitgeistDataSourceRegistry::data-source-enabled signal.
 *
 **/
void
egg_zeitgeist_data_source_registry_emit_signal_data_source_enabled (
    EggZeitgeistDataSourceRegistry *instance,
    const gchar *destination,
    const gchar *unique_id,
    gboolean enabled)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE_REGISTRY (instance));

  g_signal_emit_by_name (instance,
                         "data-source-enabled",
                         unique_id,
                         enabled);
}

