import Qt 4.7

Item {
    id: detail
    height: 16

    Image {
        id: detailPresenceIcon
        y: 3
        width: source != "" ? 12: 0
        height: 12
        smooth: true
    }

    Text {
        id: detailLabel
        anchors.left: detailPresenceIcon.right
        anchors.leftMargin: 2
        font.bold: true
    }

    Text {
        id: detailText
        font.bold: detailAction.visible
        anchors.left: {
            if (detailLabel.text != "")
                return detailLabel.right;
            else
                return detailPresenceIcon.right;
        }
        anchors.leftMargin: detailPresenceIcon.visible ? 2 : 0
        color: detailAction.visible ? "#2020aa" : "black";
    }

    MouseArea {
        id: detailAction
        property string action: ""
        visible: action != ""
        anchors.fill: detailText
        onClicked: {
            contactModel.startAction(detailAction.action);
        }
    }

    function populate(label, text, icon, action, rows) {
        detailLabel.text = label == "" ? "" : label + ": ";
        detailText.text = text;
        detailPresenceIcon.source = icon;
        detailAction.action = action;
        detail.height = rows * 17;
    }

    function destroy() {
        // If there is no delay the item is not always deleted...
        detail.destroy(1);
    }
}
