/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;
import org.powermock.reflect.exceptions.ConstructorNotFoundException;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.exceptions.MethodInvocationException;
import org.powermock.reflect.exceptions.MethodNotFoundException;
import org.powermock.reflect.exceptions.TooManyConstructorsFoundException;
import org.powermock.reflect.exceptions.TooManyFieldsFoundException;
import org.powermock.reflect.exceptions.TooManyMethodsFoundException;
import org.powermock.reflect.internal.TypeUtils;
import org.powermock.reflect.internal.matcherstrategies.AllFieldsMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.AssignableFromFieldTypeMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.AssignableToFieldTypeMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.FieldAnnotationMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.FieldMatcherStrategy;
import org.powermock.reflect.internal.matcherstrategies.FieldNameMatcherStrategy;
import org.powermock.reflect.internal.primitivesupport.PrimitiveWrapper;
import org.powermock.reflect.matching.FieldMatchingStrategy;
import org.powermock.reflect.spi.ProxyFramework;

public class WhiteboxImpl {
    private static ProxyFramework proxyFramework = null;

    public static Method getMethod(Class<?> clazz, Class<?> ... classArray) {
        Class<?> clazz2 = clazz;
        if (classArray == null) {
            classArray = new Class[]{};
        }
        LinkedList<Method> linkedList = new LinkedList<Method>();
        while (clazz2 != null) {
            Method[] methodArray = null;
            methodArray = clazz2.isInterface() ? WhiteboxImpl.getAllPublicMethods(clazz2) : clazz2.getDeclaredMethods();
            for (Method method : methodArray) {
                if (!WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), classArray, method.getParameterTypes())) continue;
                linkedList.add(method);
                if (linkedList.size() != 1) continue;
                method.setAccessible(true);
            }
            if (linkedList.size() == 1) {
                return (Method)linkedList.get(0);
            }
            if (linkedList.size() > 1) break;
            clazz2 = clazz2.getSuperclass();
        }
        if (linkedList.isEmpty()) {
            throw new MethodNotFoundException("No method was found with parameter types: [ " + WhiteboxImpl.getArgumentTypesAsString(classArray) + " ] in class " + WhiteboxImpl.getUnmockedType(clazz).getName() + ".");
        }
        WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("method name", linkedList.toArray(new Method[linkedList.size()]));
        return null;
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Class<?> clazz2 = clazz;
        if (classArray == null) {
            classArray = new Class[]{};
        }
        while (clazz2 != null) {
            Method[] methodArray = null;
            methodArray = clazz2.isInterface() ? WhiteboxImpl.getAllPublicMethods(clazz2) : clazz2.getDeclaredMethods();
            for (Method method : methodArray) {
                if (!string.equals(method.getName()) || !WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), classArray, method.getParameterTypes())) continue;
                method.setAccessible(true);
                return method;
            }
            clazz2 = clazz2.getSuperclass();
        }
        WhiteboxImpl.throwExceptionIfMethodWasNotFound(clazz, string, null, new Object[]{classArray});
        return null;
    }

    public static Field getField(Class<?> clazz, String string) {
        LinkedList linkedList = new LinkedList();
        linkedList.add(clazz);
        HashSet<Class> hashSet = new HashSet<Class>();
        while (!linkedList.isEmpty()) {
            Class clazz2 = (Class)linkedList.removeFirst();
            hashSet.add(clazz2);
            Field[] fieldArray = clazz2.getDeclaredFields();
            for (Field field : fieldArray) {
                if (!string.equals(field.getName())) continue;
                field.setAccessible(true);
                return field;
            }
            HashSet hashSet2 = new HashSet();
            Class clazz3 = clazz2.getSuperclass();
            if (clazz3 != null) {
                hashSet2.add(clazz2.getSuperclass());
            }
            hashSet2.addAll(Arrays.asList(clazz2.getInterfaces()));
            hashSet2.removeAll(hashSet);
            linkedList.addAll(hashSet2);
        }
        WhiteboxImpl.throwExceptionIfFieldWasNotFound(clazz, string, null);
        return null;
    }

    public static <T> T newInstance(Class<T> clazz) {
        Object object;
        int n = clazz.getModifiers();
        if (Modifier.isInterface(n)) {
            object = Proxy.newProxyInstance(WhiteboxImpl.class.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

                @Override
                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    return TypeUtils.getDefaultValue(method.getReturnType());
                }
            });
        } else if (clazz.isArray()) {
            object = Array.newInstance(clazz.getComponentType(), 0);
        } else {
            if (Modifier.isAbstract(n)) {
                throw new IllegalArgumentException("Cannot instantiate an abstract class. Please use the ConcreteClassGenerator in PowerMock support to generate a concrete class first.");
            }
            ObjenesisStd objenesisStd = new ObjenesisStd();
            ObjectInstantiator objectInstantiator = objenesisStd.getInstantiatorOf(clazz);
            object = objectInstantiator.newInstance();
        }
        return (T)object;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... classArray) {
        Class<?> clazz2 = WhiteboxImpl.getUnmockedType(clazz);
        try {
            Constructor<?> constructor = clazz2.getDeclaredConstructor(classArray);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new ConstructorNotFoundException(String.format("Failed to lookup constructor with parameter types [ %s ] in class %s.", WhiteboxImpl.getArgumentTypesAsString(classArray), clazz2.getName()), throwable);
        }
    }

    public static void setInternalState(Object object, String string, Object object2) {
        Field field = WhiteboxImpl.findFieldInHierarchy(object, string);
        WhiteboxImpl.setField(object, object2, field);
    }

    public static void setInternalState(Object object, String string, Object[] objectArray) {
        WhiteboxImpl.setInternalState(object, string, (Object)objectArray);
    }

    public static void setInternalState(Object object, Class<?> clazz, Object object2) {
        WhiteboxImpl.setField(object, object2, WhiteboxImpl.findFieldInHierarchy(object, new AssignableFromFieldTypeMatcherStrategy(clazz)));
    }

    public static void setInternalState(Object object, Object object2, Object ... objectArray) {
        WhiteboxImpl.setField(object, object2, WhiteboxImpl.findFieldInHierarchy(object, new AssignableFromFieldTypeMatcherStrategy(WhiteboxImpl.getType(object2))));
        if (objectArray != null && objectArray.length > 0) {
            for (Object object3 : objectArray) {
                WhiteboxImpl.setField(object, object3, WhiteboxImpl.findFieldInHierarchy(object, new AssignableFromFieldTypeMatcherStrategy(WhiteboxImpl.getType(object3))));
            }
        }
    }

    public static void setInternalState(Object object, Object object2, Class<?> clazz) {
        WhiteboxImpl.setField(object, object2, WhiteboxImpl.findField(object, new AssignableFromFieldTypeMatcherStrategy(WhiteboxImpl.getType(object2)), clazz));
    }

    public static void setInternalState(Object object, Class<?> clazz, Object object2, Class<?> clazz2) {
        if (clazz == null || clazz2 == null) {
            throw new IllegalArgumentException("fieldType and where cannot be null");
        }
        WhiteboxImpl.setField(object, object2, WhiteboxImpl.findFieldOrThrowException(clazz, clazz2));
    }

    public static void setInternalState(Object object, String string, Object object2, Class<?> clazz) {
        if (object == null || string == null || string.equals("") || string.startsWith(" ")) {
            throw new IllegalArgumentException("object, field name, and \"where\" must not be empty or null.");
        }
        Field field = WhiteboxImpl.getField(string, clazz);
        try {
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal Error: Failed to set field in method setInternalState.", exception);
        }
    }

    public static <T> T getInternalState(Object object, String string) {
        Field field = WhiteboxImpl.findFieldInHierarchy(object, string);
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", illegalAccessException);
        }
    }

    private static Field findFieldInHierarchy(Object object, String string) {
        return WhiteboxImpl.findFieldInHierarchy(object, new FieldNameMatcherStrategy(string));
    }

    private static Field findFieldInHierarchy(Object object, FieldMatcherStrategy fieldMatcherStrategy) {
        WhiteboxImpl.assertObjectInGetInternalStateIsNotNull(object);
        return WhiteboxImpl.findSingleFieldUsingStrategy(fieldMatcherStrategy, object, true, WhiteboxImpl.getType(object));
    }

    private static Field findField(Object object, FieldMatcherStrategy fieldMatcherStrategy, Class<?> clazz) {
        return WhiteboxImpl.findSingleFieldUsingStrategy(fieldMatcherStrategy, object, false, clazz);
    }

    private static Field findSingleFieldUsingStrategy(FieldMatcherStrategy fieldMatcherStrategy, Object object, boolean bl, Class<?> clazz) {
        WhiteboxImpl.assertObjectInGetInternalStateIsNotNull(object);
        Field field = null;
        Class<?> clazz2 = clazz;
        while (clazz != null) {
            Field[] fieldArray;
            for (Field field2 : fieldArray = clazz.getDeclaredFields()) {
                if (!fieldMatcherStrategy.matches(field2) || !WhiteboxImpl.hasFieldProperModifier(object, field2)) continue;
                if (field != null) {
                    throw new TooManyFieldsFoundException("Two or more fields matching " + fieldMatcherStrategy + ".");
                }
                field = field2;
            }
            if (field != null || !bl) break;
            clazz = clazz.getSuperclass();
        }
        if (field == null) {
            fieldMatcherStrategy.notFound(clazz2, !WhiteboxImpl.isClass(object));
        }
        field.setAccessible(true);
        return field;
    }

    private static Set<Field> findAllFieldsUsingStrategy(FieldMatcherStrategy fieldMatcherStrategy, Object object, boolean bl, Class<?> clazz) {
        WhiteboxImpl.assertObjectInGetInternalStateIsNotNull(object);
        LinkedHashSet<Field> linkedHashSet = new LinkedHashSet<Field>();
        while (clazz != null) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (!fieldMatcherStrategy.matches(field) || !WhiteboxImpl.hasFieldProperModifier(object, field)) continue;
                field.setAccessible(true);
                linkedHashSet.add(field);
            }
            if (!bl) break;
            clazz = clazz.getSuperclass();
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    private static boolean hasFieldProperModifier(Object object, Field field) {
        return object instanceof Class && Modifier.isStatic(field.getModifiers()) || !(object instanceof Class) && !Modifier.isStatic(field.getModifiers());
    }

    public static <T> T getInternalState(Object object, Class<T> clazz) {
        Field field = WhiteboxImpl.findFieldInHierarchy(object, new AssignableToFieldTypeMatcherStrategy(clazz));
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", illegalAccessException);
        }
    }

    public static <T> T getInternalState(Object object, Class<T> clazz, Class<?> clazz2) {
        if (object == null) {
            throw new IllegalArgumentException("object and type are not allowed to be null");
        }
        try {
            return (T)WhiteboxImpl.findFieldOrThrowException(clazz, clazz2).get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", illegalAccessException);
        }
    }

    public static <T> T getInternalState(Object object, String string, Class<?> clazz) {
        if (object == null || string == null || string.equals("") || string.startsWith(" ")) {
            throw new IllegalArgumentException("object, field name, and \"where\" must not be empty or null.");
        }
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new FieldNotFoundException("Field '" + string + "' was not found in class " + clazz.getName() + ".");
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", exception);
        }
    }

    public static synchronized <T> T invokeMethod(Object object, Object ... objectArray) throws Exception {
        return WhiteboxImpl.doInvokeMethod(object, null, null, objectArray);
    }

    public static synchronized <T> T invokeMethod(Class<?> clazz, Object ... objectArray) throws Exception {
        return WhiteboxImpl.doInvokeMethod(clazz, null, null, objectArray);
    }

    public static synchronized <T> T invokeMethod(Object object, String string, Object ... objectArray) throws Exception {
        return WhiteboxImpl.doInvokeMethod(object, null, string, objectArray);
    }

    public static synchronized <T> T invokeMethod(Object object, String string, Class<?>[] classArray, Object ... objectArray) throws Exception {
        Class<?> clazz = WhiteboxImpl.getType(object);
        Method method = WhiteboxImpl.getMethod(clazz, string, classArray);
        if (method == null) {
            WhiteboxImpl.throwExceptionIfMethodWasNotFound(clazz, string, null, objectArray);
        }
        return WhiteboxImpl.performMethodInvocation(object, method, objectArray);
    }

    public static synchronized <T> T invokeMethod(Object object, String string, Class<?> clazz, Class<?>[] classArray, Object ... objectArray) throws Exception {
        Method method = WhiteboxImpl.getMethod(clazz, string, classArray);
        if (method == null) {
            WhiteboxImpl.throwExceptionIfMethodWasNotFound(clazz, string, null, objectArray);
        }
        return WhiteboxImpl.performMethodInvocation(object, method, objectArray);
    }

    public static synchronized <T> T invokeMethod(Object object, Class<?> clazz, String string, Object ... objectArray) throws Exception {
        return WhiteboxImpl.doInvokeMethod(object, clazz, string, objectArray);
    }

    public static synchronized <T> T invokeMethod(Object object, Class<?> clazz, String string, Class<?>[] classArray, Object ... objectArray) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        Method method = WhiteboxImpl.getMethod(clazz, string, classArray);
        return WhiteboxImpl.performMethodInvocation(object, method, objectArray);
    }

    public static synchronized <T> T invokeMethod(Class<?> clazz, String string, Object ... objectArray) throws Exception {
        return WhiteboxImpl.doInvokeMethod(clazz, null, string, objectArray);
    }

    private static <T> T doInvokeMethod(Object object, Class<?> clazz, String string, Object ... objectArray) throws Exception {
        Method method = WhiteboxImpl.findMethodOrThrowException(object, clazz, string, objectArray);
        return WhiteboxImpl.performMethodInvocation(object, method, objectArray);
    }

    public static Method findMethodOrThrowException(Object object, Class<?> clazz, String string, Object[] objectArray) {
        if (object == null) {
            throw new IllegalArgumentException("The object to perform the operation on cannot be null.");
        }
        Class<?> clazz2 = null;
        clazz2 = WhiteboxImpl.isClass(object) ? (Class<?>)object : object.getClass();
        Method[] methodArray = null;
        methodArray = clazz == null ? WhiteboxImpl.getAllMethods(clazz2) : clazz.getDeclaredMethods();
        Method method = null;
        for (Method method2 : methodArray) {
            if (string != null && !method2.getName().equals(string)) continue;
            Class<?>[] classArray = method2.getParameterTypes();
            if (objectArray != null && classArray.length == objectArray.length) {
                if (classArray.length == 0) {
                    method = method2;
                    break;
                }
                boolean bl = WhiteboxImpl.checkArgumentTypesMatchParameterTypes(method2.isVarArgs(), classArray, objectArray);
                if (!bl) continue;
                if (method == null) {
                    method = method2;
                    continue;
                }
                if (method.getName().equals(method2.getName())) {
                    if (WhiteboxImpl.areAllArgumentsOfSameType(objectArray) && method.getDeclaringClass() != method2.getDeclaringClass()) {
                        return method;
                    }
                    return WhiteboxImpl.getBestMethodCandidate(WhiteboxImpl.getType(object), method2.getName(), WhiteboxImpl.getTypes(objectArray), false);
                }
                WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("argument parameter types", new Method[]{method, method2});
                continue;
            }
            if (WhiteboxImpl.isPotentialVarArgsMethod(method2, objectArray)) {
                if (method == null) {
                    method = method2;
                    break;
                }
                WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("argument parameter types", new Method[]{method, method2});
                break;
            }
            if (objectArray != null && classArray.length != objectArray.length || objectArray != null || classArray.length != 1 || classArray[0].isPrimitive()) continue;
            method = method2;
        }
        WhiteboxImpl.throwExceptionIfMethodWasNotFound(WhiteboxImpl.getType(object), string, method, objectArray);
        return method;
    }

    private static Class<?>[] getTypes(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = WhiteboxImpl.getType(objectArray[i]);
        }
        return classArray;
    }

    public static Method getBestMethodCandidate(Class<?> clazz, String string, Class<?>[] classArray, boolean bl) {
        Method method;
        Method[] methodArray = WhiteboxImpl.getMethods(clazz, string, classArray, bl);
        if (methodArray.length == 1) {
            method = methodArray[0];
        } else {
            Arrays.sort(methodArray, new Comparator<Method>(){

                @Override
                public int compare(Method method, Method method2) {
                    Class<?>[] classArray = method.getParameterTypes();
                    Class<?>[] classArray2 = method2.getParameterTypes();
                    int n = classArray.length;
                    for (int i = 0; i < n; ++i) {
                        Class<?> clazz = classArray[i];
                        Class<?> clazz2 = classArray2[i];
                        if (clazz.equals(clazz2)) continue;
                        if (clazz.isAssignableFrom(clazz2)) {
                            if (!clazz.isArray() && clazz2.isArray()) {
                                return -1;
                            }
                            return 1;
                        }
                        if (clazz.isArray() && !clazz2.isArray()) {
                            return 1;
                        }
                        return -1;
                    }
                    return 0;
                }
            });
            method = methodArray[0];
        }
        return method;
    }

    public static Constructor<?> findDefaultConstructorOrThrowException(Class<?> clazz) {
        Constructor<?> constructor;
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConstructorNotFoundException(String.format("Couldn't find a default constructor in %s.", clazz.getName()));
        }
        return constructor;
    }

    public static Constructor<?> findConstructorOrThrowException(Class<?> clazz) {
        Constructor<?>[] constructorArray = WhiteboxImpl.filterPowerMockConstructor(clazz.getDeclaredConstructors());
        if (constructorArray.length > 1) {
            WhiteboxImpl.throwExceptionWhenMultipleConstructorMatchesFound(constructorArray);
        }
        return constructorArray[0];
    }

    private static Constructor<?>[] filterPowerMockConstructor(Constructor<?>[] constructorArray) {
        HashSet hashSet = new HashSet();
        for (Constructor<?> constructor : constructorArray) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length >= 1 && classArray[classArray.length - 1].getName().equals("org.powermock.core.IndicateReloadClass")) continue;
            hashSet.add(constructor);
        }
        return hashSet.toArray(new Constructor[hashSet.size()]);
    }

    public static Constructor<?> findUniqueConstructorOrThrowException(Class<?> clazz, Object ... objectArray) {
        Object[] objectArray2;
        if (clazz == null) {
            throw new IllegalArgumentException("Class type cannot be null.");
        }
        Class<?> clazz2 = WhiteboxImpl.getUnmockedType(clazz);
        if ((clazz2.isLocalClass() || clazz2.isAnonymousClass() || clazz2.isMemberClass()) && !Modifier.isStatic(clazz2.getModifiers()) && objectArray != null) {
            objectArray2 = new Object[objectArray.length + 1];
            objectArray2[0] = clazz2.getEnclosingClass();
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
            objectArray = objectArray2;
        }
        objectArray2 = WhiteboxImpl.filterPowerMockConstructor(clazz2.getDeclaredConstructors());
        Constructor<?> constructor = null;
        for (Constructor<?> constructor2 : objectArray2) {
            Class<?>[] classArray = constructor2.getParameterTypes();
            if (objectArray != null && classArray.length == objectArray.length) {
                if (classArray.length == 0) {
                    constructor = constructor2;
                    break;
                }
                boolean bl = WhiteboxImpl.checkArgumentTypesMatchParameterTypes(constructor2.isVarArgs(), classArray, objectArray);
                if (!bl) continue;
                if (constructor == null) {
                    constructor = constructor2;
                    continue;
                }
                WhiteboxImpl.throwExceptionWhenMultipleConstructorMatchesFound(new Constructor[]{constructor, constructor2});
                continue;
            }
            if (WhiteboxImpl.isPotentialVarArgsConstructor(constructor2, objectArray)) {
                if (constructor == null) {
                    constructor = constructor2;
                    break;
                }
                WhiteboxImpl.throwExceptionWhenMultipleConstructorMatchesFound(new Constructor[]{constructor, constructor2});
                break;
            }
            if (objectArray != null && classArray.length == objectArray.length) continue;
        }
        WhiteboxImpl.throwExceptionIfConstructorWasNotFound(clazz, constructor, objectArray);
        return constructor;
    }

    private static Class<?>[] convertArgumentTypesToPrimitive(Class<?>[] classArray, Object[] objectArray) {
        Class[] classArray2 = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Class<?> clazz = null;
            clazz = objectArray[i] == null ? classArray[i] : WhiteboxImpl.getType(objectArray[i]);
            Class<?> clazz2 = PrimitiveWrapper.getPrimitiveFromWrapperType(clazz);
            classArray2[i] = clazz2 == null ? clazz : clazz2;
        }
        return classArray2;
    }

    public static void throwExceptionIfMethodWasNotFound(Class<?> clazz, String string, Method method, Object ... objectArray) {
        if (method == null) {
            String string2 = "";
            if (string != null) {
                string2 = "with name '" + string + "' ";
            }
            throw new MethodNotFoundException("No method found " + string2 + "with parameter types: [ " + WhiteboxImpl.getArgumentTypesAsString(objectArray) + " ] in class " + WhiteboxImpl.getUnmockedType(clazz).getName() + ".");
        }
    }

    public static void throwExceptionIfFieldWasNotFound(Class<?> clazz, String string, Field field) {
        if (field == null) {
            throw new FieldNotFoundException("No field was found with name '" + string + "' in class " + WhiteboxImpl.getUnmockedType(clazz).getName() + ".");
        }
    }

    static void throwExceptionIfConstructorWasNotFound(Class<?> clazz, Constructor<?> constructor, Object ... objectArray) {
        if (constructor == null) {
            String string = "No constructor found in class '" + WhiteboxImpl.getUnmockedType(clazz).getName() + "' with " + "parameter types: [ " + WhiteboxImpl.getArgumentTypesAsString(objectArray) + " ].";
            throw new ConstructorNotFoundException(string);
        }
    }

    private static String getArgumentTypesAsString(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (objectArray != null && objectArray.length != 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = null;
                Object object = objectArray[i];
                if (object instanceof Class) {
                    string = ((Class)object).getName();
                } else if (object instanceof Class[] && objectArray.length == 1) {
                    Object[] objectArray2 = (Class[])object;
                    if (objectArray2.length > 0) {
                        for (int j = 0; j < objectArray2.length; ++j) {
                            WhiteboxImpl.appendArgument(stringBuilder, j, objectArray2[j] == null ? "null" : WhiteboxImpl.getType(objectArray2[j]).getName(), objectArray2);
                        }
                        return stringBuilder.toString();
                    }
                    string = "<none>";
                } else {
                    string = object == null ? "null" : WhiteboxImpl.getType(object).getName();
                }
                WhiteboxImpl.appendArgument(stringBuilder, i, string, objectArray);
            }
        } else {
            stringBuilder.append("<none>");
        }
        return stringBuilder.toString();
    }

    private static void appendArgument(StringBuilder stringBuilder, int n, String string, Object[] objectArray) {
        stringBuilder.append(string);
        if (n != objectArray.length - 1) {
            stringBuilder.append(", ");
        }
    }

    public static <T> T invokeConstructor(Class<T> clazz, Class<?>[] classArray, Object[] objectArray) throws Exception {
        if (classArray != null && objectArray != null && classArray.length != objectArray.length) {
            throw new IllegalArgumentException("parameterTypes and arguments must have the same length");
        }
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(classArray);
        }
        catch (Exception exception) {
            throw new ConstructorNotFoundException("Could not lookup the constructor", exception);
        }
        return WhiteboxImpl.createInstance(constructor, objectArray);
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object ... objectArray) throws Exception {
        if (clazz == null) {
            throw new IllegalArgumentException("The class should contain the constructor cannot be null.");
        }
        Class[] classArray = null;
        if (objectArray == null) {
            classArray = new Class[]{};
        } else {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = WhiteboxImpl.getType(objectArray[i]);
            }
        }
        Constructor<T> constructor = null;
        Constructor<T> constructor2 = null;
        Constructor<T> constructor3 = null;
        try {
            constructor2 = clazz.getDeclaredConstructor(classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            constructor3 = clazz.getDeclaredConstructor(PrimitiveWrapper.toPrimitiveType(classArray));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (constructor3 == null && constructor2 == null) {
            constructor = WhiteboxImpl.getPotentialVarArgsConstructor(clazz, objectArray);
            if (constructor == null) {
                throw new ConstructorNotFoundException("Failed to find a constructor with parameter types: [" + WhiteboxImpl.getArgumentTypesAsString(objectArray) + "]");
            }
        } else if (constructor3 == null && constructor2 != null) {
            constructor = constructor2;
        } else if (constructor3 != null && constructor2 == null) {
            constructor = constructor3;
        } else if (objectArray == null || objectArray.length == 0 && constructor3 != null) {
            constructor = constructor3;
        } else {
            throw new TooManyConstructorsFoundException("Could not determine which constructor to execute. Please specify the parameter types by hand.");
        }
        return WhiteboxImpl.createInstance(constructor, objectArray);
    }

    private static <T> Constructor<T> getPotentialVarArgsConstructor(Class<T> clazz, Object ... objectArray) {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
            if (!constructor.isVarArgs()) continue;
            if (objectArray == null || objectArray.length == 0) {
                return constructor;
            }
            Class<?>[] classArray = constructor.getParameterTypes();
            if (!classArray[classArray.length - 1].getComponentType().isAssignableFrom(WhiteboxImpl.getType(objectArray[0]))) continue;
            return constructor;
        }
        return null;
    }

    private static <T> T createInstance(Constructor<T> constructor, Object ... objectArray) throws Exception {
        T t;
        block7: {
            if (constructor == null) {
                throw new IllegalArgumentException("Constructor cannot be null");
            }
            constructor.setAccessible(true);
            t = null;
            try {
                if (constructor.isVarArgs()) {
                    Class<?>[] classArray = constructor.getParameterTypes();
                    int n = classArray.length - 1;
                    Class<?> clazz = classArray[n].getComponentType();
                    Object object = WhiteboxImpl.createAndPopulateVarArgsArray(clazz, n, objectArray);
                    Object[] objectArray2 = new Object[classArray.length];
                    for (int i = 0; i < n; ++i) {
                        objectArray2[i] = objectArray[i];
                    }
                    objectArray2[objectArray2.length - 1] = object;
                    t = constructor.newInstance(objectArray2);
                } else {
                    t = constructor.newInstance(objectArray);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                if (!(throwable instanceof Error)) break block7;
                throw (Error)throwable;
            }
        }
        return t;
    }

    private static Object createAndPopulateVarArgsArray(Class<?> clazz, int n, Object ... objectArray) {
        Object object = Array.newInstance(clazz, objectArray.length - n);
        for (int i = n; i < objectArray.length; ++i) {
            Array.set(object, i - n, objectArray[i]);
        }
        return object;
    }

    public static Constructor<?>[] getAllConstructors(Class<?> clazz) {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
            if (constructor.isAccessible()) continue;
            constructor.setAccessible(true);
        }
        return constructorArray;
    }

    public static Method[] getAllMethods(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("You must specify a class in order to get the methods.");
        }
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray;
            final Class<?> clazz3 = clazz2;
            for (Method method : methodArray = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    return clazz3.getDeclaredMethods();
                }
            })) {
                method.setAccessible(true);
                linkedHashSet.add(method);
            }
        }
        return linkedHashSet.toArray(new Method[0]);
    }

    private static Method[] getAllPublicMethods(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("You must specify a class in order to get the methods.");
        }
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        for (Method method : clazz.getMethods()) {
            method.setAccessible(true);
            linkedHashSet.add(method);
        }
        return linkedHashSet.toArray(new Method[0]);
    }

    public static Field[] getAllFields(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("You must specify the class that contains the fields");
        }
        LinkedHashSet<Field> linkedHashSet = new LinkedHashSet<Field>();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz2.getDeclaredFields()) {
                field.setAccessible(true);
                linkedHashSet.add(field);
            }
        }
        return linkedHashSet.toArray(new Field[linkedHashSet.size()]);
    }

    public static Constructor<?> getFirstParentConstructor(Class<?> clazz) {
        try {
            return WhiteboxImpl.getUnmockedType(clazz).getSuperclass().getDeclaredConstructors()[0];
        }
        catch (Exception exception) {
            throw new ConstructorNotFoundException("Failed to lookup constructor.", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Method findMethod(Class<T> clazz, String string, Class<?> ... classArray) {
        void var4_9;
        if (string == null && classArray == null) {
            throw new IllegalArgumentException("You must specify a method name or parameter types.");
        }
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : WhiteboxImpl.getAllMethods(clazz)) {
            if (string != null && !method.getName().equals(string)) continue;
            if (classArray != null && classArray.length > 0) {
                Class<?>[] classArray2 = method.getParameterTypes();
                if (!WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), classArray, classArray2)) continue;
            }
            linkedList.add(method);
        }
        Object var4_5 = null;
        if (linkedList.size() > 0) {
            if (linkedList.size() == 1) {
                Method method = (Method)linkedList.get(0);
            } else if (classArray.length == 0) {
                void var4_8;
                for (Method method : linkedList) {
                    if (method.getParameterTypes().length != 0) continue;
                    Method method2 = method;
                    break;
                }
                if (var4_8 == null) {
                    WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("argument parameter types", linkedList.toArray(new Method[0]));
                }
            } else {
                WhiteboxImpl.throwExceptionWhenMultipleMethodMatchesFound("argument parameter types", linkedList.toArray(new Method[0]));
            }
        }
        return var4_9;
    }

    public static boolean isProxy(Class<?> clazz) {
        return proxyFramework.isProxy(clazz);
    }

    public static <T> Class<?> getUnmockedType(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Class<Object> clazz2 = null;
        clazz2 = proxyFramework != null && proxyFramework.isProxy(clazz) ? proxyFramework.getUnproxiedType(clazz) : (Proxy.isProxyClass(clazz) ? clazz.getInterfaces()[0] : clazz);
        return clazz2;
    }

    static void throwExceptionWhenMultipleMethodMatchesFound(String string, Method[] methodArray) {
        if (methodArray == null || methodArray.length < 2) {
            throw new IllegalArgumentException("Internal error: throwExceptionWhenMultipleMethodMatchesFound needs at least two methods.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Several matching methods found, please specify the ");
        stringBuilder.append(string);
        stringBuilder.append(" so that PowerMock can determine which method you're referring to.\n");
        stringBuilder.append("Matching methods in class ").append(methodArray[0].getDeclaringClass().getName()).append(" were:\n");
        for (Method method : methodArray) {
            Class<?>[] classArray;
            stringBuilder.append(method.getReturnType().getName()).append(" ");
            stringBuilder.append(method.getName()).append("( ");
            for (Class<?> clazz : classArray = method.getParameterTypes()) {
                stringBuilder.append(clazz.getName()).append(".class ");
            }
            stringBuilder.append(")\n");
        }
        throw new TooManyMethodsFoundException(stringBuilder.toString());
    }

    static void throwExceptionWhenMultipleConstructorMatchesFound(Constructor<?>[] constructorArray) {
        if (constructorArray == null || constructorArray.length < 2) {
            throw new IllegalArgumentException("Internal error: throwExceptionWhenMultipleConstructorMatchesFound needs at least two constructors.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Several matching constructors found, please specify the argument parameter types so that PowerMock can determine which method you're referring to.\n");
        stringBuilder.append("Matching constructors in class ").append(constructorArray[0].getDeclaringClass().getName()).append(" were:\n");
        for (Constructor<?> constructor : constructorArray) {
            Class<?>[] classArray;
            stringBuilder.append(constructor.getName()).append("( ");
            for (Class<?> clazz : classArray = constructor.getParameterTypes()) {
                stringBuilder.append(clazz.getName()).append(".class ");
            }
            stringBuilder.append(")\n");
        }
        throw new TooManyConstructorsFoundException(stringBuilder.toString());
    }

    public static Method findMethodOrThrowException(Class<?> clazz, String string, Class<?> ... classArray) {
        Method method = WhiteboxImpl.findMethod(clazz, string, classArray);
        WhiteboxImpl.throwExceptionIfMethodWasNotFound(clazz, string, method, classArray);
        return method;
    }

    public static Method[] getMethods(Class<?> clazz, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("You must supply at least one method name.");
        }
        LinkedList<Method> linkedList = new LinkedList<Method>();
        Method[] methodArray = null;
        methodArray = clazz.isInterface() ? WhiteboxImpl.getAllPublicMethods(clazz) : WhiteboxImpl.getAllMethods(clazz);
        for (Method method : methodArray) {
            for (String string : stringArray) {
                if (!method.getName().equals(string)) continue;
                method.setAccessible(true);
                linkedList.add(method);
            }
        }
        Method[] methodArray2 = linkedList.toArray(new Method[0]);
        if (methodArray2.length == 0) {
            throw new MethodNotFoundException(String.format("No methods matching the name(s) %s were found in the class hierarchy of %s.", WhiteboxImpl.concatenateStrings(stringArray), WhiteboxImpl.getType(clazz)));
        }
        return methodArray2;
    }

    public static Method[] getMethods(Class<?> clazz, String string, Class<?>[] classArray, boolean bl) {
        Method[] methodArray;
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : methodArray = WhiteboxImpl.getMethods(clazz, string)) {
            Class<?>[] classArray2 = method.getParameterTypes();
            if (!WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), classArray, classArray2) && (bl || !WhiteboxImpl.checkIfParameterTypesAreSame(method.isVarArgs(), WhiteboxImpl.convertParameterTypesToPrimitive(classArray), classArray2))) continue;
            linkedList.add(method);
        }
        Method[] methodArray2 = linkedList.toArray(new Method[0]);
        if (methodArray2.length == 0) {
            throw new MethodNotFoundException(String.format("No methods matching the name(s) %s were found in the class hierarchy of %s.", WhiteboxImpl.concatenateStrings(string), WhiteboxImpl.getType(clazz)));
        }
        return linkedList.toArray(new Method[linkedList.size()]);
    }

    public static Field[] getFields(Class<?> clazz, String ... stringArray) {
        LinkedList<Field> linkedList = new LinkedList<Field>();
        for (Field field : WhiteboxImpl.getAllFields(clazz)) {
            for (String string : stringArray) {
                if (!field.getName().equals(string)) continue;
                linkedList.add(field);
            }
        }
        Field[] fieldArray = linkedList.toArray(new Field[linkedList.size()]);
        if (fieldArray.length == 0) {
            throw new FieldNotFoundException(String.format("No fields matching the name(s) %s were found in the class hierarchy of %s.", WhiteboxImpl.concatenateStrings(stringArray), WhiteboxImpl.getType(clazz)));
        }
        return fieldArray;
    }

    public static <T> T performMethodInvocation(Object object, Method method, Object ... objectArray) throws Exception {
        boolean bl = method.isAccessible();
        if (!bl) {
            method.setAccessible(true);
        }
        try {
            Object[] objectArray2;
            if (WhiteboxImpl.isPotentialVarArgsMethod(method, objectArray)) {
                Class<?>[] classArray = method.getParameterTypes();
                int n = classArray.length - 1;
                Class<?> clazz = classArray[n].getComponentType();
                Object object2 = WhiteboxImpl.createAndPopulateVarArgsArray(clazz, n, objectArray);
                Object[] objectArray3 = new Object[classArray.length];
                for (int i = 0; i < n; ++i) {
                    objectArray3[i] = objectArray[i];
                }
                objectArray3[objectArray3.length - 1] = object2;
                Object object3 = method.invoke(object, objectArray3);
                return (T)object3;
            }
            if (objectArray == null) {
                Object[] objectArray4 = new Object[1];
                objectArray2 = objectArray4;
                objectArray4[0] = objectArray;
            } else {
                objectArray2 = objectArray;
            }
            Object object4 = method.invoke(object, objectArray2);
            return (T)object4;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new MethodInvocationException(throwable);
        }
        finally {
            if (!bl) {
                method.setAccessible(false);
            }
        }
    }

    public static <T> Method[] getAllMethodExcept(Class<T> clazz, String ... stringArray) {
        Method[] methodArray;
        LinkedList<Method> linkedList = new LinkedList<Method>();
        block0: for (Method method : methodArray = WhiteboxImpl.getAllMethods(clazz)) {
            for (String string : stringArray) {
                if (method.getName().equals(string)) continue block0;
            }
            linkedList.add(method);
        }
        return linkedList.toArray(new Method[0]);
    }

    public static <T> Method[] getAllMetodsExcept(Class<T> clazz, String string, Class<?>[] classArray) {
        Method[] methodArray = WhiteboxImpl.getAllMethods(clazz);
        ArrayList<Method> arrayList = new ArrayList<Method>();
        block0: for (Method method : methodArray) {
            if (method.getName().equals(string)) {
                if (classArray == null || classArray.length <= 0) continue;
                Class<?>[] classArray2 = method.getParameterTypes();
                if (classArray2 != null && classArray2.length == classArray.length) {
                    for (int i = 0; i < classArray2.length; ++i) {
                        if (classArray2[i].isAssignableFrom(WhiteboxImpl.getUnmockedType(classArray[i]))) continue block0;
                    }
                }
            }
            arrayList.add(method);
        }
        return arrayList.toArray(new Method[0]);
    }

    public static boolean areAllMethodsStatic(Method ... methodArray) {
        for (Method method : methodArray) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            return false;
        }
        return true;
    }

    static boolean areAllArgumentsOfSameType(Object[] objectArray) {
        if (objectArray == null || objectArray.length <= 1) {
            return true;
        }
        int n = 0;
        Object object = null;
        while (object == null && n < objectArray.length) {
            object = objectArray[n++];
        }
        if (object == null) {
            return true;
        }
        Class<?> clazz = WhiteboxImpl.getType(object);
        for (int i = n; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2 == null || WhiteboxImpl.getType(object2).isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkArgumentTypesMatchParameterTypes(boolean bl, Class<?>[] classArray, Object[] objectArray) {
        if (classArray == null) {
            throw new IllegalArgumentException("parameter types cannot be null");
        }
        if (!bl && objectArray.length != classArray.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl2;
            int n;
            Object object = objectArray[i];
            if (object == null) {
                n = i >= classArray.length ? classArray.length - 1 : i;
                Class<?> clazz = classArray[n];
                if (!clazz.isPrimitive()) continue;
                return false;
            }
            if (i >= classArray.length) {
                if (WhiteboxImpl.isAssignableFrom(classArray[classArray.length - 1], WhiteboxImpl.getType(object))) continue;
                return false;
            }
            n = WhiteboxImpl.isAssignableFrom(classArray[i], WhiteboxImpl.getType(object)) ? 1 : 0;
            boolean bl3 = bl2 = classArray[i].equals(Class.class) && WhiteboxImpl.isClass(object);
            if (n != 0 || bl2) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableFrom(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5 = WhiteboxImpl.getComponentType(clazz);
        boolean bl = clazz5.isAssignableFrom(clazz4 = WhiteboxImpl.getComponentType(clazz2));
        if (!bl && PrimitiveWrapper.hasPrimitiveCounterPart(clazz4) && (clazz3 = PrimitiveWrapper.getPrimitiveFromWrapperType(clazz4)) != null) {
            bl = clazz5.isAssignableFrom(clazz3);
        }
        return bl;
    }

    private static Class<?> getComponentType(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        return clazz2;
    }

    public static Class<?> getType(Object object) {
        Class<?> clazz = null;
        if (WhiteboxImpl.isClass(object)) {
            clazz = (Class<?>)object;
        } else if (object != null) {
            clazz = object.getClass();
        }
        return clazz == null ? null : WhiteboxImpl.getUnmockedType(clazz);
    }

    public static Class<Object> getInnerClassType(Class<?> clazz, String string) throws ClassNotFoundException {
        return Class.forName(clazz.getName() + "$" + string);
    }

    public static Class<Object> getLocalClassType(Class<?> clazz, int n, String string) throws ClassNotFoundException {
        return Class.forName(clazz.getName() + "$" + n + string);
    }

    public static Class<Object> getAnonymousInnerClassType(Class<?> clazz, int n) throws ClassNotFoundException {
        return Class.forName(clazz.getName() + "$" + n);
    }

    public static Set<Field> getFieldsAnnotatedWith(Object object, Class<? extends Annotation> clazz, Class<? extends Annotation> ... classArray) {
        Class[] classArray2 = null;
        if (classArray == null || classArray.length == 0) {
            classArray2 = new Class[]{clazz};
        } else {
            classArray2 = new Class[classArray.length + 1];
            classArray2[0] = clazz;
            System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        }
        return WhiteboxImpl.getFieldsAnnotatedWith(object, classArray2);
    }

    public static Set<Field> getFieldsAnnotatedWith(Object object, Class<? extends Annotation>[] classArray) {
        return WhiteboxImpl.findAllFieldsUsingStrategy(new FieldAnnotationMatcherStrategy(classArray), object, true, WhiteboxImpl.getType(object));
    }

    public static Set<Field> getFieldsOfType(Object object, Class<?> clazz) {
        return WhiteboxImpl.findAllFieldsUsingStrategy(new AssignableFromFieldTypeMatcherStrategy(clazz), object, true, WhiteboxImpl.getType(object));
    }

    public static Set<Field> getAllInstanceFields(Object object) {
        return WhiteboxImpl.findAllFieldsUsingStrategy(new AllFieldsMatcherStrategy(), object, true, WhiteboxImpl.getType(object));
    }

    public static Set<Field> getAllStaticFields(Class<?> clazz) {
        Field[] fieldArray;
        LinkedHashSet<Field> linkedHashSet = new LinkedHashSet<Field>();
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            linkedHashSet.add(field);
        }
        return linkedHashSet;
    }

    public static boolean isClass(Object object) {
        return object instanceof Class;
    }

    public static boolean checkIfParameterTypesAreSame(boolean bl, Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray == null || classArray2 == null) {
            throw new IllegalArgumentException("parameter types cannot be null");
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = WhiteboxImpl.getType(classArray2[i]);
            if (bl && i == classArray.length - 1 && clazz.getComponentType().isAssignableFrom(classArray[i])) {
                return true;
            }
            if (clazz.isAssignableFrom(classArray[i])) continue;
            return false;
        }
        return true;
    }

    private static Field getField(String string, Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("where cannot be null");
        }
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new FieldNotFoundException("Field '" + string + "' was not found in class " + clazz.getName() + ".");
        }
        return field;
    }

    private static Field findFieldOrThrowException(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null || clazz2 == null) {
            throw new IllegalArgumentException("fieldType and where cannot be null");
        }
        Field field = null;
        for (Field field2 : clazz2.getDeclaredFields()) {
            field2.setAccessible(true);
            if (!field2.getType().equals(clazz)) continue;
            field = field2;
            break;
        }
        if (field == null) {
            throw new FieldNotFoundException("Cannot find a field of type " + clazz + "in where.");
        }
        return field;
    }

    private static void setField(Object object, Object object2, Field field) {
        field.setAccessible(true);
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Internal error: Failed to set field in method setInternalState.", illegalAccessException);
        }
    }

    private static String concatenateStrings(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1 && n != 1) {
                stringBuilder.append(" or ");
            } else if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    private static boolean isPotentialVarArgsMethod(Method method, Object[] objectArray) {
        return WhiteboxImpl.doesParameterTypesMatchForVarArgsInvocation(method.isVarArgs(), method.getParameterTypes(), objectArray);
    }

    private static boolean isPotentialVarArgsConstructor(Constructor<?> constructor, Object[] objectArray) {
        Class<?>[] classArray = constructor.getParameterTypes();
        return WhiteboxImpl.doesParameterTypesMatchForVarArgsInvocation(constructor.isVarArgs(), classArray, objectArray);
    }

    private static boolean doesParameterTypesMatchForVarArgsInvocation(boolean bl, Class<?>[] classArray, Object[] objectArray) {
        if (bl && objectArray != null && objectArray.length >= 1 && classArray != null && classArray.length >= 1) {
            Class<?> clazz = classArray[classArray.length - 1].getComponentType();
            Object object = objectArray[objectArray.length - 1];
            if (object != null) {
                Class<?> clazz2 = WhiteboxImpl.getTypeAsPrimitiveIfWrapped(object);
                Class<?> clazz3 = WhiteboxImpl.getTypeAsPrimitiveIfWrapped(clazz);
                bl = clazz3.isAssignableFrom(clazz2);
            }
        }
        return bl && WhiteboxImpl.checkArgumentTypesMatchParameterTypes(bl, classArray, objectArray);
    }

    private static Class<?> getTypeAsPrimitiveIfWrapped(Object object) {
        if (object != null) {
            Class<?> clazz = WhiteboxImpl.getType(object);
            Class<?> clazz2 = PrimitiveWrapper.hasPrimitiveCounterPart(clazz) ? PrimitiveWrapper.getPrimitiveFromWrapperType(clazz) : clazz;
            return clazz2;
        }
        return null;
    }

    public static void setInternalStateFromContext(Object object, Object object2, Object[] objectArray) {
        WhiteboxImpl.setInternalStateFromContext(object, object2, FieldMatchingStrategy.MATCHING);
        if (objectArray != null && objectArray.length > 0) {
            for (Object object3 : objectArray) {
                WhiteboxImpl.setInternalStateFromContext(object, object3, FieldMatchingStrategy.MATCHING);
            }
        }
    }

    public static void setInternalStateFromContext(Object object, Object object2, FieldMatchingStrategy fieldMatchingStrategy) {
        if (WhiteboxImpl.isClass(object2)) {
            WhiteboxImpl.copyState(object, WhiteboxImpl.getType(object2), fieldMatchingStrategy);
        } else {
            WhiteboxImpl.copyState(object, object2, fieldMatchingStrategy);
        }
    }

    public static void setInternalStateFromContext(Object object, Class<?> clazz, Class<?>[] classArray) {
        WhiteboxImpl.setInternalStateFromContext(object, clazz, FieldMatchingStrategy.MATCHING);
        if (classArray != null && classArray.length > 0) {
            for (Class<?> clazz2 : classArray) {
                WhiteboxImpl.setInternalStateFromContext(object, clazz2, FieldMatchingStrategy.MATCHING);
            }
        }
    }

    static void copyState(Object clazz, Object object, FieldMatchingStrategy fieldMatchingStrategy) {
        if (clazz == null) {
            throw new IllegalArgumentException("object to set state cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (fieldMatchingStrategy == null) {
            throw new IllegalArgumentException("strategy cannot be null");
        }
        Set<Field> set = WhiteboxImpl.isClass(object) ? WhiteboxImpl.getAllStaticFields(WhiteboxImpl.getType(object)) : WhiteboxImpl.getAllInstanceFields(object);
        for (Field field : set) {
            try {
                boolean bl = Modifier.isStatic(field.getModifiers());
                WhiteboxImpl.setInternalState(bl ? WhiteboxImpl.getType(clazz) : clazz, field.getType(), field.get(object));
            }
            catch (FieldNotFoundException fieldNotFoundException) {
                if (fieldMatchingStrategy != FieldMatchingStrategy.STRICT) continue;
                throw fieldNotFoundException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Internal Error: Failed to get the field value in method setInternalStateFromContext.", illegalAccessException);
            }
        }
    }

    private static void assertObjectInGetInternalStateIsNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The object containing the field cannot be null");
        }
    }

    private static Class<?>[] convertParameterTypesToPrimitive(Class<?>[] classArray) {
        Class[] classArray2 = new Class[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = PrimitiveWrapper.getPrimitiveFromWrapperType(classArray[i]);
            classArray2[i] = clazz == null ? classArray[i] : clazz;
        }
        return classArray2;
    }
}

