/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocationcontrol;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.internal.MockHandler;
import org.mockito.internal.MockitoInvocationHandler;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.creation.MethodInterceptorFilter;
import org.mockito.internal.debugging.Localized;
import org.mockito.internal.exceptions.base.StackTraceFilter;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.realmethod.FilteredCGLIBProxyRealMethod;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.matchers.MatchersPrinter;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.verification.VerificationDataImpl;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.internal.invocationcontrol.InvocationControlAssertionError;
import org.powermock.api.mockito.internal.verification.StaticMockAwareVerificationMode;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.core.MockGateway;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.WhiteboxImpl;

public class MockitoMethodInvocationControl
implements MethodInvocationControl {
    private final MethodInterceptorFilter methodInterceptorFilter;
    private final Set<Method> mockedMethods;
    private final Object delegator;
    private final Object mockInstance;

    public MockitoMethodInvocationControl(MethodInterceptorFilter methodInterceptorFilter, Object object, Method ... methodArray) {
        this(methodInterceptorFilter, null, object, methodArray);
    }

    public MockitoMethodInvocationControl(MethodInterceptorFilter methodInterceptorFilter, Object object, Object object2, Method ... methodArray) {
        if (methodInterceptorFilter == null) {
            throw new IllegalArgumentException("Invocation Handler cannot be null.");
        }
        this.mockedMethods = this.toSet(methodArray);
        this.mockInstance = object2;
        this.delegator = object;
        this.methodInterceptorFilter = methodInterceptorFilter;
    }

    @Override
    public boolean isMocked(Method method) {
        return this.mockedMethods == null || this.mockedMethods != null && this.mockedMethods.contains(method);
    }

    private boolean isInVerificationMode() {
        return this.getVerificationMode() != null;
    }

    private VerificationMode getVerificationMode() {
        try {
            MockingProgress mockingProgress = (MockingProgress)Whitebox.invokeMethod(ThreadSafeMockingProgress.class, "threadSafely", new Object[0]);
            return this.getVerificationModeFromMockProgress(mockingProgress);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private VerificationMode getVerificationModeFromMockProgress(MockingProgress mockingProgress) {
        if (mockingProgress == null) {
            return null;
        }
        if (mockingProgress instanceof ThreadSafeMockingProgress) {
            ThreadLocal threadLocal = Whitebox.getInternalState((Object)mockingProgress, ThreadLocal.class);
            return this.getVerificationModeFromMockProgress((MockingProgress)threadLocal.get());
        }
        Localized localized = Whitebox.getInternalState((Object)mockingProgress, Localized.class);
        return localized == null ? null : (VerificationMode)localized.getObject();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        int n = method.getModifiers();
        if (this.hasDelegator() && !Modifier.isPrivate(n) && !Modifier.isFinal(n) && !Modifier.isStatic(n) && this.hasBeenCaughtByMockitoProxy()) {
            object2 = MockGateway.PROCEED;
        } else {
            boolean bl = this.isInVerificationMode();
            if (WhiteboxImpl.isClass(object) && bl) {
                this.handleStaticVerification((Class)object);
            }
            if ((object2 = this.performIntercept(this.methodInterceptorFilter, object, method, objectArray)) == null) {
                return MockGateway.SUPPRESS;
            }
        }
        return object2;
    }

    private void handleStaticVerification(Class<?> clazz) {
        VerificationMode verificationMode = this.getVerificationMode();
        if (verificationMode instanceof StaticMockAwareVerificationMode) {
            ((StaticMockAwareVerificationMode)verificationMode).setClassMock(clazz);
        }
    }

    private boolean hasBeenCaughtByMockitoProxy() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceFilter stackTraceFilter = new StackTraceFilter();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (!stackTraceFilter.isBad(stackTraceElement)) continue;
            return true;
        }
        return false;
    }

    private Object performIntercept(MethodInterceptorFilter methodInterceptorFilter, final Object object, final Method method, Object[] objectArray) throws Throwable {
        MockitoInvocationHandler mockitoInvocationHandler = methodInterceptorFilter.getHandler();
        FilteredCGLIBProxyRealMethod filteredCGLIBProxyRealMethod = new FilteredCGLIBProxyRealMethod(new RealMethod(){
            private static final long serialVersionUID = 4564320968038564170L;

            public Object invoke(Object object2, Object[] objectArray) throws Throwable {
                boolean bl;
                Class<?> clazz = Whitebox.getType(object);
                boolean bl2 = bl = clazz.getName().startsWith("java.") && Modifier.isFinal(clazz.getModifiers());
                if (!bl) {
                    MockRepository.putAdditionalState("DontMockNextCall", true);
                }
                try {
                    return method.invoke(object2, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    SafeExceptionRethrower.safeRethrow(invocationTargetException.getCause());
                    return null;
                }
            }
        });
        Invocation invocation = new Invocation(object, (MockitoMethod)new DelegatingMethod(method), objectArray, SequenceNumber.next(), (RealMethod)filteredCGLIBProxyRealMethod){
            private static final long serialVersionUID = -3679957412502758558L;

            protected String toString(List<Matcher> list, PrintSettings printSettings) {
                MatchersPrinter matchersPrinter = new MatchersPrinter();
                String string = Whitebox.getType(this.getMock()).getName() + "." + this.getMethodName();
                String string2 = string + matchersPrinter.getArgumentsLine(list, printSettings);
                if (printSettings.isMultiline() || !list.isEmpty() && string2.length() > (Integer)Whitebox.getInternalState(Invocation.class, "MAX_LINE_LENGTH")) {
                    return string + matchersPrinter.getArgumentsBlock(list, printSettings);
                }
                return string2;
            }
        };
        try {
            return mockitoInvocationHandler.handle(invocation);
        }
        catch (NotAMockException notAMockException) {
            if (invocation.getMock().getClass().getName().startsWith("java.") && MockRepository.getInstanceMethodInvocationControl(invocation.getMock()) != null) {
                return invocation.callRealMethod();
            }
            throw notAMockException;
        }
        catch (MockitoAssertionError mockitoAssertionError) {
            InvocationControlAssertionError.updateErrorMessageForMethodInvocation((AssertionError)((Object)mockitoAssertionError));
            throw mockitoAssertionError;
        }
    }

    @Override
    public Object replay(Object ... objectArray) {
        throw new IllegalStateException("Internal error: No such thing as replay exists in Mockito.");
    }

    @Override
    public Object reset(Object ... objectArray) {
        throw new IllegalStateException("Internal error: No such thing as reset exists in Mockito.");
    }

    @Override
    public Object verify(Object ... objectArray) {
        if (objectArray == null || objectArray.length != 1) {
            throw new IllegalArgumentException("Must supply one mock to the verify method.");
        }
        return Mockito.verify((Object)objectArray[0]);
    }

    public void verifyNoMoreInteractions() {
        try {
            MockitoInvocationHandler mockitoInvocationHandler = this.methodInterceptorFilter.getHandler();
            if (!(mockitoInvocationHandler instanceof MockHandler)) {
                throw new RuntimeException("Cannot perform verifyNoMoreInteractions because of unknown mockhandler type " + mockitoInvocationHandler.getClass());
            }
            InvocationContainer invocationContainer = ((MockHandler)mockitoInvocationHandler).getInvocationContainer();
            VerificationDataImpl verificationDataImpl = new VerificationDataImpl(invocationContainer, null);
            VerificationModeFactory.noMoreInteractions().verify((VerificationData)verificationDataImpl);
        }
        catch (MockitoAssertionError mockitoAssertionError) {
            InvocationControlAssertionError.updateErrorMessageForVerifyNoMoreInteractions((AssertionError)((Object)mockitoAssertionError));
            throw mockitoAssertionError;
        }
    }

    private Set<Method> toSet(Method ... methodArray) {
        return methodArray == null ? null : new HashSet<Method>(Arrays.asList(methodArray));
    }

    private boolean hasDelegator() {
        return this.delegator != null;
    }

    public MethodInterceptorFilter getInvocationHandler() {
        return this.methodInterceptorFilter;
    }
}

