/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocationcontrol;

import java.io.Serializable;
import java.util.regex.Matcher;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.Whitebox;

public class InvocationControlAssertionError {
    private static final String AT = "at";
    private static final String ERROR_LOCATION_MARKER = "->";
    private static final String COLON_NEWLINE = ":\n";
    private static final String HERE_TEXT = "here:\n";
    private static final String UNDESIRED_INVOCATION_TEXT = " Undesired invocation:";

    public static void updateErrorMessageForVerifyNoMoreInteractions(AssertionError assertionError) {
        int n;
        Serializable serializable;
        String string = null;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            serializable = stackTraceElementArray[i];
            if (!((StackTraceElement)serializable).getClassName().equals(PowerMockito.class.getName()) || !((StackTraceElement)serializable).getMethodName().equals("verifyNoMoreInteractions")) continue;
            n = stackTraceElementArray[i + 1].getClassName().equals(PowerMockito.class.getName()) && stackTraceElementArray[i + 1].getMethodName().equals("verifyZeroInteractions") ? i + 2 : i + 1;
            string = stackTraceElementArray[n].toString();
        }
        if (string == null) {
            return;
        }
        String string2 = ((Throwable)((Object)assertionError)).getMessage();
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append(string2);
        n = string2.indexOf(AT);
        int n2 = n + AT.length() + 1;
        int n3 = string2.indexOf(10, n + AT.length());
        ((StringBuilder)serializable).replace(n2, n3, string);
        ((StringBuilder)serializable).delete(((StringBuilder)serializable).indexOf("\n", n3 + 1), ((StringBuilder)serializable).lastIndexOf("\n"));
        Whitebox.setInternalState((Object)assertionError, (Object)((StringBuilder)serializable).toString(), new Object[0]);
    }

    public static void updateErrorMessageForMethodInvocation(AssertionError assertionError) {
        Whitebox.setInternalState((Object)assertionError, (Object)("\n" + InvocationControlAssertionError.changeMessageContent(((Throwable)((Object)assertionError)).getMessage())), new Object[0]);
    }

    public static void throwAssertionErrorForNewSubstitutionFailure(AssertionError assertionError, Class<?> clazz) {
        String string = InvocationSubstitute.class.getSimpleName();
        String string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
        String string3 = ((Throwable)((Object)assertionError)).getMessage();
        String string4 = InvocationSubstitute.class.getDeclaredMethods()[0].getName();
        string3 = string3.replaceAll(string2 + "." + string4, Matcher.quoteReplacement(clazz.getName()));
        string3 = string3.replaceAll("method", "constructor");
        throw new AssertionError((Object)InvocationControlAssertionError.changeMessageContent(string3));
    }

    private static String changeMessageContent(String string) {
        StringBuilder stringBuilder = InvocationControlAssertionError.removeFailureLocations(string);
        InvocationControlAssertionError.removeText(stringBuilder, UNDESIRED_INVOCATION_TEXT);
        InvocationControlAssertionError.removeAndReplaceText(stringBuilder, HERE_TEXT, ' ');
        InvocationControlAssertionError.removeAndReplaceText(stringBuilder, COLON_NEWLINE, ' ');
        String string2 = stringBuilder.toString().trim();
        return string2;
    }

    private static StringBuilder removeFailureLocations(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        int n = stringBuilder.indexOf(ERROR_LOCATION_MARKER);
        while (n > 0) {
            int n2 = stringBuilder.indexOf("\n", n);
            stringBuilder.delete(n, n2 < 0 ? stringBuilder.length() : n2 + 1);
            n = stringBuilder.indexOf(ERROR_LOCATION_MARKER);
        }
        return stringBuilder;
    }

    private static void removeAndReplaceText(StringBuilder stringBuilder, String string, char c) {
        int n = stringBuilder.indexOf(string);
        int n2 = 0;
        boolean bl = true;
        while (n > 0) {
            n2 = n;
            stringBuilder.delete(n, n + string.length());
            n = stringBuilder.indexOf(string);
            if (InvocationControlAssertionError.isLastFinding(n) && !bl) {
                stringBuilder.replace(stringBuilder.length(), stringBuilder.length(), ".");
                continue;
            }
            stringBuilder.replace(n2, n2 + 1, String.valueOf(stringBuilder.charAt(n2)).toLowerCase());
            stringBuilder.insert(n2, String.valueOf(c));
            ++n;
            bl = false;
        }
    }

    private static boolean isLastFinding(int n) {
        return n < 0;
    }

    private static void removeText(StringBuilder stringBuilder, String string) {
        int n = stringBuilder.indexOf(string);
        while (n > 0) {
            stringBuilder.delete(n, n + string.length());
            n = stringBuilder.indexOf(string);
        }
    }
}

