/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import org.mockito.stubbing.OngoingStubbing;
import org.powermock.api.mockito.expectation.ConstructorExpectationSetup;
import org.powermock.api.mockito.expectation.WithExpectedArguments;
import org.powermock.api.mockito.internal.invocationcontrol.MockitoNewInvocationControl;
import org.powermock.api.mockito.internal.mockcreation.MockCreator;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.internal.WhiteboxImpl;
import org.powermock.tests.utils.ArrayMerger;
import org.powermock.tests.utils.impl.ArrayMergerImpl;

public class DefaultConstructorExpectationSetup<T>
implements ConstructorExpectationSetup<T> {
    private Class<?>[] parameterTypes = null;
    private final Class<T> mockType;
    private final ArrayMerger arrayMerger;

    public DefaultConstructorExpectationSetup(Class<T> clazz) {
        this.mockType = clazz;
        this.arrayMerger = new ArrayMergerImpl();
    }

    public void setParameterTypes(Class<?>[] classArray) {
        this.parameterTypes = classArray;
    }

    @Override
    public OngoingStubbing<T> withArguments(Object object, Object ... objectArray) throws Exception {
        return DefaultConstructorExpectationSetup.createNewSubsituteMock(this.mockType, this.parameterTypes, this.arrayMerger.mergeArrays(Object.class, {object}, objectArray));
    }

    @Override
    public OngoingStubbing<T> withNoArguments() throws Exception {
        return DefaultConstructorExpectationSetup.createNewSubsituteMock(this.mockType, this.parameterTypes, new Object[0]);
    }

    @Override
    public WithExpectedArguments<T> withParameterTypes(Class<?> clazz, Class<?> ... classArray) {
        this.parameterTypes = this.arrayMerger.mergeArrays(Class.class, {clazz}, classArray);
        return this;
    }

    private static <T> OngoingStubbing<T> createNewSubsituteMock(Class<T> clazz, Class<?>[] classArray, Object ... objectArray) throws Exception {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Class<?> clazz2 = WhiteboxImpl.getUnmockedType(clazz);
        if (classArray == null) {
            WhiteboxImpl.findUniqueConstructorOrThrowException(clazz, objectArray);
        } else {
            WhiteboxImpl.getConstructor(clazz2, classArray);
        }
        NewInvocationControl<?> newInvocationControl = MockRepository.getNewInstanceControl(clazz2);
        if (newInvocationControl == null) {
            InvocationSubstitute invocationSubstitute = MockCreator.mock(InvocationSubstitute.class, false, false, null, null, null);
            newInvocationControl = new MockitoNewInvocationControl(invocationSubstitute);
            MockRepository.putNewInstanceControl(clazz, newInvocationControl);
            MockRepository.addObjectsToAutomaticallyReplayAndVerify(WhiteboxImpl.getUnmockedType(clazz));
        }
        return (OngoingStubbing)newInvocationControl.expectSubstitutionLogic(objectArray);
    }
}

