/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.io.Serializable;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.Factory;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.internal.InvocationNotifierHandler;
import org.mockito.internal.MockHandler;
import org.mockito.internal.MockHandlerInterface;
import org.mockito.internal.creation.MethodInterceptorFilter;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.creation.jmock.ClassImposterizer;
import org.mockito.internal.util.ArrayUtils;
import org.mockito.internal.util.MockCreationValidator;
import org.mockito.internal.util.MockName;
import org.mockito.internal.util.reflection.LenientCopyTool;

public class MockUtil {
    private final MockCreationValidator creationValidator;

    public MockUtil(MockCreationValidator mockCreationValidator) {
        this.creationValidator = mockCreationValidator;
    }

    public MockUtil() {
        this(new MockCreationValidator());
    }

    public <T> T createMock(Class<T> clazz, MockSettingsImpl mockSettingsImpl) {
        Class<?>[] classArray;
        this.creationValidator.validateType(clazz);
        this.creationValidator.validateExtraInterfaces(clazz, mockSettingsImpl.getExtraInterfaces());
        this.creationValidator.validateMockedType(clazz, mockSettingsImpl.getSpiedInstance());
        mockSettingsImpl.initiateMockName(clazz);
        MethodInterceptorFilter methodInterceptorFilter = this.newMethodInterceptorFilter(mockSettingsImpl);
        Class<?>[] classArray2 = mockSettingsImpl.getExtraInterfaces();
        if (mockSettingsImpl.isSerializable()) {
            Class[] classArray3;
            if (classArray2 == null) {
                Class[] classArray4 = new Class[1];
                classArray3 = classArray4;
                classArray4[0] = Serializable.class;
            } else {
                classArray3 = new ArrayUtils().concat(classArray2, Serializable.class);
            }
            classArray = classArray3;
        } else {
            classArray = classArray2 == null ? new Class[]{} : classArray2;
        }
        Object object = mockSettingsImpl.getSpiedInstance();
        T t = ClassImposterizer.INSTANCE.imposterise(methodInterceptorFilter, clazz, classArray);
        if (object != null) {
            new LenientCopyTool().copyToMock(object, t);
        }
        return t;
    }

    public <T> void resetMock(T t) {
        MockHandlerInterface<T> mockHandlerInterface = this.getMockHandler(t);
        MethodInterceptorFilter methodInterceptorFilter = this.newMethodInterceptorFilter(mockHandlerInterface.getMockSettings());
        ((Factory)t).setCallback(0, methodInterceptorFilter);
    }

    private <T> MethodInterceptorFilter newMethodInterceptorFilter(MockSettingsImpl mockSettingsImpl) {
        MockHandler mockHandler = new MockHandler(mockSettingsImpl);
        InvocationNotifierHandler invocationNotifierHandler = new InvocationNotifierHandler(mockHandler, mockSettingsImpl);
        return new MethodInterceptorFilter(invocationNotifierHandler, mockSettingsImpl);
    }

    public <T> MockHandlerInterface<T> getMockHandler(T t) {
        if (t == null) {
            throw new NotAMockException("Argument should be a mock, but is null!");
        }
        if (this.isMockitoMock(t)) {
            return (MockHandlerInterface)((Object)this.getInterceptor(t).getHandler());
        }
        throw new NotAMockException("Argument should be a mock, but is: " + t.getClass());
    }

    private <T> boolean isMockitoMock(T t) {
        return this.getInterceptor(t) != null;
    }

    public boolean isMock(Object object) {
        return object != null && this.isMockitoMock(object);
    }

    private <T> MethodInterceptorFilter getInterceptor(T t) {
        if (!(t instanceof Factory)) {
            return null;
        }
        Factory factory = (Factory)t;
        Callback callback = factory.getCallback(0);
        if (callback instanceof MethodInterceptorFilter) {
            return (MethodInterceptorFilter)callback;
        }
        return null;
    }

    public MockName getMockName(Object object) {
        return this.getMockHandler(object).getMockSettings().getMockName();
    }
}

