/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.MethodProxy;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.creation.jmock.ClassImposterizer;
import org.mockito.internal.debugging.Location;
import org.mockito.internal.stubbing.defaultanswers.ReturnsMoreEmptyValues;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ReturnsSmartNulls
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 7618312406617949441L;
    private final Answer<Object> delegate = new ReturnsMoreEmptyValues();

    @Override
    public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
        Object object = this.delegate.answer(invocationOnMock);
        if (object != null) {
            return object;
        }
        Class<?> clazz = invocationOnMock.getMethod().getReturnType();
        if (ClassImposterizer.INSTANCE.canImposterise(clazz)) {
            return ClassImposterizer.INSTANCE.imposterise(new ThrowingInterceptor(invocationOnMock), clazz, new Class[0]);
        }
        return null;
    }

    private final class ThrowingInterceptor
    implements MethodInterceptor {
        private final InvocationOnMock invocation;
        private final Location location = new Location();

        private ThrowingInterceptor(InvocationOnMock invocationOnMock) {
            this.invocation = invocationOnMock;
        }

        @Override
        public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
            if (new ObjectMethodsGuru().isToString(method)) {
                return "SmartNull returned by this unstubbed method call on a mock:\n" + this.invocation.toString();
            }
            new Reporter().smartNullPointerException(this.invocation.toString(), this.location);
            return null;
        }
    }
}

