/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.jmock;

import java.util.ArrayList;
import java.util.List;

public class SearchingClassLoader
extends ClassLoader {
    private final ClassLoader nextToSearch;

    public SearchingClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        super(classLoader);
        this.nextToSearch = classLoader2;
    }

    public static ClassLoader combineLoadersOf(Class<?> ... classArray) {
        return SearchingClassLoader.combineLoadersOf(classArray[0], classArray);
    }

    private static ClassLoader combineLoadersOf(Class<?> clazz, Class<?> ... classArray) {
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        SearchingClassLoader.addIfNewElement(arrayList, clazz.getClassLoader());
        for (Class<?> clazz2 : classArray) {
            SearchingClassLoader.addIfNewElement(arrayList, clazz2.getClassLoader());
        }
        SearchingClassLoader.addIfNewElement(arrayList, SearchingClassLoader.class.getClassLoader());
        SearchingClassLoader.addIfNewElement(arrayList, Thread.currentThread().getContextClassLoader());
        return SearchingClassLoader.combine(arrayList);
    }

    private static ClassLoader combine(List<ClassLoader> list) {
        ClassLoader classLoader = list.get(list.size() - 1);
        for (int i = list.size() - 2; i >= 0; --i) {
            classLoader = new SearchingClassLoader(list.get(i), classLoader);
        }
        return classLoader;
    }

    private static void addIfNewElement(List<ClassLoader> list, ClassLoader classLoader) {
        if (classLoader != null && !list.contains(classLoader)) {
            list.add(classLoader);
        }
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        if (this.nextToSearch != null) {
            return this.nextToSearch.loadClass(string);
        }
        return super.findClass(string);
    }
}

