/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.jmock;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.mockito.cglib.core.CodeGenerationException;
import org.mockito.cglib.core.NamingPolicy;
import org.mockito.cglib.core.Predicate;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.CallbackFilter;
import org.mockito.cglib.proxy.Enhancer;
import org.mockito.cglib.proxy.Factory;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.NoOp;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.cglib.MockitoNamingPolicy;
import org.mockito.internal.creation.jmock.SearchingClassLoader;
import org.mockito.internal.creation.jmock.SerializableNoOp;
import org.objenesis.ObjenesisStd;

public class ClassImposterizer {
    public static final ClassImposterizer INSTANCE = new ClassImposterizer();
    private ObjenesisStd objenesis = new ObjenesisStd();
    private static final NamingPolicy NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES = new MockitoNamingPolicy(){

        @Override
        public String getClassName(String string, String string2, Object object, Predicate predicate) {
            return "codegen." + super.getClassName(string, string2, object, predicate);
        }
    };
    private static final CallbackFilter IGNORE_BRIDGE_METHODS = new CallbackFilter(){

        @Override
        public int accept(Method method) {
            return method.isBridge() ? 1 : 0;
        }
    };

    private ClassImposterizer() {
    }

    public boolean canImposterise(Class<?> clazz) {
        return !clazz.isPrimitive() && !Modifier.isFinal(clazz.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T imposterise(MethodInterceptor methodInterceptor, Class<T> clazz, Class<?> ... classArray) {
        try {
            this.setConstructorsAccessible(clazz, true);
            Class<?> clazz2 = this.createProxyClass(clazz, classArray);
            T t = clazz.cast(this.createProxy(clazz2, methodInterceptor));
            return t;
        }
        finally {
            this.setConstructorsAccessible(clazz, false);
        }
    }

    private void setConstructorsAccessible(Class<?> clazz, boolean bl) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            constructor.setAccessible(bl);
        }
    }

    private Class<?> createProxyClass(Class<?> clazz, Class<?> ... classArray) {
        if (clazz == Object.class) {
            clazz = ClassWithSuperclassToWorkAroundCglibBug.class;
        }
        Enhancer enhancer = new Enhancer(){

            @Override
            protected void filterConstructors(Class clazz, List list) {
            }
        };
        enhancer.setClassLoader(SearchingClassLoader.combineLoadersOf(clazz));
        enhancer.setUseFactory(true);
        if (clazz.isInterface()) {
            enhancer.setSuperclass(Object.class);
            enhancer.setInterfaces(this.prepend(clazz, classArray));
        } else {
            enhancer.setSuperclass(clazz);
            enhancer.setInterfaces(classArray);
        }
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        enhancer.setCallbackFilter(IGNORE_BRIDGE_METHODS);
        if (clazz.getSigners() != null) {
            enhancer.setNamingPolicy(NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES);
        } else {
            enhancer.setNamingPolicy(MockitoNamingPolicy.INSTANCE);
        }
        try {
            return enhancer.createClass();
        }
        catch (CodeGenerationException codeGenerationException) {
            if (Modifier.isPrivate(clazz.getModifiers())) {
                throw new MockitoException("\nMockito cannot mock this class: " + clazz + ".\n" + "Most likely it is a private class that is not visible by Mockito");
            }
            throw new MockitoException("\nMockito cannot mock this class: " + clazz + "\n" + "Mockito can only mock visible & non-final classes." + "\n" + "If you're not sure why you're getting this error, please report to the mailing list.", codeGenerationException);
        }
    }

    private Object createProxy(Class<?> clazz, MethodInterceptor methodInterceptor) {
        Factory factory = (Factory)this.objenesis.newInstance(clazz);
        factory.setCallbacks(new Callback[]{methodInterceptor, SerializableNoOp.SERIALIZABLE_INSTANCE});
        return factory;
    }

    private Class<?>[] prepend(Class<?> clazz, Class<?> ... classArray) {
        Class[] classArray2 = new Class[classArray.length + 1];
        classArray2[0] = clazz;
        System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        return classArray2;
    }

    public static class ClassWithSuperclassToWorkAroundCglibBug {
    }
}

