/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.MethodProxy;
import org.mockito.internal.MockitoInvocationHandler;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.creation.DelegatingMockitoMethodProxy;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.creation.MockitoMethodProxy;
import org.mockito.internal.creation.SerializableMockitoMethodProxy;
import org.mockito.internal.creation.cglib.CGLIBHacker;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.invocation.realmethod.FilteredCGLIBProxyRealMethod;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.util.ObjectMethodsGuru;

public class MethodInterceptorFilter
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 6182795666612683784L;
    private final MockitoInvocationHandler handler;
    CGLIBHacker cglibHacker = new CGLIBHacker();
    ObjectMethodsGuru objectMethodsGuru = new ObjectMethodsGuru();
    private final MockSettingsImpl mockSettings;

    public MethodInterceptorFilter(MockitoInvocationHandler mockitoInvocationHandler, MockSettingsImpl mockSettingsImpl) {
        this.handler = mockitoInvocationHandler;
        this.mockSettings = mockSettingsImpl;
    }

    @Override
    public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
        if (this.objectMethodsGuru.isEqualsMethod(method)) {
            return object == objectArray[0];
        }
        if (this.objectMethodsGuru.isHashCodeMethod(method)) {
            return this.hashCodeForMock(object);
        }
        MockitoMethodProxy mockitoMethodProxy = this.createMockitoMethodProxy(methodProxy);
        this.cglibHacker.setMockitoNamingPolicy(mockitoMethodProxy);
        MockitoMethod mockitoMethod = this.createMockitoMethod(method);
        FilteredCGLIBProxyRealMethod filteredCGLIBProxyRealMethod = new FilteredCGLIBProxyRealMethod(mockitoMethodProxy);
        Invocation invocation = new Invocation(object, mockitoMethod, objectArray, SequenceNumber.next(), filteredCGLIBProxyRealMethod);
        return this.handler.handle(invocation);
    }

    public MockitoInvocationHandler getHandler() {
        return this.handler;
    }

    private int hashCodeForMock(Object object) {
        return System.identityHashCode(object);
    }

    public MockitoMethodProxy createMockitoMethodProxy(MethodProxy methodProxy) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMockitoMethodProxy(methodProxy);
        }
        return new DelegatingMockitoMethodProxy(methodProxy);
    }

    public MockitoMethod createMockitoMethod(Method method) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMethod(method);
        }
        return new DelegatingMethod(method);
    }
}

