/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.reflection.FieldSetter;
import org.mockito.internal.util.reflection.GenericMaster;

public class DefaultAnnotationEngine
implements AnnotationEngine {
    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        if (annotation instanceof Mock) {
            return this.processAnnotationOn((Mock)annotation, field);
        }
        if (annotation instanceof MockitoAnnotations.Mock) {
            return this.processAnnotationOn((MockitoAnnotations.Mock)annotation, field);
        }
        if (annotation instanceof Captor) {
            return this.processAnnotationOn((Captor)annotation, field);
        }
        return null;
    }

    private Object processAnnotationOn(Mock mock, Field field) {
        MockSettings mockSettings = Mockito.withSettings();
        if (mock.extraInterfaces().length > 0) {
            mockSettings.extraInterfaces(mock.extraInterfaces());
        }
        if ("".equals(mock.name())) {
            mockSettings.name(field.getName());
        } else {
            mockSettings.name(mock.name());
        }
        mockSettings.defaultAnswer(mock.answer().get());
        return Mockito.mock(field.getType(), mockSettings);
    }

    private Object processAnnotationOn(MockitoAnnotations.Mock mock, Field field) {
        return Mockito.mock(field.getType(), field.getName());
    }

    private Object processAnnotationOn(Captor captor, Field field) {
        Class<?> clazz = field.getType();
        if (!ArgumentCaptor.class.isAssignableFrom(clazz)) {
            throw new MockitoException("@Captor field must be of the type ArgumentCaptor.\nField: '" + field.getName() + "' has wrong type\n" + "For info how to use @Captor annotations see examples in javadoc for MockitoAnnotations class.");
        }
        Class clazz2 = new GenericMaster().getGenericType(field);
        return ArgumentCaptor.forClass(clazz2);
    }

    @Override
    public void process(Class<?> clazz, Object object) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            boolean bl = false;
            for (Annotation annotation : field.getAnnotations()) {
                Object object2 = this.createMockFor(annotation, field);
                if (object2 == null) continue;
                this.throwIfAlreadyAssigned(field, bl);
                bl = true;
                try {
                    new FieldSetter(object, field).set(object2);
                }
                catch (Exception exception) {
                    throw new MockitoException("Problems setting field " + field.getName() + " annotated with " + annotation, exception);
                }
            }
        }
    }

    void throwIfAlreadyAssigned(Field field, boolean bl) {
        if (bl) {
            new Reporter().moreThanOneAnnotationNotAllowed(field.getName());
        }
    }
}

