/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.exceptions;

import java.lang.reflect.Field;
import java.util.List;
import org.mockito.exceptions.Discrepancy;
import org.mockito.exceptions.Pluralizer;
import org.mockito.exceptions.PrintableInvocation;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.exceptions.misusing.FriendlyReminderException;
import org.mockito.exceptions.misusing.InvalidUseOfMatchersException;
import org.mockito.exceptions.misusing.MissingMethodInvocationException;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.exceptions.misusing.NullInsteadOfMockException;
import org.mockito.exceptions.misusing.UnfinishedStubbingException;
import org.mockito.exceptions.misusing.UnfinishedVerificationException;
import org.mockito.exceptions.misusing.WrongTypeOfReturnValue;
import org.mockito.exceptions.verification.ArgumentsAreDifferent;
import org.mockito.exceptions.verification.NeverWantedButInvoked;
import org.mockito.exceptions.verification.NoInteractionsWanted;
import org.mockito.exceptions.verification.SmartNullPointerException;
import org.mockito.exceptions.verification.TooLittleActualInvocations;
import org.mockito.exceptions.verification.TooManyActualInvocations;
import org.mockito.exceptions.verification.VerificationInOrderFailure;
import org.mockito.exceptions.verification.WantedButNotInvoked;
import org.mockito.exceptions.verification.junit.JUnitTool;
import org.mockito.internal.debugging.Location;
import org.mockito.internal.exceptions.VerificationAwareInvocation;
import org.mockito.internal.exceptions.util.ScenarioPrinter;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.StringJoiner;
import org.mockito.listeners.InvocationListener;

public class Reporter {
    public void checkedExceptionInvalid(Throwable throwable) {
        throw new MockitoException(StringJoiner.join("Checked exception is invalid for this method!", "Invalid: " + throwable));
    }

    public void cannotStubWithNullThrowable() {
        throw new MockitoException(StringJoiner.join("Cannot stub with null throwable!"));
    }

    public void unfinishedStubbing(Location location) {
        throw new UnfinishedStubbingException(StringJoiner.join("Unfinished stubbing detected here:", location, "", "E.g. thenReturn() may be missing.", "Examples of correct stubbing:", "    when(mock.isOk()).thenReturn(true);", "    when(mock.isOk()).thenThrow(exception);", "    doThrow(exception).when(mock).someVoidMethod();", "Hints:", " 1. missing thenReturn()", " 2. you are trying to stub a final method, you naughty developer!", ""));
    }

    public void incorrectUseOfApi() {
        throw new MockitoException(StringJoiner.join("Incorrect use of API detected here:", new Location(), "", "You probably stored a reference to OngoingStubbing returned by when() and called stubbing methods like thenReturn() on this reference more than once.", "Examples of correct usage:", "    when(mock.isOk()).thenReturn(true).thenReturn(false).thenThrow(exception);", "    when(mock.isOk()).thenReturn(true, false).thenThrow(exception);", ""));
    }

    public void missingMethodInvocation() {
        throw new MissingMethodInvocationException(StringJoiner.join("when() requires an argument which has to be 'a method call on a mock'.", "For example:", "    when(mock.getArticles()).thenReturn(articles);", "", "Also, this error might show up because:", "1. you stub either of: final/private/equals()/hashCode() methods.", "   Those methods *cannot* be stubbed/verified.", "2. inside when() you don't call method on mock but on some other object.", ""));
    }

    public void unfinishedVerificationException(Location location) {
        UnfinishedVerificationException unfinishedVerificationException = new UnfinishedVerificationException(StringJoiner.join("Missing method call for verify(mock) here:", location, "", "Example of correct verification:", "    verify(mock).doSomething()", "", "Also, this error might show up because you verify either of: final/private/equals()/hashCode() methods.", "Those methods *cannot* be stubbed/verified.", ""));
        throw unfinishedVerificationException;
    }

    public void notAMockPassedToVerify(Class clazz) {
        throw new NotAMockException(StringJoiner.join("Argument passed to verify() is of type " + clazz.getSimpleName() + " and is not a mock!", "Make sure you place the parenthesis correctly!", "See the examples of correct verifications:", "    verify(mock).someMethod();", "    verify(mock, times(10)).someMethod();", "    verify(mock, atLeastOnce()).someMethod();"));
    }

    public void nullPassedToVerify() {
        throw new NullInsteadOfMockException(StringJoiner.join("Argument passed to verify() should be a mock but is null!", "Examples of correct verifications:", "    verify(mock).someMethod();", "    verify(mock, times(10)).someMethod();", "    verify(mock, atLeastOnce()).someMethod();", "Also, if you use @Mock annotation don't miss initMocks()"));
    }

    public void notAMockPassedToWhenMethod() {
        throw new NotAMockException(StringJoiner.join("Argument passed to when() is not a mock!", "Example of correct stubbing:", "    doThrow(new RuntimeException()).when(mock).someMethod();"));
    }

    public void nullPassedToWhenMethod() {
        throw new NullInsteadOfMockException(StringJoiner.join("Argument passed to when() is null!", "Example of correct stubbing:", "    doThrow(new RuntimeException()).when(mock).someMethod();", "Also, if you use @Mock annotation don't miss initMocks()"));
    }

    public void mocksHaveToBePassedToVerifyNoMoreInteractions() {
        throw new MockitoException(StringJoiner.join("Method requires argument(s)!", "Pass mocks that should be verified, e.g:", "    verifyNoMoreInteractions(mockOne, mockTwo);", "    verifyZeroInteractions(mockOne, mockTwo);", ""));
    }

    public void notAMockPassedToVerifyNoMoreInteractions() {
        throw new NotAMockException(StringJoiner.join("Argument(s) passed is not a mock!", "Examples of correct verifications:", "    verifyNoMoreInteractions(mockOne, mockTwo);", "    verifyZeroInteractions(mockOne, mockTwo);", ""));
    }

    public void nullPassedToVerifyNoMoreInteractions() {
        throw new NullInsteadOfMockException(StringJoiner.join("Argument(s) passed is null!", "Examples of correct verifications:", "    verifyNoMoreInteractions(mockOne, mockTwo);", "    verifyZeroInteractions(mockOne, mockTwo);"));
    }

    public void notAMockPassedWhenCreatingInOrder() {
        throw new NotAMockException(StringJoiner.join("Argument(s) passed is not a mock!", "Pass mocks that require verification in order.", "For example:", "    InOrder inOrder = inOrder(mockOne, mockTwo);"));
    }

    public void nullPassedWhenCreatingInOrder() {
        throw new NullInsteadOfMockException(StringJoiner.join("Argument(s) passed is null!", "Pass mocks that require verification in order.", "For example:", "    InOrder inOrder = inOrder(mockOne, mockTwo);"));
    }

    public void mocksHaveToBePassedWhenCreatingInOrder() {
        throw new MockitoException(StringJoiner.join("Method requires argument(s)!", "Pass mocks that require verification in order.", "For example:", "    InOrder inOrder = inOrder(mockOne, mockTwo);"));
    }

    public void inOrderRequiresFamiliarMock() {
        throw new MockitoException(StringJoiner.join("InOrder can only verify mocks that were passed in during creation of InOrder.", "For example:", "    InOrder inOrder = inOrder(mockOne);", "    inOrder.verify(mockOne).doStuff();"));
    }

    public void invalidUseOfMatchers(int n, int n2) {
        throw new InvalidUseOfMatchersException(StringJoiner.join("Invalid use of argument matchers!", n + " matchers expected, " + n2 + " recorded.", "This exception may occur if matchers are combined with raw values:", "    //incorrect:", "    someMethod(anyObject(), \"raw String\");", "When using matchers, all arguments have to be provided by matchers.", "For example:", "    //correct:", "    someMethod(anyObject(), eq(\"String by matcher\"));", "", "For more info see javadoc for Matchers class."));
    }

    public void argumentsAreDifferent(String string, String string2, Location location) {
        String string3 = StringJoiner.join("Argument(s) are different! Wanted:", string, new Location(), "Actual invocation has different arguments:", string2, location, "");
        if (JUnitTool.hasJUnit()) {
            throw JUnitTool.createArgumentsAreDifferentException(string3, string, string2);
        }
        throw new ArgumentsAreDifferent(string3);
    }

    public void wantedButNotInvoked(PrintableInvocation printableInvocation) {
        throw new WantedButNotInvoked(this.createWantedButNotInvokedMessage(printableInvocation));
    }

    public void wantedButNotInvoked(PrintableInvocation printableInvocation, List<? extends PrintableInvocation> list) {
        CharSequence charSequence;
        String string;
        if (list.isEmpty()) {
            string = "Actually, there were zero interactions with this mock.\n";
        } else {
            charSequence = new StringBuilder("\nHowever, there were other interactions with this mock:\n");
            for (PrintableInvocation printableInvocation2 : list) {
                ((StringBuilder)charSequence).append(printableInvocation2.getLocation());
                ((StringBuilder)charSequence).append("\n");
            }
            string = ((StringBuilder)charSequence).toString();
        }
        charSequence = this.createWantedButNotInvokedMessage(printableInvocation);
        throw new WantedButNotInvoked((String)charSequence + string);
    }

    private String createWantedButNotInvokedMessage(PrintableInvocation printableInvocation) {
        return StringJoiner.join("Wanted but not invoked:", ((Object)printableInvocation).toString(), new Location(), "");
    }

    public void wantedButNotInvokedInOrder(PrintableInvocation printableInvocation, PrintableInvocation printableInvocation2) {
        throw new VerificationInOrderFailure(StringJoiner.join("Verification in order failure", "Wanted but not invoked:", ((Object)printableInvocation).toString(), new Location(), "Wanted anywhere AFTER following interaction:", ((Object)printableInvocation2).toString(), printableInvocation2.getLocation(), ""));
    }

    public void tooManyActualInvocations(int n, int n2, PrintableInvocation printableInvocation, Location location) {
        String string = this.createTooManyInvocationsMessage(n, n2, printableInvocation, location);
        throw new TooManyActualInvocations(string);
    }

    private String createTooManyInvocationsMessage(int n, int n2, PrintableInvocation printableInvocation, Location location) {
        return StringJoiner.join(((Object)printableInvocation).toString(), "Wanted " + Pluralizer.pluralize(n) + ":", new Location(), "But was " + Pluralizer.pluralize(n2) + ". Undesired invocation:", location, "");
    }

    public void neverWantedButInvoked(PrintableInvocation printableInvocation, Location location) {
        throw new NeverWantedButInvoked(StringJoiner.join(((Object)printableInvocation).toString(), "Never wanted here:", new Location(), "But invoked here:", location, ""));
    }

    public void tooManyActualInvocationsInOrder(int n, int n2, PrintableInvocation printableInvocation, Location location) {
        String string = this.createTooManyInvocationsMessage(n, n2, printableInvocation, location);
        throw new VerificationInOrderFailure(StringJoiner.join("Verification in order failure:" + string));
    }

    private String createTooLittleInvocationsMessage(Discrepancy discrepancy, PrintableInvocation printableInvocation, Location location) {
        String string = location != null ? location + "\n" : "\n";
        String string2 = StringJoiner.join(((Object)printableInvocation).toString(), "Wanted " + discrepancy.getPluralizedWantedCount() + ":", new Location(), "But was " + discrepancy.getPluralizedActualCount() + ":", string);
        return string2;
    }

    public void tooLittleActualInvocations(Discrepancy discrepancy, PrintableInvocation printableInvocation, Location location) {
        String string = this.createTooLittleInvocationsMessage(discrepancy, printableInvocation, location);
        throw new TooLittleActualInvocations(string);
    }

    public void tooLittleActualInvocationsInOrder(Discrepancy discrepancy, PrintableInvocation printableInvocation, Location location) {
        String string = this.createTooLittleInvocationsMessage(discrepancy, printableInvocation, location);
        throw new VerificationInOrderFailure(StringJoiner.join("Verification in order failure:" + string));
    }

    public void noMoreInteractionsWanted(Invocation invocation, List<VerificationAwareInvocation> list) {
        ScenarioPrinter scenarioPrinter = new ScenarioPrinter();
        String string = scenarioPrinter.print(list);
        throw new NoInteractionsWanted(StringJoiner.join("No interactions wanted here:", new Location(), "But found this interaction:", invocation.getLocation(), string));
    }

    public void noMoreInteractionsWantedInOrder(Invocation invocation) {
        throw new VerificationInOrderFailure(StringJoiner.join("No interactions wanted here:", new Location(), "But found this interaction:", invocation.getLocation(), ""));
    }

    public void cannotMockFinalClass(Class<?> clazz) {
        throw new MockitoException(StringJoiner.join("Cannot mock/spy " + clazz.toString(), "Mockito cannot mock/spy following:", "  - final classes", "  - anonymous classes", "  - primitive types"));
    }

    public void cannotStubVoidMethodWithAReturnValue(String string) {
        throw new MockitoException(StringJoiner.join("'" + string + "' is a *void method* and it *cannot* be stubbed with a *return value*!", "Voids are usually stubbed with Throwables:", "    doThrow(exception).when(mock).someVoidMethod();", "***", "If you're unsure why you're getting above error read on.", "Due to the nature of the syntax above problem might occur because:", "1. The method you are trying to stub is *overloaded*. Make sure you are calling the right overloaded version.", "2. Somewhere in your test you are stubbing *final methods*. Sorry, Mockito does not verify/stub final methods.", "3. A spy is stubbed using when(spy.foo()).then() syntax. It is safer to stub spies - ", "   - with doReturn|Throw() family of methods. More in javadocs for Mockito.spy() method.", ""));
    }

    public void onlyVoidMethodsCanBeSetToDoNothing() {
        throw new MockitoException(StringJoiner.join("Only void methods can doNothing()!", "Example of correct use of doNothing():", "    doNothing().", "    doThrow(new RuntimeException())", "    .when(mock).someVoidMethod();", "Above means:", "someVoidMethod() does nothing the 1st time but throws an exception the 2nd time is called"));
    }

    public void wrongTypeOfReturnValue(String string, String string2, String string3) {
        throw new WrongTypeOfReturnValue(StringJoiner.join(string2 + " cannot be returned by " + string3 + "()", string3 + "() should return " + string, "***", "This exception *might* occur in wrongly written multi-threaded tests.", "Please refer to Mockito FAQ on limitations of concurrency testing.", ""));
    }

    public void wantedAtMostX(int n, int n2) {
        throw new MockitoAssertionError(StringJoiner.join("Wanted at most " + Pluralizer.pluralize(n) + " but was " + n2));
    }

    public void misplacedArgumentMatcher(Location location) {
        throw new InvalidUseOfMatchersException(StringJoiner.join("Misplaced argument matcher detected here:", location, "", "You cannot use argument matchers outside of verification or stubbing.", "Examples of correct usage of argument matchers:", "    when(mock.get(anyInt())).thenReturn(null);", "    doThrow(new RuntimeException()).when(mock).someVoidMethod(anyObject());", "    verify(mock).someMethod(contains(\"foo\"))", "", "Also, this error might show up because you use argument matchers with methods that cannot be mocked.", "Following methods *cannot* be stubbed/verified: final/private/equals()/hashCode().", ""));
    }

    public void smartNullPointerException(String string, Location location) {
        throw new SmartNullPointerException(StringJoiner.join("You have a NullPointerException here:", new Location(), "because this method call was *not* stubbed correctly:", location, string, ""));
    }

    public void noArgumentValueWasCaptured() {
        throw new MockitoException(StringJoiner.join("No argument value was captured!", "You might have forgotten to use argument.capture() in verify()...", "...or you used capture() in stubbing but stubbed method was not called.", "Be aware that it is recommended to use capture() only with verify()", "", "Examples of correct argument capturing:", "    ArgumentCaptor<Person> argument = ArgumentCaptor.forClass(Person.class);", "    verify(mock).doSomething(argument.capture());", "    assertEquals(\"John\", argument.getValue().getName());", ""));
    }

    public void extraInterfacesDoesNotAcceptNullParameters() {
        throw new MockitoException(StringJoiner.join("extraInterfaces() does not accept null parameters."));
    }

    public void extraInterfacesAcceptsOnlyInterfaces(Class<?> clazz) {
        throw new MockitoException(StringJoiner.join("extraInterfaces() accepts only interfaces.", "You passed following type: " + clazz.getSimpleName() + " which is not an interface."));
    }

    public void extraInterfacesCannotContainMockedType(Class<?> clazz) {
        throw new MockitoException(StringJoiner.join("extraInterfaces() does not accept the same type as the mocked type.", "You mocked following type: " + clazz.getSimpleName(), "and you passed the same very interface to the extraInterfaces()"));
    }

    public void extraInterfacesRequiresAtLeastOneInterface() {
        throw new MockitoException(StringJoiner.join("extraInterfaces() requires at least one interface."));
    }

    public void mockedTypeIsInconsistentWithSpiedInstanceType(Class<?> clazz, Object object) {
        throw new MockitoException(StringJoiner.join("Mocked type must be the same as the type of your spied instance.", "Mocked type must be: " + object.getClass().getSimpleName() + ", but is: " + clazz.getSimpleName(), "  //correct spying:", "  spy = mock( ->ArrayList.class<- , withSettings().spiedInstance( ->new ArrayList()<- );", "  //incorrect - types don't match:", "  spy = mock( ->List.class<- , withSettings().spiedInstance( ->new ArrayList()<- );"));
    }

    public void cannotCallRealMethodOnInterface() {
        throw new MockitoException(StringJoiner.join("Cannot call real method on java interface. Interface does not have any implementation!", "Calling real methods is only possible when mocking concrete classes.", "  //correct example:", "  when(mockOfConcreteClass.doStuff()).thenCallRealMethod();"));
    }

    public void cannotVerifyToString() {
        throw new MockitoException(StringJoiner.join("Mockito cannot verify toString()", "toString() is too often used behind of scenes  (i.e. during String concatenation, in IDE debugging views). Verifying it may give inconsistent or hard to understand results. Not to mention that verifying toString() most likely hints awkward design (hard to explain in a short exception message. Trust me...)", "However, it is possible to stub toString(). Stubbing toString() smells a bit funny but there are rare, legitimate use cases."));
    }

    public void moreThanOneAnnotationNotAllowed(String string) {
        throw new MockitoException("You cannot have more than one Mockito annotation on a field!\nThe field '" + string + "' has multiple Mockito annotations.\n" + "For info how to use annotations see examples in javadoc for MockitoAnnotations class.");
    }

    public void unsupportedCombinationOfAnnotations(String string, String string2) {
        throw new MockitoException("This combination of annotations is not permitted on a single field:\n@" + string + " and @" + string2);
    }

    public void cannotInitializeForSpyAnnotation(String string, Exception exception) {
        throw new MockitoException(StringJoiner.join("Cannot instantiate a @Spy for '" + string + "' field.", "You haven't provided the instance for spying at field declaration so I tried to construct the instance.", "However, I failed because: " + exception.getMessage(), "Examples of correct usage of @Spy:", "   @Spy List mock = new LinkedList();", "   @Spy Foo foo; //only if Foo has parameterless constructor", "   //also, don't forget about MockitoAnnotations.initMocks();", ""), exception);
    }

    public void cannotInitializeForInjectMocksAnnotation(String string, Exception exception) {
        throw new MockitoException(StringJoiner.join("Cannot instantiate @InjectMocks field named '" + string + "'.", "You haven't provided the instance at field declaration so I tried to construct the instance.", "However, I failed because: " + exception.getMessage(), "Examples of correct usage of @InjectMocks:", "   @InjectMocks Service service = new Service();", "   @InjectMocks Service service;", "   //also, don't forget about MockitoAnnotations.initMocks();", "   //and... don't forget about some @Mocks for injection :)", ""), exception);
    }

    public void atMostShouldNotBeUsedWithTimeout() {
        throw new FriendlyReminderException(StringJoiner.join("", "Don't panic! I'm just a friendly reminder!", "timeout() should not be used with atMost() because...", "...it does not make much sense - the test would have passed immediately in concurency", "We kept this method only to avoid compilation errors when upgrading Mockito.", "In future release we will remove timeout(x).atMost(y) from the API.", "If you want to find out more please refer to issue 235", ""));
    }

    public void fieldInitialisationThrewException(Field field, Throwable throwable) {
        throw new MockitoException(StringJoiner.join("Cannot instantiate @InjectMocks field named '" + field.getName() + "' of type '" + field.getType() + "'.", "You haven't provided the instance at field declaration so I tried to construct the instance.", "However the constructor or the initialization block threw an exception : " + throwable.getMessage(), ""), throwable);
    }

    public void invocationListenerDoesNotAcceptNullParameters() {
        throw new MockitoException("invocationListeners() does not accept null parameters");
    }

    public void invocationListenersRequiresAtLeastOneListener() {
        throw new MockitoException("invocationListeners() requires at least one listener");
    }

    public void invocationListenerThrewException(InvocationListener invocationListener, Throwable throwable) {
        throw new MockitoException(StringJoiner.join("The invocation listener with type " + invocationListener.getClass().getName(), "threw an exception : " + throwable.getClass().getName() + throwable.getMessage()), throwable);
    }

    public void cannotInjectDependency(Field field, Object object, Exception exception) {
        throw new MockitoException(StringJoiner.join("Mockito couldn't inject mock dependency '" + new MockUtil().getMockName(object) + "' on field ", "'" + field + "'", "whose type '" + field.getDeclaringClass().getCanonicalName() + "' was annotated by @InjectMocks in your test.", "Also I failed because: " + exception.getCause().getMessage(), ""), exception);
    }
}

