/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.util;

import java.util.Comparator;
import org.mockito.asm.ClassVisitor;
import org.mockito.cglib.core.AbstractClassGenerator;
import org.mockito.cglib.core.ClassesKey;
import org.mockito.cglib.core.ReflectUtils;
import org.mockito.cglib.util.ParallelSorterEmitter;
import org.mockito.cglib.util.SorterTemplate;

public abstract class ParallelSorter
extends SorterTemplate {
    protected Object[] a;
    private Comparer comparer;

    protected ParallelSorter() {
    }

    public abstract ParallelSorter newInstance(Object[] var1);

    public static ParallelSorter create(Object[] objectArray) {
        Generator generator = new Generator();
        generator.setArrays(objectArray);
        return generator.create();
    }

    private int len() {
        return ((Object[])this.a[0]).length;
    }

    public void quickSort(int n) {
        this.quickSort(n, 0, this.len(), null);
    }

    public void quickSort(int n, int n2, int n3) {
        this.quickSort(n, n2, n3, null);
    }

    public void quickSort(int n, Comparator comparator) {
        this.quickSort(n, 0, this.len(), comparator);
    }

    public void quickSort(int n, int n2, int n3, Comparator comparator) {
        this.chooseComparer(n, comparator);
        super.quickSort(n2, n3 - 1);
    }

    public void mergeSort(int n) {
        this.mergeSort(n, 0, this.len(), null);
    }

    public void mergeSort(int n, int n2, int n3) {
        this.mergeSort(n, n2, n3, null);
    }

    public void mergeSort(int n, Comparator comparator) {
        this.mergeSort(n, 0, this.len(), comparator);
    }

    public void mergeSort(int n, int n2, int n3, Comparator comparator) {
        this.chooseComparer(n, comparator);
        super.mergeSort(n2, n3 - 1);
    }

    private void chooseComparer(int n, Comparator comparator) {
        Object object = this.a[n];
        Class<?> clazz = object.getClass().getComponentType();
        this.comparer = clazz.equals(Integer.TYPE) ? new IntComparer((int[])object) : (clazz.equals(Long.TYPE) ? new LongComparer((long[])object) : (clazz.equals(Double.TYPE) ? new DoubleComparer((double[])object) : (clazz.equals(Float.TYPE) ? new FloatComparer((float[])object) : (clazz.equals(Short.TYPE) ? new ShortComparer((short[])object) : (clazz.equals(Byte.TYPE) ? new ByteComparer((byte[])object) : (comparator != null ? new ComparatorComparer((Object[])object, comparator) : new ObjectComparer((Object[])object)))))));
    }

    @Override
    protected int compare(int n, int n2) {
        return this.comparer.compare(n, n2);
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(ParallelSorter.class.getName());
        private Object[] arrays;

        public Generator() {
            super(SOURCE);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return null;
        }

        public void setArrays(Object[] objectArray) {
            this.arrays = objectArray;
        }

        public ParallelSorter create() {
            return (ParallelSorter)super.create(ClassesKey.create(this.arrays));
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) throws Exception {
            if (this.arrays.length == 0) {
                throw new IllegalArgumentException("No arrays specified to sort");
            }
            for (int i = 0; i < this.arrays.length; ++i) {
                if (this.arrays[i].getClass().isArray()) continue;
                throw new IllegalArgumentException(this.arrays[i].getClass() + " is not an array");
            }
            new ParallelSorterEmitter(classVisitor, this.getClassName(), this.arrays);
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ((ParallelSorter)ReflectUtils.newInstance(clazz)).newInstance(this.arrays);
        }

        @Override
        protected Object nextInstance(Object object) {
            return ((ParallelSorter)object).newInstance(this.arrays);
        }
    }

    static class ByteComparer
    implements Comparer {
        private byte[] a;

        public ByteComparer(byte[] byArray) {
            this.a = byArray;
        }

        @Override
        public int compare(int n, int n2) {
            return this.a[n] - this.a[n2];
        }
    }

    static class ShortComparer
    implements Comparer {
        private short[] a;

        public ShortComparer(short[] sArray) {
            this.a = sArray;
        }

        @Override
        public int compare(int n, int n2) {
            return this.a[n] - this.a[n2];
        }
    }

    static class DoubleComparer
    implements Comparer {
        private double[] a;

        public DoubleComparer(double[] dArray) {
            this.a = dArray;
        }

        @Override
        public int compare(int n, int n2) {
            double d = this.a[n];
            double d2 = this.a[n2];
            return d == d2 ? 0 : (d > d2 ? 1 : -1);
        }
    }

    static class FloatComparer
    implements Comparer {
        private float[] a;

        public FloatComparer(float[] fArray) {
            this.a = fArray;
        }

        @Override
        public int compare(int n, int n2) {
            float f = this.a[n];
            float f2 = this.a[n2];
            return f == f2 ? 0 : (f > f2 ? 1 : -1);
        }
    }

    static class LongComparer
    implements Comparer {
        private long[] a;

        public LongComparer(long[] lArray) {
            this.a = lArray;
        }

        @Override
        public int compare(int n, int n2) {
            long l = this.a[n];
            long l2 = this.a[n2];
            return l == l2 ? 0 : (l > l2 ? 1 : -1);
        }
    }

    static class IntComparer
    implements Comparer {
        private int[] a;

        public IntComparer(int[] nArray) {
            this.a = nArray;
        }

        @Override
        public int compare(int n, int n2) {
            return this.a[n] - this.a[n2];
        }
    }

    static class ObjectComparer
    implements Comparer {
        private Object[] a;

        public ObjectComparer(Object[] objectArray) {
            this.a = objectArray;
        }

        @Override
        public int compare(int n, int n2) {
            return ((Comparable)this.a[n]).compareTo(this.a[n2]);
        }
    }

    static class ComparatorComparer
    implements Comparer {
        private Object[] a;
        private Comparator cmp;

        public ComparatorComparer(Object[] objectArray, Comparator comparator) {
            this.a = objectArray;
            this.cmp = comparator;
        }

        @Override
        public int compare(int n, int n2) {
            return this.cmp.compare(this.a[n], this.a[n2]);
        }
    }

    static interface Comparer {
        public int compare(int var1, int var2);
    }
}

