/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.transform.impl;

import java.lang.reflect.Constructor;
import org.mockito.asm.Type;
import org.mockito.cglib.core.Block;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.EmitUtils;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.core.TypeUtils;
import org.mockito.cglib.transform.ClassEmitterTransformer;

public class UndeclaredThrowableTransformer
extends ClassEmitterTransformer {
    private Type wrapper;

    public UndeclaredThrowableTransformer(Class clazz) {
        this.wrapper = Type.getType(clazz);
        boolean bl = false;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != 1 || !classArray[0].equals(Throwable.class)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException(clazz + " does not have a single-arg constructor that takes a Throwable");
        }
    }

    @Override
    public CodeEmitter begin_method(int n, Signature signature, final Type[] typeArray) {
        CodeEmitter codeEmitter = super.begin_method(n, signature, typeArray);
        if (TypeUtils.isAbstract(n) || signature.equals(Constants.SIG_STATIC)) {
            return codeEmitter;
        }
        return new CodeEmitter(codeEmitter){
            private Block handler;
            {
                super(codeEmitter);
                this.handler = this.begin_block();
            }

            @Override
            public void visitMaxs(int n, int n2) {
                this.handler.end();
                EmitUtils.wrap_undeclared_throwable(this, this.handler, typeArray, UndeclaredThrowableTransformer.this.wrapper);
                super.visitMaxs(n, n2);
            }
        };
    }
}

