/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.transform.impl;

import java.lang.reflect.Method;
import org.mockito.asm.Type;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.EmitUtils;
import org.mockito.cglib.core.MethodInfo;
import org.mockito.cglib.core.ReflectUtils;
import org.mockito.cglib.core.TypeUtils;
import org.mockito.cglib.transform.ClassEmitterTransformer;

public class AddStaticInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddStaticInitTransformer(Method method) {
        this.info = ReflectUtils.getMethodInfo(method);
        if (!TypeUtils.isStatic(this.info.getModifiers())) {
            throw new IllegalArgumentException(method + " is not static");
        }
        Type[] typeArray = this.info.getSignature().getArgumentTypes();
        if (typeArray.length != 1 || !typeArray[0].equals(Constants.TYPE_CLASS) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(method + " illegal signature");
        }
    }

    @Override
    protected void init() {
        if (!TypeUtils.isInterface(this.getAccess())) {
            CodeEmitter codeEmitter = this.getStaticHook();
            EmitUtils.load_class_this(codeEmitter);
            codeEmitter.invoke(this.info);
        }
    }
}

