/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.proxy;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.mockito.asm.Label;
import org.mockito.asm.Type;
import org.mockito.cglib.core.ClassEmitter;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.MethodInfo;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.core.TypeUtils;
import org.mockito.cglib.proxy.CallbackGenerator;

class LazyLoaderGenerator
implements CallbackGenerator {
    public static final LazyLoaderGenerator INSTANCE = new LazyLoaderGenerator();
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Type LAZY_LOADER = TypeUtils.parseType("org.mockito.cglib.proxy.LazyLoader");

    LazyLoaderGenerator() {
    }

    @Override
    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context, List list) {
        CodeEmitter codeEmitter;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (MethodInfo methodInfo : list) {
            if (TypeUtils.isProtected(methodInfo.getModifiers())) continue;
            int n = context.getIndex(methodInfo);
            hashSet.add(new Integer(n));
            codeEmitter = context.beginMethod(classEmitter, methodInfo);
            codeEmitter.load_this();
            codeEmitter.dup();
            codeEmitter.invoke_virtual_this(this.loadMethod(n));
            codeEmitter.checkcast(methodInfo.getClassInfo().getType());
            codeEmitter.load_args();
            codeEmitter.invoke(methodInfo);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            String string = "CGLIB$LAZY_LOADER_" + n;
            classEmitter.declare_field(2, string, Constants.TYPE_OBJECT, null);
            codeEmitter = classEmitter.begin_method(50, this.loadMethod(n), null);
            codeEmitter.load_this();
            codeEmitter.getfield(string);
            codeEmitter.dup();
            Label label = codeEmitter.make_label();
            codeEmitter.ifnonnull(label);
            codeEmitter.pop();
            codeEmitter.load_this();
            context.emitCallback(codeEmitter, n);
            codeEmitter.invoke_interface(LAZY_LOADER, LOAD_OBJECT);
            codeEmitter.dup_x1();
            codeEmitter.putfield(string);
            codeEmitter.mark(label);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
    }

    private Signature loadMethod(int n) {
        return new Signature("CGLIB$LOAD_PRIVATE_" + n, Constants.TYPE_OBJECT, Constants.TYPES_EMPTY);
    }

    @Override
    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context, List list) {
    }
}

