/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.core;

import java.util.Arrays;
import org.mockito.asm.Attribute;
import org.mockito.asm.Label;
import org.mockito.asm.MethodVisitor;
import org.mockito.asm.Type;
import org.mockito.cglib.core.Block;
import org.mockito.cglib.core.ClassEmitter;
import org.mockito.cglib.core.ClassInfo;
import org.mockito.cglib.core.CodeGenerationException;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.Local;
import org.mockito.cglib.core.LocalVariablesSorter;
import org.mockito.cglib.core.MethodInfo;
import org.mockito.cglib.core.ProcessSwitchCallback;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.core.TypeUtils;

public class CodeEmitter
extends LocalVariablesSorter {
    private static final Signature BOOLEAN_VALUE = TypeUtils.parseSignature("boolean booleanValue()");
    private static final Signature CHAR_VALUE = TypeUtils.parseSignature("char charValue()");
    private static final Signature LONG_VALUE = TypeUtils.parseSignature("long longValue()");
    private static final Signature DOUBLE_VALUE = TypeUtils.parseSignature("double doubleValue()");
    private static final Signature FLOAT_VALUE = TypeUtils.parseSignature("float floatValue()");
    private static final Signature INT_VALUE = TypeUtils.parseSignature("int intValue()");
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature CSTRUCT_STRING = TypeUtils.parseConstructor("String");
    public static final int ADD = 96;
    public static final int MUL = 104;
    public static final int XOR = 130;
    public static final int USHR = 124;
    public static final int SUB = 100;
    public static final int DIV = 108;
    public static final int NEG = 116;
    public static final int REM = 112;
    public static final int AND = 126;
    public static final int OR = 128;
    public static final int GT = 157;
    public static final int LT = 155;
    public static final int GE = 156;
    public static final int LE = 158;
    public static final int NE = 154;
    public static final int EQ = 153;
    private ClassEmitter ce;
    private State state;

    CodeEmitter(ClassEmitter classEmitter, MethodVisitor methodVisitor, int n, Signature signature, Type[] typeArray) {
        super(n, signature.getDescriptor(), methodVisitor);
        this.ce = classEmitter;
        this.state = new State(classEmitter.getClassInfo(), n, signature, typeArray);
    }

    public CodeEmitter(CodeEmitter codeEmitter) {
        super(codeEmitter);
        this.ce = codeEmitter.ce;
        this.state = codeEmitter.state;
    }

    public boolean isStaticHook() {
        return false;
    }

    public Signature getSignature() {
        return this.state.sig;
    }

    public Type getReturnType() {
        return this.state.sig.getReturnType();
    }

    public MethodInfo getMethodInfo() {
        return this.state;
    }

    public ClassEmitter getClassEmitter() {
        return this.ce;
    }

    public void end_method() {
        this.visitMaxs(0, 0);
    }

    public Block begin_block() {
        return new Block(this);
    }

    public void catch_exception(Block block, Type type) {
        if (block.getEnd() == null) {
            throw new IllegalStateException("end of block is unset");
        }
        this.mv.visitTryCatchBlock(block.getStart(), block.getEnd(), this.mark(), type.getInternalName());
    }

    public void goTo(Label label) {
        this.mv.visitJumpInsn(167, label);
    }

    public void ifnull(Label label) {
        this.mv.visitJumpInsn(198, label);
    }

    public void ifnonnull(Label label) {
        this.mv.visitJumpInsn(199, label);
    }

    public void if_jump(int n, Label label) {
        this.mv.visitJumpInsn(n, label);
    }

    public void if_icmp(int n, Label label) {
        this.if_cmp(Type.INT_TYPE, n, label);
    }

    public void if_cmp(Type type, int n, Label label) {
        int n2 = -1;
        int n3 = n;
        switch (n) {
            case 156: {
                n3 = 155;
                break;
            }
            case 158: {
                n3 = 157;
            }
        }
        switch (type.getSort()) {
            case 7: {
                this.mv.visitInsn(148);
                break;
            }
            case 8: {
                this.mv.visitInsn(152);
                break;
            }
            case 6: {
                this.mv.visitInsn(150);
                break;
            }
            case 9: 
            case 10: {
                switch (n) {
                    case 153: {
                        this.mv.visitJumpInsn(165, label);
                        return;
                    }
                    case 154: {
                        this.mv.visitJumpInsn(166, label);
                        return;
                    }
                }
                throw new IllegalArgumentException("Bad comparison for type " + type);
            }
            default: {
                switch (n) {
                    case 153: {
                        n2 = 159;
                        break;
                    }
                    case 154: {
                        n2 = 160;
                        break;
                    }
                    case 156: {
                        this.swap();
                    }
                    case 155: {
                        n2 = 161;
                        break;
                    }
                    case 158: {
                        this.swap();
                    }
                    case 157: {
                        n2 = 163;
                    }
                }
                this.mv.visitJumpInsn(n2, label);
                return;
            }
        }
        this.if_jump(n3, label);
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void pop2() {
        this.mv.visitInsn(88);
    }

    public void dup() {
        this.mv.visitInsn(89);
    }

    public void dup2() {
        this.mv.visitInsn(92);
    }

    public void dup_x1() {
        this.mv.visitInsn(90);
    }

    public void dup_x2() {
        this.mv.visitInsn(91);
    }

    public void dup2_x1() {
        this.mv.visitInsn(93);
    }

    public void dup2_x2() {
        this.mv.visitInsn(94);
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void aconst_null() {
        this.mv.visitInsn(1);
    }

    public void swap(Type type, Type type2) {
        if (type2.getSize() == 1) {
            if (type.getSize() == 1) {
                this.swap();
            } else {
                this.dup_x2();
                this.pop();
            }
        } else if (type.getSize() == 1) {
            this.dup2_x1();
            this.pop2();
        } else {
            this.dup2_x2();
            this.pop2();
        }
    }

    public void monitorenter() {
        this.mv.visitInsn(194);
    }

    public void monitorexit() {
        this.mv.visitInsn(195);
    }

    public void math(int n, Type type) {
        this.mv.visitInsn(type.getOpcode(n));
    }

    public void array_load(Type type) {
        this.mv.visitInsn(type.getOpcode(46));
    }

    public void array_store(Type type) {
        this.mv.visitInsn(type.getOpcode(79));
    }

    public void cast_numeric(Type type, Type type2) {
        if (type != type2) {
            if (type == Type.DOUBLE_TYPE) {
                if (type2 == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(144);
                } else if (type2 == Type.LONG_TYPE) {
                    this.mv.visitInsn(143);
                } else {
                    this.mv.visitInsn(142);
                    this.cast_numeric(Type.INT_TYPE, type2);
                }
            } else if (type == Type.FLOAT_TYPE) {
                if (type2 == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(141);
                } else if (type2 == Type.LONG_TYPE) {
                    this.mv.visitInsn(140);
                } else {
                    this.mv.visitInsn(139);
                    this.cast_numeric(Type.INT_TYPE, type2);
                }
            } else if (type == Type.LONG_TYPE) {
                if (type2 == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(138);
                } else if (type2 == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(137);
                } else {
                    this.mv.visitInsn(136);
                    this.cast_numeric(Type.INT_TYPE, type2);
                }
            } else if (type2 == Type.BYTE_TYPE) {
                this.mv.visitInsn(145);
            } else if (type2 == Type.CHAR_TYPE) {
                this.mv.visitInsn(146);
            } else if (type2 == Type.DOUBLE_TYPE) {
                this.mv.visitInsn(135);
            } else if (type2 == Type.FLOAT_TYPE) {
                this.mv.visitInsn(134);
            } else if (type2 == Type.LONG_TYPE) {
                this.mv.visitInsn(133);
            } else if (type2 == Type.SHORT_TYPE) {
                this.mv.visitInsn(147);
            }
        }
    }

    public void push(int n) {
        if (n < -1) {
            this.mv.visitLdcInsn(new Integer(n));
        } else if (n <= 5) {
            this.mv.visitInsn(TypeUtils.ICONST(n));
        } else if (n <= 127) {
            this.mv.visitIntInsn(16, n);
        } else if (n <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, n);
        } else {
            this.mv.visitLdcInsn(new Integer(n));
        }
    }

    public void push(long l) {
        if (l == 0L || l == 1L) {
            this.mv.visitInsn(TypeUtils.LCONST(l));
        } else {
            this.mv.visitLdcInsn(new Long(l));
        }
    }

    public void push(float f) {
        if (f == 0.0f || f == 1.0f || f == 2.0f) {
            this.mv.visitInsn(TypeUtils.FCONST(f));
        } else {
            this.mv.visitLdcInsn(new Float(f));
        }
    }

    public void push(double d) {
        if (d == 0.0 || d == 1.0) {
            this.mv.visitInsn(TypeUtils.DCONST(d));
        } else {
            this.mv.visitLdcInsn(new Double(d));
        }
    }

    public void push(String string) {
        this.mv.visitLdcInsn(string);
    }

    public void newarray() {
        this.newarray(Constants.TYPE_OBJECT);
    }

    public void newarray(Type type) {
        if (TypeUtils.isPrimitive(type)) {
            this.mv.visitIntInsn(188, TypeUtils.NEWARRAY(type));
        } else {
            this.emit_type(189, type);
        }
    }

    public void arraylength() {
        this.mv.visitInsn(190);
    }

    public void load_this() {
        if (TypeUtils.isStatic(this.state.access)) {
            throw new IllegalStateException("no 'this' pointer within static method");
        }
        this.mv.visitVarInsn(25, 0);
    }

    public void load_args() {
        this.load_args(0, this.state.argumentTypes.length);
    }

    public void load_arg(int n) {
        this.load_local(this.state.argumentTypes[n], this.state.localOffset + this.skipArgs(n));
    }

    public void load_args(int n, int n2) {
        int n3 = this.state.localOffset + this.skipArgs(n);
        for (int i = 0; i < n2; ++i) {
            Type type = this.state.argumentTypes[n + i];
            this.load_local(type, n3);
            n3 += type.getSize();
        }
    }

    private int skipArgs(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.state.argumentTypes[i].getSize();
        }
        return n2;
    }

    private void load_local(Type type, int n) {
        this.mv.visitVarInsn(type.getOpcode(21), n);
    }

    private void store_local(Type type, int n) {
        this.mv.visitVarInsn(type.getOpcode(54), n);
    }

    public void iinc(Local local, int n) {
        this.mv.visitIincInsn(local.getIndex(), n);
    }

    public void store_local(Local local) {
        this.store_local(local.getType(), local.getIndex());
    }

    public void load_local(Local local) {
        this.load_local(local.getType(), local.getIndex());
    }

    public void return_value() {
        this.mv.visitInsn(this.state.sig.getReturnType().getOpcode(172));
    }

    public void getfield(String string) {
        ClassEmitter.FieldInfo fieldInfo = this.ce.getFieldInfo(string);
        int n = TypeUtils.isStatic(fieldInfo.access) ? 178 : 180;
        this.emit_field(n, this.ce.getClassType(), string, fieldInfo.type);
    }

    public void putfield(String string) {
        ClassEmitter.FieldInfo fieldInfo = this.ce.getFieldInfo(string);
        int n = TypeUtils.isStatic(fieldInfo.access) ? 179 : 181;
        this.emit_field(n, this.ce.getClassType(), string, fieldInfo.type);
    }

    public void super_getfield(String string, Type type) {
        this.emit_field(180, this.ce.getSuperType(), string, type);
    }

    public void super_putfield(String string, Type type) {
        this.emit_field(181, this.ce.getSuperType(), string, type);
    }

    public void super_getstatic(String string, Type type) {
        this.emit_field(178, this.ce.getSuperType(), string, type);
    }

    public void super_putstatic(String string, Type type) {
        this.emit_field(179, this.ce.getSuperType(), string, type);
    }

    public void getfield(Type type, String string, Type type2) {
        this.emit_field(180, type, string, type2);
    }

    public void putfield(Type type, String string, Type type2) {
        this.emit_field(181, type, string, type2);
    }

    public void getstatic(Type type, String string, Type type2) {
        this.emit_field(178, type, string, type2);
    }

    public void putstatic(Type type, String string, Type type2) {
        this.emit_field(179, type, string, type2);
    }

    void emit_field(int n, Type type, String string, Type type2) {
        this.mv.visitFieldInsn(n, type.getInternalName(), string, type2.getDescriptor());
    }

    public void super_invoke() {
        this.super_invoke(this.state.sig);
    }

    public void super_invoke(Signature signature) {
        this.emit_invoke(183, this.ce.getSuperType(), signature);
    }

    public void invoke_constructor(Type type) {
        this.invoke_constructor(type, CSTRUCT_NULL);
    }

    public void super_invoke_constructor() {
        this.invoke_constructor(this.ce.getSuperType());
    }

    public void invoke_constructor_this() {
        this.invoke_constructor(this.ce.getClassType());
    }

    private void emit_invoke(int n, Type type, Signature signature) {
        if (!signature.getName().equals("<init>") || n == 182 || n == 184) {
            // empty if block
        }
        this.mv.visitMethodInsn(n, type.getInternalName(), signature.getName(), signature.getDescriptor());
    }

    public void invoke_interface(Type type, Signature signature) {
        this.emit_invoke(185, type, signature);
    }

    public void invoke_virtual(Type type, Signature signature) {
        this.emit_invoke(182, type, signature);
    }

    public void invoke_static(Type type, Signature signature) {
        this.emit_invoke(184, type, signature);
    }

    public void invoke_virtual_this(Signature signature) {
        this.invoke_virtual(this.ce.getClassType(), signature);
    }

    public void invoke_static_this(Signature signature) {
        this.invoke_static(this.ce.getClassType(), signature);
    }

    public void invoke_constructor(Type type, Signature signature) {
        this.emit_invoke(183, type, signature);
    }

    public void invoke_constructor_this(Signature signature) {
        this.invoke_constructor(this.ce.getClassType(), signature);
    }

    public void super_invoke_constructor(Signature signature) {
        this.invoke_constructor(this.ce.getSuperType(), signature);
    }

    public void new_instance_this() {
        this.new_instance(this.ce.getClassType());
    }

    public void new_instance(Type type) {
        this.emit_type(187, type);
    }

    private void emit_type(int n, Type type) {
        String string = TypeUtils.isArray(type) ? type.getDescriptor() : type.getInternalName();
        this.mv.visitTypeInsn(n, string);
    }

    public void aaload(int n) {
        this.push(n);
        this.aaload();
    }

    public void aaload() {
        this.mv.visitInsn(50);
    }

    public void aastore() {
        this.mv.visitInsn(83);
    }

    public void athrow() {
        this.mv.visitInsn(191);
    }

    public Label make_label() {
        return new Label();
    }

    public Local make_local() {
        return this.make_local(Constants.TYPE_OBJECT);
    }

    public Local make_local(Type type) {
        return new Local(this.newLocal(type.getSize()), type);
    }

    public void checkcast_this() {
        this.checkcast(this.ce.getClassType());
    }

    public void checkcast(Type type) {
        if (!type.equals(Constants.TYPE_OBJECT)) {
            this.emit_type(192, type);
        }
    }

    public void instance_of(Type type) {
        this.emit_type(193, type);
    }

    public void instance_of_this() {
        this.instance_of(this.ce.getClassType());
    }

    public void process_switch(int[] nArray, ProcessSwitchCallback processSwitchCallback) {
        float f = nArray.length == 0 ? 0.0f : (float)nArray.length / (float)(nArray[nArray.length - 1] - nArray[0] + 1);
        this.process_switch(nArray, processSwitchCallback, f >= 0.5f);
    }

    public void process_switch(int[] nArray, ProcessSwitchCallback processSwitchCallback, boolean bl) {
        if (!CodeEmitter.isSorted(nArray)) {
            throw new IllegalArgumentException("keys to switch must be sorted ascending");
        }
        Label label = this.make_label();
        Label label2 = this.make_label();
        try {
            if (nArray.length > 0) {
                int n = nArray.length;
                int n2 = nArray[0];
                int n3 = nArray[n - 1];
                int n4 = n3 - n2 + 1;
                if (bl) {
                    int n5;
                    Object[] objectArray = new Label[n4];
                    Arrays.fill(objectArray, label);
                    for (n5 = 0; n5 < n; ++n5) {
                        objectArray[nArray[n5] - n2] = this.make_label();
                    }
                    this.mv.visitTableSwitchInsn(n2, n3, label, (Label[])objectArray);
                    for (n5 = 0; n5 < n4; ++n5) {
                        Object object = objectArray[n5];
                        if (object == label) continue;
                        this.mark((Label)object);
                        processSwitchCallback.processCase(n5 + n2, label2);
                    }
                } else {
                    int n6;
                    Label[] labelArray = new Label[n];
                    for (n6 = 0; n6 < n; ++n6) {
                        labelArray[n6] = this.make_label();
                    }
                    this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
                    for (n6 = 0; n6 < n; ++n6) {
                        this.mark(labelArray[n6]);
                        processSwitchCallback.processCase(nArray[n6], label2);
                    }
                }
            }
            this.mark(label);
            processSwitchCallback.processDefault();
            this.mark(label2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    private static boolean isSorted(int[] nArray) {
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= nArray[i - 1]) continue;
            return false;
        }
        return true;
    }

    public void mark(Label label) {
        this.mv.visitLabel(label);
    }

    Label mark() {
        Label label = this.make_label();
        this.mv.visitLabel(label);
        return label;
    }

    public void push(boolean bl) {
        this.push(bl ? 1 : 0);
    }

    public void not() {
        this.push(1);
        this.math(130, Type.INT_TYPE);
    }

    public void throw_exception(Type type, String string) {
        this.new_instance(type);
        this.dup();
        this.push(string);
        this.invoke_constructor(type, CSTRUCT_STRING);
        this.athrow();
    }

    public void box(Type type) {
        if (TypeUtils.isPrimitive(type)) {
            if (type == Type.VOID_TYPE) {
                this.aconst_null();
            } else {
                Type type2 = TypeUtils.getBoxedType(type);
                this.new_instance(type2);
                if (type.getSize() == 2) {
                    this.dup_x2();
                    this.dup_x2();
                    this.pop();
                } else {
                    this.dup_x1();
                    this.swap();
                }
                this.invoke_constructor(type2, new Signature("<init>", Type.VOID_TYPE, new Type[]{type}));
            }
        }
    }

    public void unbox(Type type) {
        Type type2 = Constants.TYPE_NUMBER;
        Signature signature = null;
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                type2 = Constants.TYPE_CHARACTER;
                signature = CHAR_VALUE;
                break;
            }
            case 1: {
                type2 = Constants.TYPE_BOOLEAN;
                signature = BOOLEAN_VALUE;
                break;
            }
            case 8: {
                signature = DOUBLE_VALUE;
                break;
            }
            case 6: {
                signature = FLOAT_VALUE;
                break;
            }
            case 7: {
                signature = LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                signature = INT_VALUE;
            }
        }
        if (signature == null) {
            this.checkcast(type);
        } else {
            this.checkcast(type2);
            this.invoke_virtual(type2, signature);
        }
    }

    public void create_arg_array() {
        this.push(this.state.argumentTypes.length);
        this.newarray();
        for (int i = 0; i < this.state.argumentTypes.length; ++i) {
            this.dup();
            this.push(i);
            this.load_arg(i);
            this.box(this.state.argumentTypes[i]);
            this.aastore();
        }
    }

    public void zero_or_null(Type type) {
        if (TypeUtils.isPrimitive(type)) {
            switch (type.getSort()) {
                case 8: {
                    this.push(0.0);
                    break;
                }
                case 7: {
                    this.push(0L);
                    break;
                }
                case 6: {
                    this.push(0.0f);
                    break;
                }
                case 0: {
                    this.aconst_null();
                }
                default: {
                    this.push(0);
                    break;
                }
            }
        } else {
            this.aconst_null();
        }
    }

    public void unbox_or_zero(Type type) {
        if (TypeUtils.isPrimitive(type)) {
            if (type != Type.VOID_TYPE) {
                Label label = this.make_label();
                Label label2 = this.make_label();
                this.dup();
                this.ifnonnull(label);
                this.pop();
                this.zero_or_null(type);
                this.goTo(label2);
                this.mark(label);
                this.unbox(type);
                this.mark(label2);
            }
        } else {
            this.checkcast(type);
        }
    }

    @Override
    public void visitMaxs(int n, int n2) {
        if (!TypeUtils.isAbstract(this.state.access)) {
            this.mv.visitMaxs(0, 0);
        }
    }

    public void invoke(MethodInfo methodInfo, Type type) {
        ClassInfo classInfo = methodInfo.getClassInfo();
        Type type2 = classInfo.getType();
        Signature signature = methodInfo.getSignature();
        if (signature.getName().equals("<init>")) {
            this.invoke_constructor(type2, signature);
        } else if (TypeUtils.isInterface(classInfo.getModifiers())) {
            this.invoke_interface(type2, signature);
        } else if (TypeUtils.isStatic(methodInfo.getModifiers())) {
            this.invoke_static(type2, signature);
        } else {
            this.invoke_virtual(type, signature);
        }
    }

    public void invoke(MethodInfo methodInfo) {
        this.invoke(methodInfo, methodInfo.getClassInfo().getType());
    }

    private static class State
    extends MethodInfo {
        ClassInfo classInfo;
        int access;
        Signature sig;
        Type[] argumentTypes;
        int localOffset;
        Type[] exceptionTypes;

        State(ClassInfo classInfo, int n, Signature signature, Type[] typeArray) {
            this.classInfo = classInfo;
            this.access = n;
            this.sig = signature;
            this.exceptionTypes = typeArray;
            this.localOffset = TypeUtils.isStatic(n) ? 0 : 1;
            this.argumentTypes = signature.getArgumentTypes();
        }

        @Override
        public ClassInfo getClassInfo() {
            return this.classInfo;
        }

        @Override
        public int getModifiers() {
            return this.access;
        }

        @Override
        public Signature getSignature() {
            return this.sig;
        }

        @Override
        public Type[] getExceptionTypes() {
            return this.exceptionTypes;
        }

        public Attribute getAttribute() {
            return null;
        }
    }
}

