/*
 * Copyright (C) 2005-2008 Freescale Semiconductor, Inc. All rights reserved.
 *
 */
 
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    mfw_gst_mpg2_demuxer.h  
 *
 * Description:    This Header file contains all the declarations 
 *                 of MPG2/M4a Demuxer Plugin for GStreamer.                         
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 *
 */

#ifndef __MFW_GST_MPG2_DEMUXER_H__
#define __MFW_GST_MPG2_DEMUXER_H__

/*=============================================================================
                            INCLUDE FILES
=============================================================================*/


/*=============================================================================
                              CONSTANTS
=============================================================================*/

/* None. */

/*=============================================================================
                               ENUMS
=============================================================================*/
/* None */
#define AUDIO_INDEX      0
#define VIDEO_INDEX      1
#define MAX_SRC_PADS     16

typedef enum{
    OP_NORMAL=1,
    OP_PROBE_DURATION,
    OP_PROBE_I_FRAME,
    OP_PROBE_AUDIO,
} OP_MODE;

typedef enum{
    NO_ESCAPE = 0,
    ESCAPE_ERROR,
    ESCAPE_RESYNC,
    ESCAPE_NOT_LINKED,
} ESCAPE_CODE;

#define FIRST_VIDEO_PTS_MASK 0x01
#define FIRST_AUDIO_PTS_MASK 0x10

/*=============================================================================
                               MACROS
=============================================================================*/
G_BEGIN_DECLS

#define MFW_GST_TYPE_MPG2_DEMUXER \
  (mfw_gst_type_mpg2_demuxer_get_type())
#define MFW_GST_MPG2_DEMUXER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),MFW_GST_TYPE_MPG2_DEMUXER,MFW_GST_MPG2DEMUX_INFO_T))
#define MFW_GST_MPG2_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),MFW_GST_TYPE_MPG2_DEMUXER,MFW_GST_MPG2DEMUX_INFO_CLASS_T))
#define MFW_GST_IS_MPG2_DEMUXER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),MFW_GST_TYPE_MPG2_DEMUXER))
#define GST_IS_MPG2_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),MFW_GST_TYPE_MPG2_DEMUXER))

/*=============================================================================
                            STRUCTURES AND OTHER TYPEDEFS
=============================================================================*/
typedef void              VOID;

typedef struct _mpg2_input_file_info {
    gint64 length;		                               /* Length of the file/buffer */
    guint64 offset;	                                   /* Present location.         */
} mpg2_input_file_info;



typedef struct _MFW_GST_MPG2DEMUX_INFO_T {
    GstElement element;		                            /* instance of base class      */
    GstPad *sinkpad;		                            /* sink pad of element         */
    GstPad *srcpad[MAX_SRC_PADS];	                    /* src pads for output data    */
    GstCaps *caps[MAX_SRC_PADS];	                    /* src pad capability          */
    U32 streamID[MAX_SRC_PADS];
    GstBuffer * outGstbuf[MAX_SRC_PADS];
    U32 streamType[MAX_SRC_PADS];
    U32 audio_type[MAX_SRC_PADS]; /* FSL_MPG_DEMUX_AUDIO_TYPE_T */

    gint audio_pad_idx; 
    gint video_pad_idx; 

    
    mpg2_input_file_info file_info;	                    /* file information            */
    GstSegment segment;		                            /* configured play segment     */
    gboolean stop_request;	                            /* stop request flag           */
    gboolean new_seg_flag_video;
	gboolean new_seg_flag_audio;
    guint8 *inbuff;
	gboolean seek_flag;

    FSL_MPG_DEMUX_T * parser_object;

    //control set for feed buffer to core demuxer.
    FSL_MPG_DEMUX_BD_T * inbuf_object;
    guint inReadIndex;
    guint inWriteIndex;
    guint streamMask;

    GstAdapter * vAdapter;
    GstAdapter * aAdapter;
    
    gboolean eosfile;

    //startcode searching variables
    guint32 searchstart;
    guint32 lastword;

    //AC3 Startcode searching variables
    guint32 ac3_sstart;
    guint32 ac3_lastword;

    
    guint64 vtimestamp;
    guint64 atimestamp;

    /* The base time of the streaming clips */
    guint64 baseVTS;
    guint64 baseATS;
    
    guint64 audioduration;
    guint64 videoduration;

    guint64 seektime;
    guint64 syncstart;

    gint findHead;
    gboolean vtimevalid;
    
    ESCAPE_CODE escape;
    OP_MODE opmode;

    gint audio_track_num; /* The total audio track number */
    gint video_track_num; /* The total video track number */

    gint audio_track_idx; /* The audio track index enabled. */
    gint video_track_idx; /* The video track index enabled. */

    guint first_media_pts; /* 0x1: Video 0x10: Audio */
    
    guint track_signal_id;
    gboolean is_get_stream_info;
    GMutex *lock_mutex;

    gboolean videosent;
    
} MFW_GST_MPG2DEMUX_INFO_T;


typedef struct _MFW_GST_MPG2DEMUX_INFO_CLASS_T {
    GstElementClass parent_class;

    guint track_signal_id;    

} MFW_GST_MPG2DEMUX_INFO_CLASS_T;

typedef struct track_info {
    gint audio_track_num;
    gint video_track_num;
} TRACK_INFO_T;

/*=============================================================================
                           GLOBAL VARIABLE DECLARATIONS
=============================================================================*/

/* None. */

/*=============================================================================
                            FUNCTION PROTOTYPES
=============================================================================*/
GType mfw_gst_type_mpg2_demuxer_get_type(void);

/*===========================================================================*/
G_END_DECLS
#endif /*__MFW_GST_MPG2_DEMUXER_H__*/
